/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.event.mapper;

import java.util.Dictionary;
import java.util.Hashtable;
import org.eclipse.equinox.event.mapper.BundleEventAdapter;
import org.eclipse.equinox.event.mapper.ConfigurationEventAdapter;
import org.eclipse.equinox.event.mapper.FrameworkEventAdapter;
import org.eclipse.equinox.event.mapper.LogEntryAdapter;
import org.eclipse.equinox.event.mapper.LogReaderServiceListener;
import org.eclipse.equinox.event.mapper.LogReaderServiceTracker;
import org.eclipse.equinox.event.mapper.ServiceEventAdapter;
import org.eclipse.equinox.event.mapper.UPnPEventAdapter;
import org.eclipse.equinox.event.mapper.UserAdminEventAdapter;
import org.eclipse.equinox.event.mapper.WireAdminEventAdapter;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleEvent;
import org.osgi.framework.BundleListener;
import org.osgi.framework.Filter;
import org.osgi.framework.FrameworkEvent;
import org.osgi.framework.FrameworkListener;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceEvent;
import org.osgi.framework.ServiceListener;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.cm.ConfigurationEvent;
import org.osgi.service.cm.ConfigurationListener;
import org.osgi.service.event.EventAdmin;
import org.osgi.service.log.LogEntry;
import org.osgi.service.log.LogListener;
import org.osgi.service.log.LogReaderService;
import org.osgi.service.upnp.UPnPEventListener;
import org.osgi.service.useradmin.UserAdminEvent;
import org.osgi.service.useradmin.UserAdminListener;
import org.osgi.service.wireadmin.WireAdminEvent;
import org.osgi.service.wireadmin.WireAdminListener;
import org.osgi.util.tracker.ServiceTracker;

public class EventRedeliverer
implements FrameworkListener,
BundleListener,
ServiceListener,
LogListener,
LogReaderServiceListener,
ConfigurationListener,
WireAdminListener,
UPnPEventListener,
UserAdminListener {
    private ServiceTracker eventAdminTracker;
    private LogReaderServiceTracker logTracker;
    private LogReaderService reader;
    private static final boolean DEBUG = false;
    private BundleContext bc;
    private ServiceRegistration configurationListenerReg;
    private ServiceRegistration wireAdminListenerReg;
    private ServiceRegistration upnpEventListenerReg;
    private ServiceRegistration userAdminListenerReg;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;
    static /* synthetic */ Class class$3;
    static /* synthetic */ Class class$4;

    public EventRedeliverer(BundleContext bc) {
        this.bc = bc;
    }

    public void close() {
        if (this.logTracker != null) {
            this.logTracker.close();
            this.logTracker = null;
        }
        if (this.eventAdminTracker != null) {
            this.eventAdminTracker.close();
            this.eventAdminTracker = null;
        }
        if (this.reader != null) {
            this.reader.removeLogListener((LogListener)this);
        }
        this.reader = null;
        this.bc.removeFrameworkListener((FrameworkListener)this);
        this.bc.removeBundleListener((BundleListener)this);
        this.bc.removeServiceListener((ServiceListener)this);
        if (this.configurationListenerReg != null) {
            this.configurationListenerReg.unregister();
            this.configurationListenerReg = null;
        }
        if (this.wireAdminListenerReg != null) {
            this.wireAdminListenerReg.unregister();
            this.wireAdminListenerReg = null;
        }
        if (this.upnpEventListenerReg != null) {
            this.upnpEventListenerReg.unregister();
            this.upnpEventListenerReg = null;
        }
        if (this.userAdminListenerReg != null) {
            this.userAdminListenerReg.unregister();
            this.userAdminListenerReg = null;
        }
    }

    public void open() {
        Class<?> clazz;
        Class<?> clazz2 = class$0;
        if (clazz2 == null) {
            try {
                clazz2 = class$0 = Class.forName("org.osgi.service.event.EventAdmin");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.eventAdminTracker = new ServiceTracker(this.bc, clazz2.getName(), null);
        this.eventAdminTracker.open();
        this.logTracker = new LogReaderServiceTracker(this.bc, this);
        this.logTracker.open();
        this.bc.addFrameworkListener((FrameworkListener)this);
        this.bc.addBundleListener((BundleListener)this);
        this.bc.addServiceListener((ServiceListener)this);
        Class<?> clazz3 = class$1;
        if (clazz3 == null) {
            try {
                clazz3 = class$1 = Class.forName("org.osgi.service.cm.ConfigurationListener");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.configurationListenerReg = this.bc.registerService(clazz3.getName(), (Object)this, null);
        Hashtable<String, Integer> ht = new Hashtable<String, Integer>();
        Integer mask = new Integer(255);
        ht.put("wireadmin.events", mask);
        Class<?> clazz4 = class$2;
        if (clazz4 == null) {
            try {
                clazz4 = class$2 = Class.forName("org.osgi.service.wireadmin.WireAdminListener");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.wireAdminListenerReg = this.bc.registerService(clazz4.getName(), (Object)this, ht);
        Hashtable<String, Filter> ht2 = new Hashtable<String, Filter>();
        Filter filter = null;
        try {
            filter = this.bc.createFilter("(|(|(UPnP.device.type=*)(UPnP.device.UDN=*))(|(UPnP.service.type=*)(UPnP.service.id=*)))");
        }
        catch (InvalidSyntaxException e) {
            System.out.println("Exception thrown while trying to create Filter. " + (Object)((Object)e));
            e.printStackTrace(System.out);
        }
        if (filter != null) {
            ht2.put("upnp.filter", filter);
            Class<?> clazz5 = class$3;
            if (clazz5 == null) {
                try {
                    clazz5 = class$3 = Class.forName("org.osgi.service.upnp.UPnPEventListener");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            this.upnpEventListenerReg = this.bc.registerService(clazz5.getName(), (Object)this, ht2);
        }
        if ((clazz = class$4) == null) {
            try {
                clazz = class$4 = Class.forName("org.osgi.service.useradmin.UserAdminListener");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.userAdminListenerReg = this.bc.registerService(clazz.getName(), (Object)this, null);
    }

    private EventAdmin getEventAdmin() {
        if (this.eventAdminTracker == null) {
            return null;
        }
        return (EventAdmin)this.eventAdminTracker.getService();
    }

    public void frameworkEvent(FrameworkEvent event) {
        EventAdmin eventAdmin = this.getEventAdmin();
        if (eventAdmin != null) {
            new FrameworkEventAdapter(event, eventAdmin).redeliver();
        } else {
            this.printNoEventAdminError();
        }
    }

    private void printNoEventAdminError() {
    }

    public void bundleChanged(BundleEvent event) {
        EventAdmin eventAdmin = this.getEventAdmin();
        if (eventAdmin != null) {
            new BundleEventAdapter(event, eventAdmin).redeliver();
        } else {
            this.printNoEventAdminError();
        }
    }

    public void serviceChanged(ServiceEvent event) {
        EventAdmin eventAdmin = this.getEventAdmin();
        if (eventAdmin != null) {
            new ServiceEventAdapter(event, eventAdmin).redeliver();
        } else {
            this.printNoEventAdminError();
        }
    }

    public void logged(LogEntry entry) {
        EventAdmin eventAdmin = this.getEventAdmin();
        if (eventAdmin != null) {
            new LogEntryAdapter(entry, eventAdmin).redeliver();
        } else {
            this.printNoEventAdminError();
        }
    }

    public void logReaderServiceAdding(ServiceReference reference, LogReaderService service) {
        if (this.reader != null) {
            return;
        }
        this.reader = service;
        this.reader.addLogListener((LogListener)this);
    }

    public void logReaderServiceRemoved(ServiceReference reference, LogReaderService service) {
        if (this.reader != null && this.reader.equals(service)) {
            this.reader.removeLogListener((LogListener)this);
            this.reader = null;
        }
    }

    public void configurationEvent(ConfigurationEvent event) {
        EventAdmin eventAdmin = this.getEventAdmin();
        if (eventAdmin != null) {
            new ConfigurationEventAdapter(event, eventAdmin).redeliver();
        } else {
            this.printNoEventAdminError();
        }
    }

    public void wireAdminEvent(WireAdminEvent event) {
        EventAdmin eventAdmin = this.getEventAdmin();
        if (eventAdmin != null) {
            new WireAdminEventAdapter(event, eventAdmin).redeliver();
        } else {
            this.printNoEventAdminError();
        }
    }

    public void notifyUPnPEvent(String deviceId, String serviceId, Dictionary events) {
        EventAdmin eventAdmin = this.getEventAdmin();
        if (eventAdmin != null) {
            new UPnPEventAdapter(deviceId, serviceId, events, eventAdmin).redeliver();
        } else {
            this.printNoEventAdminError();
        }
    }

    public void roleChanged(UserAdminEvent event) {
        EventAdmin eventAdmin = this.getEventAdmin();
        if (eventAdmin != null) {
            new UserAdminEventAdapter(event, eventAdmin).redeliver();
        } else {
            this.printNoEventAdminError();
        }
    }
}

