/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.event.mapper;

import java.util.Hashtable;
import org.eclipse.equinox.event.mapper.EventAdapter;
import org.osgi.framework.Bundle;
import org.osgi.framework.FrameworkEvent;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventAdmin;

public class FrameworkEventAdapter
extends EventAdapter {
    public static final String HEADER = "org/osgi/framework/FrameworkEvent";
    public static final String STARTLEVEL_CHANGED = "STARTLEVEL_CHANGED";
    public static final String STARTED = "STARTED";
    public static final String PACKAGES_REFRESHED = "PACKAGES_REFRESHED";
    public static final String ERROR = "ERROR";
    protected FrameworkEvent event;

    public FrameworkEventAdapter(FrameworkEvent event, EventAdmin eventAdmin) {
        super(eventAdmin);
        this.event = event;
    }

    public Event convert() {
        Throwable t;
        String typename = null;
        switch (this.event.getType()) {
            case 2: {
                typename = ERROR;
                break;
            }
            case 4: {
                typename = PACKAGES_REFRESHED;
                break;
            }
            case 1: {
                typename = STARTED;
                break;
            }
            case 8: {
                typename = STARTLEVEL_CHANGED;
                break;
            }
            default: {
                return null;
            }
        }
        String topic = "org/osgi/framework/FrameworkEvent/" + typename;
        Hashtable<String, FrameworkEvent> properties = new Hashtable<String, FrameworkEvent>();
        Bundle bundle = this.event.getBundle();
        if (bundle != null) {
            this.putBundleProperties(properties, bundle);
        }
        if ((t = this.event.getThrowable()) != null) {
            this.putExceptionProperties(properties, t);
        }
        properties.put("event", this.event);
        Event converted = new Event(topic, properties);
        return converted;
    }
}

