/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.event.mapper;

import java.util.Hashtable;
import org.eclipse.equinox.event.mapper.EventAdapter;
import org.osgi.framework.ServiceReference;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventAdmin;
import org.osgi.service.useradmin.Role;
import org.osgi.service.useradmin.UserAdminEvent;

public class UserAdminEventAdapter
extends EventAdapter {
    public static final String TOPIC = "org/osgi/service/useradmin/UserAdminEvent";
    public static final String ROLE_CREATED = "ROLE_CREATED";
    public static final String ROLE_CHANGED = "ROLE_CHANGED";
    public static final String ROLE_REMOVED = "ROLE_REMOVED";
    public static final String ROLE = "role";
    public static final String ROLE_NAME = "role.name";
    public static final String ROLE_TYPE = "role.type";
    private UserAdminEvent event;

    public UserAdminEventAdapter(UserAdminEvent event, EventAdmin eventAdmin) {
        super(eventAdmin);
        this.event = event;
    }

    public Event convert() {
        String typename = null;
        switch (this.event.getType()) {
            case 1: {
                typename = ROLE_CREATED;
                break;
            }
            case 2: {
                typename = ROLE_CHANGED;
                break;
            }
            case 4: {
                typename = ROLE_REMOVED;
                break;
            }
            default: {
                return null;
            }
        }
        String topic = "org/osgi/service/useradmin/UserAdminEvent/" + typename;
        Hashtable<String, Object> properties = new Hashtable<String, Object>();
        ServiceReference ref = this.event.getServiceReference();
        if (ref == null) {
            throw new RuntimeException("UserAdminEvent's getServiceReference() returns null.");
        }
        this.putServiceReferenceProperties(properties, ref);
        Role role = this.event.getRole();
        if (role == null) {
            throw new RuntimeException("UserAdminEvent's getRole() returns null.");
        }
        if (role != null) {
            properties.put(ROLE, role);
            properties.put(ROLE_NAME, role.getName());
            properties.put(ROLE_TYPE, new Integer(role.getType()));
        }
        properties.put("event", this.event);
        Event converted = new Event(topic, properties);
        return converted;
    }
}

