/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.event.mapper;

import java.util.Hashtable;
import org.eclipse.equinox.event.mapper.EventAdapter;
import org.osgi.framework.ServiceReference;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventAdmin;
import org.osgi.service.wireadmin.Wire;
import org.osgi.service.wireadmin.WireAdminEvent;

public class WireAdminEventAdapter
extends EventAdapter {
    public static final String TOPIC = "org/osgi/service/wireadmin/WireAdminEvent";
    public static final String WIRE_CREATED = "WIRE_CREATED";
    public static final String WIRE_CONNECTED_T = "WIRE_CONNECTED";
    public static final String WIRE_UPDATED = "WIRE_UPDATED";
    public static final String WIRE_TRACE = "WIRE_TRACE";
    public static final String WIRE_DISCONNECTED = "WIRE_DISCONNECTED";
    public static final String WIRE_DELETED = "WIRE_DELETED";
    public static final String PRODUCER_EXCEPTION = "PRODUCER_EXCEPTION";
    public static final String CONSUMER_EXCEPTION = "CONSUMER_EXCEPTION";
    public static final String WIRE = "wire";
    public static final String WIRE_FLAVORS = "wire.flavors";
    public static final String WIRE_SCOPE = "wire.scope";
    public static final String WIRE_CONNECTED_P = "wire.connected";
    public static final String WIRE_VALID = "wire.valid";
    private WireAdminEvent event;

    public WireAdminEventAdapter(WireAdminEvent event, EventAdmin admin) {
        super(admin);
        this.event = event;
    }

    public Event convert() {
        ServiceReference ref;
        String typename = null;
        switch (this.event.getType()) {
            case 32: {
                typename = WIRE_CONNECTED_T;
                break;
            }
            case 4: {
                typename = WIRE_CREATED;
                break;
            }
            case 8: {
                typename = WIRE_UPDATED;
                break;
            }
            case 16: {
                typename = WIRE_DELETED;
                break;
            }
            case 64: {
                typename = WIRE_DISCONNECTED;
                break;
            }
            case 128: {
                typename = WIRE_TRACE;
                break;
            }
            case 1: {
                typename = PRODUCER_EXCEPTION;
                break;
            }
            case 2: {
                typename = CONSUMER_EXCEPTION;
                break;
            }
            default: {
                return null;
            }
        }
        String topic = "org/osgi/service/wireadmin/WireAdminEvent/" + typename;
        Hashtable<String, Object> properties = new Hashtable<String, Object>();
        Throwable t = this.event.getThrowable();
        if (t != null) {
            this.putExceptionProperties(properties, t);
        }
        if ((ref = this.event.getServiceReference()) == null) {
            throw new RuntimeException("WireAdminEvent's getServiceReference() returns null.");
        }
        this.putServiceReferenceProperties(properties, ref);
        Wire wire = this.event.getWire();
        if (wire != null) {
            properties.put(WIRE, wire);
            if (wire.getFlavors() != null) {
                properties.put(WIRE_FLAVORS, this.classes2strings(wire.getFlavors()));
            }
            if (wire.getScope() != null) {
                properties.put(WIRE_SCOPE, wire.getScope());
            }
            properties.put(WIRE_CONNECTED_P, new Boolean(wire.isConnected()));
            properties.put(WIRE_VALID, new Boolean(wire.isValid()));
        }
        properties.put("event", this.event);
        Event converted = new Event(topic, properties);
        return converted;
    }
}

