/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.refactoring;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.WorkingCopyOwner;
import org.eclipse.jdt.core.search.IJavaSearchScope;
import org.eclipse.jdt.core.search.SearchEngine;
import org.eclipse.jdt.core.search.SearchMatch;
import org.eclipse.jdt.core.search.SearchPattern;
import org.eclipse.jdt.core.search.SearchRequestor;
import org.eclipse.jdt.internal.corext.refactoring.IRefactoringSearchRequestor;
import org.eclipse.jdt.internal.corext.refactoring.RefactoringCoreMessages;
import org.eclipse.jdt.internal.corext.refactoring.RefactoringSearchEngine;
import org.eclipse.jdt.internal.corext.refactoring.SearchResultGroup;
import org.eclipse.jdt.internal.corext.util.Messages;
import org.eclipse.jdt.internal.corext.util.SearchUtils;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;

public final class RefactoringSearchEngine2 {
    public static final int GRANULARITY_COMPILATION_UNIT = 2;
    public static final int GRANULARITY_SEARCH_MATCH = 1;
    private boolean fBinary = false;
    private RefactoringSearchCollector fCollector = null;
    private int fGranularity = 1;
    private boolean fGrouping = true;
    private boolean fInaccurate = true;
    private WorkingCopyOwner fOwner = null;
    private SearchPattern fPattern = null;
    private IRefactoringSearchRequestor fRequestor = new DefaultSearchRequestor();
    private IJavaSearchScope fScope = SearchEngine.createWorkspaceScope();
    private int fSeverity = 2;
    private RefactoringStatus fStatus = new RefactoringStatus();

    public RefactoringSearchEngine2() {
    }

    public RefactoringSearchEngine2(SearchPattern pattern) {
        Assert.isNotNull((Object)pattern);
        this.fPattern = pattern;
    }

    public final void clearResults() {
        this.getCollector().clearResults();
        this.fStatus = new RefactoringStatus();
    }

    public final ICompilationUnit[] getAffectedCompilationUnits() {
        if (this.fGranularity == 2) {
            Collection collection = this.getCollector().getCollectedMatches();
            ICompilationUnit[] units = new ICompilationUnit[collection.size()];
            int index = 0;
            Iterator iterator = collection.iterator();
            while (iterator.hasNext()) {
                units[index] = (ICompilationUnit)iterator.next();
                ++index;
            }
            return units;
        }
        SearchResultGroup[] groups = this.getGroupedMatches();
        ICompilationUnit[] units = new ICompilationUnit[groups.length];
        int index = 0;
        while (index < groups.length) {
            units[index] = groups[index].getCompilationUnit();
            ++index;
        }
        return units;
    }

    public final Map getAffectedProjects() {
        HashMap<IJavaProject, HashSet<Object>> map = new HashMap<IJavaProject, HashSet<Object>>();
        IJavaProject project = null;
        ICompilationUnit unit = null;
        if (this.fGranularity == 2) {
            ICompilationUnit[] units = this.getAffectedCompilationUnits();
            int index = 0;
            while (index < units.length) {
                unit = units[index];
                project = unit.getJavaProject();
                if (project != null) {
                    HashSet<ICompilationUnit> set = (HashSet<ICompilationUnit>)map.get(project);
                    if (set == null) {
                        set = new HashSet<ICompilationUnit>();
                        map.put(project, set);
                    }
                    set.add(unit);
                }
                ++index;
            }
        } else {
            SearchResultGroup[] groups = this.getGroupedMatches();
            SearchResultGroup group = null;
            int index = 0;
            while (index < groups.length) {
                group = groups[index];
                unit = group.getCompilationUnit();
                if (unit != null && (project = unit.getJavaProject()) != null) {
                    HashSet<SearchResultGroup> set = (HashSet<SearchResultGroup>)map.get(project);
                    if (set == null) {
                        set = new HashSet<SearchResultGroup>();
                        map.put(project, set);
                    }
                    set.add(group);
                }
                ++index;
            }
        }
        return map;
    }

    private RefactoringSearchCollector getCollector() {
        if (this.fCollector == null) {
            if (this.fGranularity == 2) {
                this.fCollector = new RefactoringCompilationUnitCollector();
            } else if (this.fGranularity == 1) {
                this.fCollector = new RefactoringSearchMatchCollector();
            } else {
                Assert.isTrue((boolean)false);
            }
        }
        return this.fCollector;
    }

    private SearchResultGroup[] getGroupedMatches() {
        HashMap grouped = new HashMap();
        List matches = null;
        IResource resource = null;
        SearchMatch match = null;
        Iterator iterator = this.getSearchMatches().iterator();
        while (iterator.hasNext()) {
            match = (SearchMatch)iterator.next();
            resource = match.getResource();
            if (!grouped.containsKey(resource)) {
                grouped.put(resource, new ArrayList(4));
            }
            matches = (List)grouped.get(resource);
            matches.add(match);
        }
        if (this.fBinary) {
            Collection collection = this.getCollector().getBinaryResources();
            Iterator iterator2 = grouped.keySet().iterator();
            while (iterator2.hasNext()) {
                resource = (IResource)iterator2.next();
                if (!collection.contains(resource)) continue;
                iterator2.remove();
            }
        }
        SearchResultGroup[] result = new SearchResultGroup[grouped.keySet().size()];
        int index = 0;
        Iterator iterator3 = grouped.keySet().iterator();
        while (iterator3.hasNext()) {
            resource = (IResource)iterator3.next();
            matches = (List)grouped.get(resource);
            result[index++] = new SearchResultGroup(resource, matches.toArray(new SearchMatch[matches.size()]));
        }
        return result;
    }

    public final SearchPattern getPattern() {
        return this.fPattern;
    }

    public final Object[] getResults() {
        if (this.fGranularity == 2) {
            return this.getAffectedCompilationUnits();
        }
        if (this.fGrouping) {
            return this.getGroupedMatches();
        }
        return this.getUngroupedMatches();
    }

    private Collection getSearchMatches() {
        LinkedList results = null;
        if (this.fInaccurate) {
            results = new LinkedList(this.getCollector().getCollectedMatches());
            Collection collection = this.getCollector().getInaccurateMatches();
            SearchMatch match = null;
            Iterator iterator = results.iterator();
            while (iterator.hasNext()) {
                match = (SearchMatch)iterator.next();
                if (!collection.contains(match)) continue;
                iterator.remove();
            }
        } else {
            results = this.getCollector().getCollectedMatches();
        }
        return results;
    }

    public final RefactoringStatus getStatus() {
        return this.fStatus;
    }

    private SearchMatch[] getUngroupedMatches() {
        LinkedList results = null;
        if (this.fBinary) {
            results = new LinkedList(this.getSearchMatches());
            Collection collection = this.getCollector().getBinaryResources();
            SearchMatch match = null;
            Iterator iterator = results.iterator();
            while (iterator.hasNext()) {
                match = (SearchMatch)iterator.next();
                if (!collection.contains(match.getResource())) continue;
                iterator.remove();
            }
        } else {
            results = this.getSearchMatches();
        }
        SearchMatch[] matches = new SearchMatch[results.size()];
        results.toArray(matches);
        return matches;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final void searchPattern(IProgressMonitor monitor) throws JavaModelException {
        Assert.isNotNull((Object)this.fPattern);
        try {
            monitor.beginTask("", 1);
            monitor.setTaskName(RefactoringCoreMessages.RefactoringSearchEngine_searching_occurrences);
            try {
                SearchEngine engine = null;
                engine = this.fOwner != null ? new SearchEngine(this.fOwner) : new SearchEngine();
                engine.search(this.fPattern, SearchUtils.getDefaultSearchParticipants(), this.fScope, (SearchRequestor)this.getCollector(), (IProgressMonitor)new SubProgressMonitor(monitor, 1, 2));
            }
            catch (CoreException exception) {
                throw new JavaModelException(exception);
            }
        }
        catch (Throwable throwable) {
            Object var3_5 = null;
            monitor.done();
            throw throwable;
        }
        {
            Object var3_6 = null;
        }
        monitor.done();
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final void searchReferencedFields(IJavaElement element, IProgressMonitor monitor) throws JavaModelException {
        Assert.isNotNull((Object)element);
        try {
            monitor.beginTask("", 1);
            monitor.setTaskName(RefactoringCoreMessages.RefactoringSearchEngine_searching_referenced_fields);
            try {
                SearchEngine engine = null;
                engine = this.fOwner != null ? new SearchEngine(this.fOwner) : new SearchEngine();
                engine.searchDeclarationsOfAccessedFields(element, (SearchRequestor)this.getCollector(), (IProgressMonitor)new SubProgressMonitor(monitor, 1, 2));
            }
            catch (CoreException exception) {
                throw new JavaModelException(exception);
            }
        }
        catch (Throwable throwable) {
            Object var4_6 = null;
            monitor.done();
            throw throwable;
        }
        {
            Object var4_7 = null;
        }
        monitor.done();
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final void searchReferencedMethods(IJavaElement element, IProgressMonitor monitor) throws JavaModelException {
        Assert.isNotNull((Object)element);
        try {
            monitor.beginTask("", 1);
            monitor.setTaskName(RefactoringCoreMessages.RefactoringSearchEngine_searching_referenced_methods);
            try {
                SearchEngine engine = null;
                engine = this.fOwner != null ? new SearchEngine(this.fOwner) : new SearchEngine();
                engine.searchDeclarationsOfSentMessages(element, (SearchRequestor)this.getCollector(), (IProgressMonitor)new SubProgressMonitor(monitor, 1, 2));
            }
            catch (CoreException exception) {
                throw new JavaModelException(exception);
            }
        }
        catch (Throwable throwable) {
            Object var4_6 = null;
            monitor.done();
            throw throwable;
        }
        {
            Object var4_7 = null;
        }
        monitor.done();
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final void searchReferencedTypes(IJavaElement element, IProgressMonitor monitor) throws JavaModelException {
        Assert.isNotNull((Object)element);
        try {
            monitor.beginTask("", 1);
            monitor.setTaskName(RefactoringCoreMessages.RefactoringSearchEngine_searching_referenced_types);
            try {
                SearchEngine engine = null;
                engine = this.fOwner != null ? new SearchEngine(this.fOwner) : new SearchEngine();
                engine.searchDeclarationsOfReferencedTypes(element, (SearchRequestor)this.getCollector(), (IProgressMonitor)new SubProgressMonitor(monitor, 1, 2));
            }
            catch (CoreException exception) {
                throw new JavaModelException(exception);
            }
        }
        catch (Throwable throwable) {
            Object var4_6 = null;
            monitor.done();
            throw throwable;
        }
        {
            Object var4_7 = null;
        }
        monitor.done();
    }

    public final void setAndPattern(SearchPattern first, SearchPattern second) {
        Assert.isNotNull((Object)first);
        Assert.isNotNull((Object)second);
        this.fPattern = SearchPattern.createAndPattern((SearchPattern)first, (SearchPattern)second);
    }

    public final void setFiltering(boolean inaccurate, boolean binary) {
        this.fInaccurate = inaccurate;
        this.fBinary = binary;
    }

    public final void setGranularity(int granularity) {
        Assert.isTrue((granularity == 2 || granularity == 1 ? 1 : 0) != 0);
        this.fGranularity = granularity;
    }

    public final void setGrouping(boolean grouping) {
        this.fGrouping = grouping;
    }

    public final void setOrPattern(SearchPattern first, SearchPattern second) {
        Assert.isNotNull((Object)first);
        Assert.isNotNull((Object)second);
        this.fPattern = SearchPattern.createOrPattern((SearchPattern)first, (SearchPattern)second);
    }

    public final void setOwner(WorkingCopyOwner owner) {
        this.fOwner = owner;
    }

    public final void setPattern(IJavaElement[] elements, int limitTo) {
        Assert.isNotNull((Object)elements);
        Assert.isTrue((elements.length > 0 ? 1 : 0) != 0);
        SearchPattern pattern = SearchPattern.createPattern((IJavaElement)elements[0], (int)limitTo, (int)24);
        IJavaElement element = null;
        int index = 1;
        while (index < elements.length) {
            element = elements[index];
            pattern = SearchPattern.createOrPattern((SearchPattern)pattern, (SearchPattern)SearchPattern.createPattern((IJavaElement)element, (int)limitTo, (int)24));
            ++index;
        }
        this.setPattern(pattern);
    }

    public final void setPattern(SearchPattern pattern) {
        Assert.isNotNull((Object)pattern);
        this.fPattern = pattern;
    }

    public final void setRequestor(IRefactoringSearchRequestor requestor) {
        Assert.isNotNull((Object)requestor);
        this.fRequestor = requestor;
    }

    public final void setScope(IJavaSearchScope scope) {
        Assert.isNotNull((Object)scope);
        this.fScope = scope;
    }

    public final void setSeverity(int severity) {
        Assert.isTrue((severity == 2 || severity == 1 || severity == 4 || severity == 3 ? 1 : 0) != 0);
        this.fSeverity = severity;
    }

    public final void setStatus(RefactoringStatus status) {
        Assert.isNotNull((Object)status);
        this.fStatus = status;
    }

    private static class DefaultSearchRequestor
    implements IRefactoringSearchRequestor {
        private DefaultSearchRequestor() {
        }

        public final SearchMatch acceptSearchMatch(SearchMatch match) {
            return match;
        }
    }

    private class RefactoringCompilationUnitCollector
    extends RefactoringSearchCollector {
        private final Set fCollectedUnits = new HashSet();
        private final Set fInaccurateMatches = new HashSet();

        private RefactoringCompilationUnitCollector() {
        }

        public final void acceptSearchMatch(SearchMatch match) throws CoreException {
            if (RefactoringSearchEngine.isFiltered(match)) {
                return;
            }
            SearchMatch accepted = RefactoringSearchEngine2.this.fRequestor.acceptSearchMatch(match);
            if (accepted != null) {
                IJavaElement element;
                IResource resource = accepted.getResource();
                if (!resource.equals((Object)this.fLastResource) && (element = JavaCore.create((IResource)resource)) instanceof ICompilationUnit) {
                    this.fCollectedUnits.add(element);
                }
                if (RefactoringSearchEngine2.this.fInaccurate && accepted.getAccuracy() == 1 && !this.fInaccurateMatches.contains(accepted)) {
                    RefactoringSearchEngine2.this.fStatus.addEntry(RefactoringSearchEngine2.this.fSeverity, Messages.format(RefactoringCoreMessages.RefactoringSearchEngine_inaccurate_match, accepted.getResource().getName()), null, null, -1);
                    this.fInaccurateMatches.add(accepted);
                }
            }
        }

        public final void clearResults() {
            super.clearResults();
            this.fCollectedUnits.clear();
            this.fInaccurateMatches.clear();
        }

        public final Collection getBinaryResources() {
            return Collections.EMPTY_SET;
        }

        public final Collection getCollectedMatches() {
            return this.fCollectedUnits;
        }

        public final Collection getInaccurateMatches() {
            return this.fInaccurateMatches;
        }
    }

    private abstract class RefactoringSearchCollector
    extends SearchRequestor {
        protected IResource fLastResource = null;

        private RefactoringSearchCollector() {
        }

        public void clearResults() {
            this.fLastResource = null;
        }

        public abstract Collection getBinaryResources();

        public abstract Collection getCollectedMatches();

        public abstract Collection getInaccurateMatches();
    }

    private class RefactoringSearchMatchCollector
    extends RefactoringSearchCollector {
        private final Set fBinaryResources = new HashSet();
        private final List fCollectedMatches = new ArrayList();
        private final Set fInaccurateMatches = new HashSet();

        private RefactoringSearchMatchCollector() {
        }

        public final void acceptSearchMatch(SearchMatch match) throws CoreException {
            if (RefactoringSearchEngine.isFiltered(match)) {
                return;
            }
            SearchMatch accepted = RefactoringSearchEngine2.this.fRequestor.acceptSearchMatch(match);
            if (accepted != null) {
                this.fCollectedMatches.add(accepted);
                IResource resource = accepted.getResource();
                if (!resource.equals((Object)this.fLastResource)) {
                    IJavaElement element;
                    if (RefactoringSearchEngine2.this.fBinary && !((element = JavaCore.create((IResource)resource)) instanceof ICompilationUnit)) {
                        IProject project = resource.getProject();
                        if (!RefactoringSearchEngine2.this.fGrouping) {
                            RefactoringSearchEngine2.this.fStatus.addEntry(RefactoringSearchEngine2.this.fSeverity, Messages.format(RefactoringCoreMessages.RefactoringSearchEngine_binary_match_ungrouped, project.getName()), null, null, -1);
                        } else if (!this.fBinaryResources.contains(resource)) {
                            RefactoringSearchEngine2.this.fStatus.addEntry(RefactoringSearchEngine2.this.fSeverity, Messages.format(RefactoringCoreMessages.RefactoringSearchEngine_binary_match_grouped, project.getName()), null, null, -1);
                        }
                        this.fBinaryResources.add(resource);
                    }
                    if (RefactoringSearchEngine2.this.fInaccurate && accepted.getAccuracy() == 1 && !this.fInaccurateMatches.contains(accepted)) {
                        RefactoringSearchEngine2.this.fStatus.addEntry(RefactoringSearchEngine2.this.fSeverity, Messages.format(RefactoringCoreMessages.RefactoringSearchEngine_inaccurate_match, resource.getName()), null, null, -1);
                        this.fInaccurateMatches.add(accepted);
                    }
                }
            }
        }

        public final void clearResults() {
            super.clearResults();
            this.fCollectedMatches.clear();
            this.fInaccurateMatches.clear();
            this.fBinaryResources.clear();
        }

        public final Collection getBinaryResources() {
            return this.fBinaryResources;
        }

        public final Collection getCollectedMatches() {
            return this.fCollectedMatches;
        }

        public final Collection getInaccurateMatches() {
            return this.fInaccurateMatches;
        }
    }
}

