/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.compare;

import java.lang.reflect.InvocationTargetException;
import java.util.ResourceBundle;
import org.eclipse.compare.EditionSelectionDialog;
import org.eclipse.compare.IStreamContentAccessor;
import org.eclipse.compare.ITypedElement;
import org.eclipse.compare.structuremergeviewer.DocumentRangeNode;
import org.eclipse.core.filebuffers.FileBuffers;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.AnnotationTypeDeclaration;
import org.eclipse.jdt.core.dom.BodyDeclaration;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.EnumDeclaration;
import org.eclipse.jdt.core.dom.FieldDeclaration;
import org.eclipse.jdt.core.dom.ImportDeclaration;
import org.eclipse.jdt.core.dom.PackageDeclaration;
import org.eclipse.jdt.core.dom.StructuralPropertyDescriptor;
import org.eclipse.jdt.core.dom.TypeDeclaration;
import org.eclipse.jdt.core.dom.rewrite.ASTRewrite;
import org.eclipse.jdt.internal.corext.dom.ASTNodes;
import org.eclipse.jdt.internal.corext.util.Resources;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.compare.CompareMessages;
import org.eclipse.jdt.internal.ui.compare.JavaCompareUtilities;
import org.eclipse.jdt.internal.ui.compare.JavaHistoryActionImpl;
import org.eclipse.jdt.internal.ui.compare.JavaNode;
import org.eclipse.jdt.internal.ui.compare.JavaTextBufferNode;
import org.eclipse.jdt.internal.ui.javaeditor.JavaEditor;
import org.eclipse.jdt.internal.ui.javaeditor.WorkingCopyManager;
import org.eclipse.jdt.internal.ui.util.ExceptionHandler;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.TextUtilities;
import org.eclipse.jface.util.Assert;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;

class JavaAddElementFromHistoryImpl
extends JavaHistoryActionImpl {
    private static final String BUNDLE_NAME = "org.eclipse.jdt.internal.ui.compare.AddFromHistoryAction";

    JavaAddElementFromHistoryImpl() {
        super(true);
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run(ISelection selection) {
        block31: {
            block30: {
                block33: {
                    block32: {
                        errorTitle = CompareMessages.AddFromHistory_title;
                        errorMessage = CompareMessages.AddFromHistory_internalErrorMessage;
                        shell = this.getShell();
                        cu = null;
                        parent = null;
                        input = null;
                        if (!selection.isEmpty()) break block32;
                        editor = this.getEditor();
                        if (editor != null) {
                            editorInput = editor.getEditorInput();
                            manager = JavaPlugin.getDefault().getWorkingCopyManager();
                            if (manager != null) {
                                cu = manager.getWorkingCopy(editorInput);
                                parent = cu;
                            }
                        }
                        break block33;
                    }
                    input = this.getEditionElement(selection);
                    if (input != null) {
                        cu = input.getCompilationUnit();
                        if (input != null) {
                            parent = input;
                            input = null;
                        }
                    } else if (selection instanceof IStructuredSelection && (o = ((IStructuredSelection)selection).getFirstElement()) instanceof ICompilationUnit) {
                        cu = (ICompilationUnit)o;
                        parent = cu;
                    }
                }
                if (parent == null || cu == null) {
                    invalidSelectionMessage = CompareMessages.AddFromHistory_invalidSelectionMessage;
                    MessageDialog.openInformation((Shell)shell, (String)errorTitle, (String)invalidSelectionMessage);
                    return;
                }
                file = this.getFile(parent);
                if (file == null) {
                    MessageDialog.openError((Shell)shell, (String)errorTitle, (String)errorMessage);
                    return;
                }
                inEditor = this.beingEdited(file);
                status = Resources.makeCommittable((IResource)file, (Object)shell);
                if (!status.isOK()) {
                    return;
                }
                path = file.getFullPath();
                bufferManager = FileBuffers.getTextFileBufferManager();
                textFileBuffer = null;
                try {
                    try {
                        bufferManager.connect(path, null);
                        textFileBuffer = bufferManager.getTextFileBuffer(path);
                        document = textFileBuffer.getDocument();
                        target = new JavaTextBufferNode(file, document, inEditor);
                        editions = this.buildEditions(target, file);
                        bundle = ResourceBundle.getBundle("org.eclipse.jdt.internal.ui.compare.AddFromHistoryAction");
                        d = new EditionSelectionDialog(shell, bundle);
                        d.setAddMode(true);
                        d.setHelpContextId("org.eclipse.jdt.ui.add_element_from_history_dialog_context");
                        selected = d.selectEdition((ITypedElement)target, editions, (Object)parent);
                        if (selected == null) {
lbl58:
                            // 2 sources

                            while (true) {
                                var30_23 = null;
                                break block30;
                                break;
                            }
                        }
                        cu2 = cu;
                        if (parent instanceof IMember) {
                            cu2 = parent.getCompilationUnit();
                        }
                        root = JavaAddElementFromHistoryImpl.parsePartialCompilationUnit(cu2);
                        rewriter = ASTRewrite.create((AST)root.getAST());
                        results = d.getSelection();
                        i = 0;
                        while (true) {
                            block35: {
                                block38: {
                                    block37: {
                                        block36: {
                                            block34: {
                                                if (i >= results.length) {
                                                    options = null;
                                                    javaProject = cu2.getJavaProject();
                                                    if (javaProject != null) {
                                                        options = javaProject.getOptions(true);
                                                    }
                                                    this.applyChanges(rewriter, document, textFileBuffer, shell, inEditor, options);
                                                    break block31;
                                                }
                                                newNode = this.createASTNode(rewriter, results[i], TextUtilities.getDefaultLineDelimiter((IDocument)document), cu.getJavaProject());
                                                if (newNode == null) {
                                                    MessageDialog.openError((Shell)shell, (String)errorTitle, (String)errorMessage);
                                                    ** continue;
                                                }
                                                if (!(newNode instanceof PackageDeclaration)) break block34;
                                                rewriter.set((ASTNode)root, (StructuralPropertyDescriptor)CompilationUnit.PACKAGE_PROPERTY, (Object)newNode, null);
                                                break block35;
                                            }
                                            if (!(newNode instanceof ImportDeclaration)) break block36;
                                            lw = rewriter.getListRewrite((ASTNode)root, CompilationUnit.IMPORTS_PROPERTY);
                                            lw.insertFirst(newNode, null);
                                            break block35;
                                        }
                                        if (!(parent instanceof ICompilationUnit)) break block37;
                                        lw = rewriter.getListRewrite((ASTNode)root, CompilationUnit.TYPES_PROPERTY);
                                        index = ASTNodes.getInsertionIndex((BodyDeclaration)newNode, root.types());
                                        lw.insertAt(newNode, index, null);
                                        break block35;
                                    }
                                    if (!(parent instanceof IType)) break block38;
                                    declaration = this.getBodyContainer(root, (IMember)((IType)parent));
                                    if (declaration instanceof TypeDeclaration || declaration instanceof AnnotationTypeDeclaration) {
                                        container = ASTNodes.getBodyDeclarations(declaration);
                                        index = ASTNodes.getInsertionIndex((BodyDeclaration)newNode, container);
                                        lw = rewriter.getListRewrite(declaration, ASTNodes.getBodyDeclarationsProperty(declaration));
                                        lw.insertAt(newNode, index, null);
                                        break block35;
                                    } else if (declaration instanceof EnumDeclaration) {
                                        container = ((EnumDeclaration)declaration).enumConstants();
                                        index = ASTNodes.getInsertionIndex((BodyDeclaration)((FieldDeclaration)newNode), container);
                                        lw = rewriter.getListRewrite(declaration, EnumDeclaration.ENUM_CONSTANTS_PROPERTY);
                                        lw.insertAt(newNode, index, null);
                                    }
                                    break block35;
                                }
                                JavaPlugin.logErrorMessage("JavaAddElementFromHistoryImpl: unknown container " + parent);
                            }
                            ++i;
                        }
                    }
                    catch (InvocationTargetException ex) {
                        ExceptionHandler.handle(ex, shell, errorTitle, errorMessage);
                        break block31;
                    }
                    catch (InterruptedException v0) {
                        Assert.isTrue((boolean)false);
                        break block31;
                    }
                    catch (CoreException ex) {
                        ExceptionHandler.handle(ex, shell, errorTitle, errorMessage);
                        break block31;
                    }
                }
                catch (Throwable var31_42) {
                    var30_24 = null;
                    try {
                        if (textFileBuffer == null) throw var31_42;
                        bufferManager.disconnect(path, null);
                        throw var31_42;
                    }
                    catch (CoreException e) {
                        JavaPlugin.log(e);
                    }
                    throw var31_42;
                }
            }
            ** try [egrp 2[TRYBLOCK] [9 : 814->832)] { 
lbl136:
            // 1 sources

            if (textFileBuffer == null) return;
            bufferManager.disconnect(path, null);
            return;
lbl139:
            // 1 sources

            catch (CoreException e) {
                JavaPlugin.log(e);
            }
            return;
        }
        var30_25 = null;
        try {}
        catch (CoreException e) {
            JavaPlugin.log(e);
            return;
        }
        if (textFileBuffer == null) return;
        bufferManager.disconnect(path, null);
    }

    private ASTNode createASTNode(ASTRewrite rewriter, ITypedElement element, String delimiter, IJavaProject project) throws CoreException {
        int type;
        String content;
        if (element instanceof IStreamContentAccessor && (content = JavaCompareUtilities.readString((IStreamContentAccessor)element)) != null && (content = JavaAddElementFromHistoryImpl.trimTextBlock(content, delimiter, project)) != null && (type = this.getPlaceHolderType(element)) != -1) {
            return rewriter.createStringPlaceholder(content, type);
        }
        return null;
    }

    private int getPlaceHolderType(ITypedElement element) {
        if (element instanceof DocumentRangeNode) {
            JavaNode jn = (JavaNode)element;
            switch (jn.getTypeCode()) {
                case 1: {
                    return 35;
                }
                case 4: 
                case 5: {
                    return 55;
                }
                case 6: {
                    return 71;
                }
                case 7: {
                    return 81;
                }
                case 10: 
                case 11: {
                    return 31;
                }
                case 8: {
                    return 23;
                }
                case 9: {
                    return 28;
                }
                case 2: 
                case 3: {
                    return 26;
                }
                case 0: {
                    return 15;
                }
            }
        }
        return -1;
    }

    protected boolean isEnabled(ISelection selection) {
        Object o;
        if (selection.isEmpty()) {
            JavaEditor editor = this.getEditor();
            if (editor != null) {
                IEditorInput editorInput = editor.getEditorInput();
                WorkingCopyManager manager = JavaPlugin.getDefault().getWorkingCopyManager();
                return manager.getWorkingCopy(editorInput) != null;
            }
            return false;
        }
        if (selection instanceof IStructuredSelection && (o = ((IStructuredSelection)selection).getFirstElement()) instanceof ICompilationUnit) {
            return true;
        }
        return super.isEnabled(selection);
    }
}

