/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.infoviews;

import java.io.IOException;
import org.eclipse.jdt.core.ICodeAssist;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.ISourceRange;
import org.eclipse.jdt.core.ISourceReference;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.corext.codemanipulation.StubUtility;
import org.eclipse.jdt.internal.corext.util.Strings;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.infoviews.AbstractInfoView;
import org.eclipse.jdt.internal.ui.infoviews.InfoViewMessages;
import org.eclipse.jdt.internal.ui.javaeditor.JavaSourceViewer;
import org.eclipse.jdt.internal.ui.text.JavaCodeReader;
import org.eclipse.jdt.internal.ui.text.SimpleJavaSourceViewerConfiguration;
import org.eclipse.jdt.ui.actions.OpenAction;
import org.eclipse.jdt.ui.text.JavaSourceViewerConfiguration;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.text.TextViewer;
import org.eclipse.jface.text.source.SourceViewer;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.jface.util.Assert;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.texteditor.IAbstractTextEditorHelpContextIds;

public class SourceView
extends AbstractInfoView
implements IMenuListener {
    private static final String SYMBOLIC_FONT_NAME = "org.eclipse.jdt.ui.editors.textfont";
    private SourceViewer fViewer;
    private JavaSourceViewerConfiguration fViewerConfiguration;
    private IPropertyChangeListener fFontPropertyChangeListener = new FontPropertyChangeListener();
    private IPropertyChangeListener fPropertyChangeListener = new PropertyChangeListener();
    private OpenAction fOpen;
    private int fCommentLineCount;
    private SelectAllAction fSelectAllAction;
    private IJavaElement fLastOpenedElement;

    protected void internalCreatePartControl(Composite parent) {
        IPreferenceStore store = JavaPlugin.getDefault().getCombinedPreferenceStore();
        this.fViewer = new JavaSourceViewer(parent, null, null, false, 768, store);
        this.fViewerConfiguration = new SimpleJavaSourceViewerConfiguration(JavaPlugin.getDefault().getJavaTextTools().getColorManager(), store, null, "___java_partitioning", false);
        this.fViewer.configure((SourceViewerConfiguration)this.fViewerConfiguration);
        this.fViewer.setEditable(false);
        this.setViewerFont();
        JFaceResources.getFontRegistry().addListener(this.fFontPropertyChangeListener);
        store.addPropertyChangeListener(this.fPropertyChangeListener);
        this.getViewSite().setSelectionProvider((ISelectionProvider)this.fViewer);
    }

    protected void createActions() {
        super.createActions();
        this.fSelectAllAction = new SelectAllAction((TextViewer)this.fViewer);
        this.fOpen = new OpenAction((IWorkbenchSite)this.getViewSite()){

            public ISelection getSelection() {
                return SourceView.this.convertToJavaElementSelection(SourceView.this.fViewer.getSelection());
            }

            public void run(IStructuredSelection selection) {
                if (selection.isEmpty()) {
                    this.getShell().getDisplay().beep();
                    return;
                }
                super.run(selection);
            }

            public Object getElementToOpen(Object object) throws JavaModelException {
                if (object instanceof IJavaElement) {
                    SourceView.this.fLastOpenedElement = (IJavaElement)object;
                } else {
                    SourceView.this.fLastOpenedElement = null;
                }
                return super.getElementToOpen(object);
            }

            public void run(Object[] elements) {
                SourceView.this.stopListeningForSelectionChanges();
                super.run(elements);
                SourceView.this.startListeningForSelectionChanges();
            }
        };
    }

    protected IAction getSelectAllAction() {
        return this.fSelectAllAction;
    }

    protected void fillActionBars(IActionBars actionBars) {
        super.fillActionBars(actionBars);
        actionBars.setGlobalActionHandler("org.eclipse.jdt.ui.actions.Open", (IAction)this.fOpen);
        this.fOpen.setActionDefinitionId("org.eclipse.jdt.ui.edit.text.java.open.editor");
    }

    protected Control getControl() {
        return this.fViewer.getControl();
    }

    public void menuAboutToShow(IMenuManager menu) {
        super.menuAboutToShow(menu);
        menu.appendToGroup("group.open", (IAction)this.fOpen);
    }

    protected void setForeground(Color color) {
        this.fViewer.getTextWidget().setForeground(color);
    }

    protected void setBackground(Color color) {
        this.fViewer.getTextWidget().setBackground(color);
    }

    protected String getBackgroundColorKey() {
        return "org.eclipse.jdt.ui.DeclarationView.backgroundColor";
    }

    private IStructuredSelection convertToJavaElementSelection(ISelection selection) {
        if (!(selection instanceof ITextSelection) || !(this.fCurrentViewInput instanceof ISourceReference)) {
            return StructuredSelection.EMPTY;
        }
        ITextSelection textSelection = (ITextSelection)selection;
        IJavaElement codeAssist = this.fCurrentViewInput.getAncestor(5);
        if (codeAssist == null) {
            codeAssist = this.fCurrentViewInput.getAncestor(6);
        }
        if (codeAssist instanceof ICodeAssist) {
            IJavaElement[] elements = null;
            try {
                ISourceRange range = ((ISourceReference)this.fCurrentViewInput).getSourceRange();
                elements = ((ICodeAssist)codeAssist).codeSelect(range.getOffset() + this.getOffsetInUnclippedDocument(textSelection), textSelection.getLength());
            }
            catch (JavaModelException javaModelException) {
                return StructuredSelection.EMPTY;
            }
            if (elements != null && elements.length > 0) {
                return new StructuredSelection((Object)elements[0]);
            }
            return StructuredSelection.EMPTY;
        }
        return StructuredSelection.EMPTY;
    }

    private int getOffsetInUnclippedDocument(ITextSelection textSelection) {
        Document unclippedDocument = null;
        try {
            unclippedDocument = new Document(((ISourceReference)this.fCurrentViewInput).getSource());
        }
        catch (JavaModelException javaModelException) {
            return -1;
        }
        IDocument clippedDoc = (IDocument)this.fViewer.getInput();
        try {
            IRegion unclippedLineInfo = unclippedDocument.getLineInformation(this.fCommentLineCount + textSelection.getStartLine());
            IRegion clippedLineInfo = clippedDoc.getLineInformation(textSelection.getStartLine());
            int removedIndentation = unclippedLineInfo.getLength() - clippedLineInfo.getLength();
            int relativeLineOffset = textSelection.getOffset() - clippedLineInfo.getOffset();
            return unclippedLineInfo.getOffset() + removedIndentation + relativeLineOffset;
        }
        catch (BadLocationException badLocationException) {
            return -1;
        }
    }

    protected void internalDispose() {
        this.fViewer = null;
        this.fViewerConfiguration = null;
        JFaceResources.getFontRegistry().removeListener(this.fFontPropertyChangeListener);
        JavaPlugin.getDefault().getCombinedPreferenceStore().removePropertyChangeListener(this.fPropertyChangeListener);
    }

    public void setFocus() {
        this.fViewer.getTextWidget().setFocus();
    }

    protected Object computeInput(Object input) {
        boolean firstCharNotWhitespace;
        String source;
        if (this.fViewer == null || !(input instanceof ISourceReference)) {
            return null;
        }
        ISourceReference sourceRef = (ISourceReference)input;
        if (this.fLastOpenedElement != null && input instanceof IJavaElement && ((IJavaElement)input).getHandleIdentifier().equals(this.fLastOpenedElement.getHandleIdentifier())) {
            this.fLastOpenedElement = null;
            return null;
        }
        this.fLastOpenedElement = null;
        try {
            source = sourceRef.getSource();
        }
        catch (JavaModelException javaModelException) {
            return "";
        }
        if (source == null) {
            return "";
        }
        source = this.removeLeadingComments(source);
        String delim = StubUtility.getLineDelimiterUsed((IJavaElement)input);
        String[] sourceLines = Strings.convertIntoLines(source);
        if (sourceLines == null || sourceLines.length == 0) {
            return "";
        }
        String firstLine = sourceLines[0];
        boolean bl = firstCharNotWhitespace = firstLine != null && firstLine.length() > 0 && !Character.isWhitespace(firstLine.charAt(0));
        if (firstCharNotWhitespace) {
            sourceLines[0] = "";
        }
        IJavaProject project = input instanceof IJavaElement ? ((IJavaElement)input).getJavaProject() : null;
        Strings.trimIndentation(sourceLines, project);
        if (firstCharNotWhitespace) {
            sourceLines[0] = firstLine;
        }
        return Strings.concatenate(sourceLines, delim);
    }

    protected void setInput(Object input) {
        if (input instanceof IDocument) {
            this.fViewer.setInput(input);
        } else if (input == null) {
            this.fViewer.setInput((Object)new Document(""));
        } else {
            Document document = new Document(input.toString());
            JavaPlugin.getDefault().getJavaTextTools().setupJavaDocumentPartitioner((IDocument)document, "___java_partitioning");
            this.fViewer.setInput((Object)document);
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String removeLeadingComments(String source) {
        reader = new JavaCodeReader();
        document = new Document(source);
        try {
            try {
                reader.configureForwardReader((IDocument)document, 0, document.getLength(), true, false);
                c = reader.read();
                while (true) {
                    if (c == -1 || c != 13 && c != 10 && c != 9) {
                        i = reader.getOffset();
                        reader.close();
                    }
                    c = reader.read();
                }
            }
            catch (IOException v0) {
                i = 0;
            }
        }
        catch (Throwable var7_6) {
            var6_7 = null;
            try {
                if (reader == null) throw var7_6;
                reader.close();
                throw var7_6;
            }
            catch (IOException ex) {
                JavaPlugin.log(ex);
            }
            throw var7_6;
        }
        {
            var6_8 = null;
        }
        ** try [egrp 2[TRYBLOCK] [3 : 103->114)] { 
lbl29:
        // 1 sources

        if (reader != null) {
            reader.close();
        }
        ** GOTO lbl-1000
lbl32:
        // 1 sources

        catch (IOException ex) {
            JavaPlugin.log(ex);
        }
lbl-1000:
        // 2 sources

        {
            this.fCommentLineCount = document.getLineOfOffset(i);
        }
        if (i >= 0) return source.substring(i);
        return source;
    }

    private void setViewerFont() {
        Font font = JFaceResources.getFont((String)SYMBOLIC_FONT_NAME);
        if (this.fViewer.getDocument() != null) {
            Point selection = this.fViewer.getSelectedRange();
            int topIndex = this.fViewer.getTopIndex();
            StyledText styledText = this.fViewer.getTextWidget();
            Control parent = this.fViewer.getControl();
            parent.setRedraw(false);
            styledText.setFont(font);
            this.fViewer.setSelectedRange(selection.x, selection.y);
            this.fViewer.setTopIndex(topIndex);
            if (parent instanceof Composite) {
                Composite composite = (Composite)parent;
                composite.layout(true);
            }
            parent.setRedraw(true);
        } else {
            StyledText styledText = this.fViewer.getTextWidget();
            styledText.setFont(font);
        }
    }

    protected String getHelpContextId() {
        return "org.eclipse.jdt.ui.source_view_context";
    }

    class FontPropertyChangeListener
    implements IPropertyChangeListener {
        FontPropertyChangeListener() {
        }

        public void propertyChange(PropertyChangeEvent event) {
            if (SourceView.this.fViewer == null) {
                return;
            }
            String property = event.getProperty();
            if (SourceView.SYMBOLIC_FONT_NAME.equals(property)) {
                SourceView.this.setViewerFont();
            }
        }
    }

    class PropertyChangeListener
    implements IPropertyChangeListener {
        PropertyChangeListener() {
        }

        public void propertyChange(PropertyChangeEvent event) {
            if (SourceView.this.fViewer == null) {
                return;
            }
            if (SourceView.this.fViewerConfiguration.affectsTextPresentation(event)) {
                SourceView.this.fViewerConfiguration.handlePropertyChangeEvent(event);
                SourceView.this.fViewer.invalidateTextPresentation();
            }
        }
    }

    private static class SelectAllAction
    extends Action {
        private TextViewer fTextViewer;

        public SelectAllAction(TextViewer textViewer) {
            super("selectAll");
            Assert.isNotNull((Object)textViewer);
            this.fTextViewer = textViewer;
            this.setText(InfoViewMessages.SelectAllAction_label);
            this.setToolTipText(InfoViewMessages.SelectAllAction_tooltip);
            this.setDescription(InfoViewMessages.SelectAllAction_description);
            PlatformUI.getWorkbench().getHelpSystem().setHelp((IAction)this, IAbstractTextEditorHelpContextIds.SELECT_ALL_ACTION);
        }

        public void run() {
            this.fTextViewer.doOperation(7);
        }
    }
}

