/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.codemanipulation;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.AbstractTypeDeclaration;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.IBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.Modifier;
import org.eclipse.jdt.core.dom.Name;
import org.eclipse.jdt.core.dom.rewrite.ImportRewrite;
import org.eclipse.jdt.internal.corext.codemanipulation.ImportReferencesCollector;
import org.eclipse.jdt.internal.corext.dom.ScopeAnalyzer;
import org.eclipse.jdt.internal.corext.util.JavaModelUtil;

public class ContextSensitiveImportRewriteContext
extends ImportRewrite.ImportRewriteContext {
    private final CompilationUnit fCompilationUnit;
    private final int fPosition;
    private IBinding[] fDeclarationsInScope;
    private Name[] fImportedNames;
    private final ImportRewrite fImportRewrite;

    public ContextSensitiveImportRewriteContext(CompilationUnit compilationUnit, int position, ImportRewrite importRewrite) {
        this.fCompilationUnit = compilationUnit;
        this.fPosition = position;
        this.fImportRewrite = importRewrite;
        this.fDeclarationsInScope = null;
        this.fImportedNames = null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int findInContext(String qualifier, String name, int kind) {
        int defaultResult = this.fImportRewrite.getDefaultImportRewriteContext().findInContext(qualifier, name, kind);
        if (defaultResult != 2) {
            return defaultResult;
        }
        IBinding[] declarationsInScope = this.getDeclarationsInScope();
        int i = 0;
        while (i < declarationsInScope.length) {
            if (declarationsInScope[i] instanceof ITypeBinding) {
                ITypeBinding typeBinding = (ITypeBinding)declarationsInScope[i];
                if (this.isSameType(typeBinding, qualifier, name)) {
                    return 1;
                }
                if (this.isConflicting((IBinding)typeBinding, name)) {
                    return 3;
                }
            } else if (declarationsInScope[i] != null && this.isConflicting(declarationsInScope[i], name)) {
                return 3;
            }
            ++i;
        }
        Name[] names = this.getImportedNames();
        int i2 = 0;
        while (i2 < names.length) {
            ITypeBinding typeBinding;
            IBinding binding = names[i2].resolveBinding();
            if (binding instanceof ITypeBinding && this.isConflictingType(typeBinding = (ITypeBinding)binding, qualifier, name)) {
                return 3;
            }
            ++i2;
        }
        List list = this.fCompilationUnit.types();
        Iterator iter = list.iterator();
        while (iter.hasNext()) {
            AbstractTypeDeclaration type = (AbstractTypeDeclaration)iter.next();
            ITypeBinding binding = type.resolveBinding();
            if (binding == null) continue;
            if (this.isSameType(binding, qualifier, name)) {
                return 1;
            }
            ITypeBinding decl = this.containingDeclaration(binding, qualifier, name);
            while (decl != null && !decl.equals((Object)binding)) {
                int modifiers = decl.getModifiers();
                if (Modifier.isPrivate((int)modifiers)) {
                    return 3;
                }
                decl = decl.getDeclaringClass();
            }
        }
        String[] addedImports = this.fImportRewrite.getAddedImports();
        String qualifiedName = JavaModelUtil.concatenateName(qualifier, name);
        int i3 = 0;
        while (i3 < addedImports.length) {
            String addedImport = addedImports[i3];
            if (qualifiedName.equals(addedImport)) {
                return 1;
            }
            if (this.isConflicting(name, addedImport)) {
                return 3;
            }
            ++i3;
        }
        if (!qualifier.equals("java.lang")) return 2;
        IJavaElement parent = this.fCompilationUnit.getJavaElement().getParent();
        if (!(parent instanceof IPackageFragment)) return 2;
        IPackageFragment packageFragment = (IPackageFragment)parent;
        try {
            ICompilationUnit[] compilationUnits = packageFragment.getCompilationUnits();
            int i4 = 0;
            block7: while (true) {
                if (i4 >= compilationUnits.length) {
                    return 2;
                }
                ICompilationUnit cu = compilationUnits[i4];
                IType[] allTypes = cu.getAllTypes();
                int j = 0;
                while (true) {
                    if (j >= allTypes.length) {
                        ++i4;
                        continue block7;
                    }
                    IType type = allTypes[j];
                    String packageTypeName = type.getFullyQualifiedName();
                    if (this.isConflicting(name, packageTypeName)) {
                        return 3;
                    }
                    ++j;
                }
                break;
            }
        }
        catch (JavaModelException javaModelException) {}
        return 2;
    }

    private boolean isConflicting(String name, String importt) {
        int index = importt.lastIndexOf(46);
        String importedName = index == -1 ? importt : importt.substring(index + 1, importt.length());
        return importedName.equals(name);
    }

    private ITypeBinding containingDeclaration(ITypeBinding binding, String qualifier, String name) {
        ITypeBinding[] declaredTypes = binding.getDeclaredTypes();
        int i = 0;
        while (i < declaredTypes.length) {
            ITypeBinding childBinding = declaredTypes[i];
            if (this.isSameType(childBinding, qualifier, name)) {
                return childBinding;
            }
            ITypeBinding result = this.containingDeclaration(childBinding, qualifier, name);
            if (result != null) {
                return result;
            }
            ++i;
        }
        return null;
    }

    private boolean isConflicting(IBinding binding, String name) {
        return binding.getName().equals(name);
    }

    private boolean isSameType(ITypeBinding binding, String qualifier, String name) {
        String qualifiedName = JavaModelUtil.concatenateName(qualifier, name);
        return binding.getQualifiedName().equals(qualifiedName);
    }

    private boolean isConflictingType(ITypeBinding binding, String qualifier, String name) {
        return !this.isSameType(binding = binding.getTypeDeclaration(), qualifier, name) && this.isConflicting((IBinding)binding, name);
    }

    private IBinding[] getDeclarationsInScope() {
        if (this.fDeclarationsInScope == null) {
            ScopeAnalyzer analyzer = new ScopeAnalyzer(this.fCompilationUnit);
            this.fDeclarationsInScope = analyzer.getDeclarationsInScope(this.fPosition, 7);
        }
        return this.fDeclarationsInScope;
    }

    private Name[] getImportedNames() {
        if (this.fImportedNames == null) {
            IJavaProject project = null;
            IJavaElement javaElement = this.fCompilationUnit.getJavaElement();
            if (javaElement != null) {
                project = javaElement.getJavaProject();
            }
            ArrayList imports = new ArrayList();
            ImportReferencesCollector.collect((ASTNode)this.fCompilationUnit, project, null, imports, null);
            this.fImportedNames = imports.toArray(new Name[imports.size()]);
        }
        return this.fImportedNames;
    }
}

