/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.fix;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.jdt.core.dom.rewrite.ITrackedNodePosition;
import org.eclipse.jdt.internal.corext.fix.LinkedProposalPositionGroup;

public class LinkedProposalModel {
    private Map fPositionGroups;
    private LinkedProposalPositionGroup.PositionInformation fEndPosition;

    public void addPositionGroup(LinkedProposalPositionGroup positionGroup) {
        if (positionGroup == null) {
            throw new IllegalArgumentException("positionGroup must not be null");
        }
        if (this.fPositionGroups == null) {
            this.fPositionGroups = new HashMap();
        }
        this.fPositionGroups.put(positionGroup.getGroupId(), positionGroup);
    }

    public LinkedProposalPositionGroup getPositionGroup(String groupId, boolean createIfNotExisting) {
        LinkedProposalPositionGroup group;
        LinkedProposalPositionGroup linkedProposalPositionGroup = group = this.fPositionGroups != null ? (LinkedProposalPositionGroup)this.fPositionGroups.get(groupId) : null;
        if (createIfNotExisting && group == null) {
            group = new LinkedProposalPositionGroup(groupId);
            this.addPositionGroup(group);
        }
        return group;
    }

    public Iterator getPositionGroupIterator() {
        if (this.fPositionGroups == null) {
            return new Iterator(){

                public boolean hasNext() {
                    return false;
                }

                public Object next() {
                    return null;
                }

                public void remove() {
                }
            };
        }
        return this.fPositionGroups.values().iterator();
    }

    public void setEndPosition(LinkedProposalPositionGroup.PositionInformation position) {
        this.fEndPosition = position;
    }

    public void setEndPosition(ITrackedNodePosition position) {
        this.setEndPosition(LinkedProposalPositionGroup.createPositionInformation(position, false));
    }

    public LinkedProposalPositionGroup.PositionInformation getEndPosition() {
        return this.fEndPosition;
    }

    public boolean hasLinkedPositions() {
        return this.fPositionGroups != null && !this.fPositionGroups.isEmpty();
    }

    public void clear() {
        this.fPositionGroups = null;
        this.fEndPosition = null;
    }
}

