/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.websocket;

import java.io.IOException;
import org.eclipse.jetty.io.Buffer;
import org.eclipse.jetty.io.EndPoint;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.websocket.WebSocketBuffers;
import org.eclipse.jetty.websocket.WebSocketConnectionD10;
import org.eclipse.jetty.websocket.WebSocketParser;

public class WebSocketParserD10
implements WebSocketParser {
    private final WebSocketBuffers _buffers;
    private final EndPoint _endp;
    private final WebSocketParser.FrameHandler _handler;
    private final boolean _shouldBeMasked;
    private State _state;
    private Buffer _buffer;
    private byte _flags;
    private byte _opcode;
    private int _bytesNeeded;
    private long _length;
    private boolean _masked;
    private final byte[] _mask = new byte[4];
    private int _m;
    private boolean _skip;
    private boolean _fakeFragments = true;

    public WebSocketParserD10(WebSocketBuffers buffers, EndPoint endp, WebSocketParser.FrameHandler handler, boolean shouldBeMasked) {
        this._buffers = buffers;
        this._endp = endp;
        this._handler = handler;
        this._shouldBeMasked = shouldBeMasked;
        this._state = State.START;
    }

    public boolean isFakeFragments() {
        return this._fakeFragments;
    }

    public void setFakeFragments(boolean fakeFragments) {
        this._fakeFragments = fakeFragments;
    }

    @Override
    public boolean isBufferEmpty() {
        return this._buffer == null || this._buffer.length() == 0;
    }

    @Override
    public Buffer getBuffer() {
        return this._buffer;
    }

    @Override
    public int parseNext() {
        int available;
        if (this._buffer == null) {
            this._buffer = this._buffers.getBuffer();
        }
        int total_filled = 0;
        int events = 0;
        do {
            available = this._buffer.length();
            while (available < (this._state == State.SKIP ? 1 : this._bytesNeeded)) {
                this._buffer.compact();
                if (this._buffer.space() == 0) {
                    if (this._fakeFragments && this._state == State.DATA) {
                        Buffer data = this._buffer.get(4 * (available / 4));
                        this._buffer.compact();
                        if (this._masked) {
                            if (data.array() == null) {
                                data = this._buffer.asMutableBuffer();
                            }
                            byte[] array = data.array();
                            int end = data.putIndex();
                            int i = data.getIndex();
                            while (i < end) {
                                int n = i++;
                                array[n] = (byte)(array[n] ^ this._mask[this._m++ % 4]);
                            }
                        }
                        ++events;
                        this._bytesNeeded -= data.length();
                        this._handler.onFrame((byte)(this._flags & 0xF7), this._opcode, data);
                        this._opcode = 0;
                    }
                    if (this._buffer.space() == 0) {
                        throw new IllegalStateException("FULL: " + (Object)((Object)this._state) + " " + this._bytesNeeded + ">" + this._buffer.capacity());
                    }
                }
                try {
                    int filled;
                    int n = filled = this._endp.isOpen() ? this._endp.fill(this._buffer) : -1;
                    if (filled <= 0) {
                        return total_filled + events > 0 ? total_filled + events : filled;
                    }
                    total_filled += filled;
                    available = this._buffer.length();
                }
                catch (IOException e) {
                    Log.debug((Throwable)e);
                    return total_filled + events > 0 ? total_filled + events : -1;
                }
            }
            while (this._state != State.DATA && available >= (this._state == State.SKIP ? 1 : this._bytesNeeded)) {
                switch (this._state) {
                    case START: {
                        this._skip = false;
                        this._state = State.OPCODE;
                        this._bytesNeeded = this._state.getNeeds();
                        break;
                    }
                    case OPCODE: {
                        byte b = this._buffer.get();
                        --available;
                        this._opcode = (byte)(b & 0xF);
                        this._flags = (byte)(0xF & b >> 4);
                        if (WebSocketConnectionD10.isControlFrame(this._opcode) && !WebSocketConnectionD10.isLastFrame(this._flags)) {
                            ++events;
                            Log.warn((String)("Fragmented Control from " + this._endp));
                            this._handler.close(1002, "Fragmented control");
                            this._skip = true;
                        }
                        this._state = State.LENGTH_7;
                        this._bytesNeeded = this._state.getNeeds();
                        break;
                    }
                    case LENGTH_7: {
                        byte b = this._buffer.get();
                        --available;
                        this._masked = (b & 0x80) != 0;
                        b = (byte)(0x7F & b);
                        switch (b) {
                            case 127: {
                                this._length = 0L;
                                this._state = State.LENGTH_63;
                                break;
                            }
                            case 126: {
                                this._length = 0L;
                                this._state = State.LENGTH_16;
                                break;
                            }
                            default: {
                                this._length = 0x7F & b;
                                this._state = this._masked ? State.MASK : State.PAYLOAD;
                            }
                        }
                        this._bytesNeeded = this._state.getNeeds();
                        break;
                    }
                    case LENGTH_16: {
                        byte b = this._buffer.get();
                        --available;
                        this._length = this._length * 256L + (long)(0xFF & b);
                        if (--this._bytesNeeded != 0) break;
                        if (this._length > (long)this._buffer.capacity() && !this._fakeFragments) {
                            ++events;
                            this._handler.close(1004, "frame size " + this._length + ">" + this._buffer.capacity());
                            this._skip = true;
                        }
                        this._state = this._masked ? State.MASK : State.PAYLOAD;
                        this._bytesNeeded = this._state.getNeeds();
                        break;
                    }
                    case LENGTH_63: {
                        byte b = this._buffer.get();
                        --available;
                        this._length = this._length * 256L + (long)(0xFF & b);
                        if (--this._bytesNeeded != 0) break;
                        this._bytesNeeded = (int)this._length;
                        if (this._length >= (long)this._buffer.capacity()) {
                            ++events;
                            this._handler.close(1004, "frame size " + this._length + ">" + this._buffer.capacity());
                            this._skip = true;
                        }
                        this._state = this._masked ? State.MASK : State.PAYLOAD;
                        this._bytesNeeded = this._state.getNeeds();
                        break;
                    }
                    case MASK: {
                        this._buffer.get(this._mask, 0, 4);
                        this._m = 0;
                        available -= 4;
                        this._state = State.PAYLOAD;
                        this._bytesNeeded = this._state.getNeeds();
                        break;
                    }
                    case PAYLOAD: {
                        this._bytesNeeded = (int)this._length;
                        this._state = this._skip ? State.SKIP : State.DATA;
                        break;
                    }
                    case DATA: {
                        break;
                    }
                    case SKIP: {
                        int skip = Math.min(available, this._bytesNeeded);
                        this._buffer.skip(skip);
                        available -= skip;
                        this._bytesNeeded -= skip;
                        if (this._bytesNeeded != 0) break;
                        this._state = State.START;
                    }
                }
            }
        } while (this._state != State.DATA || available < this._bytesNeeded);
        if (this._masked != this._shouldBeMasked) {
            this._buffer.skip(this._bytesNeeded);
            this._state = State.START;
            ++events;
            this._handler.close(1002, "bad mask");
        } else {
            Buffer data = this._buffer.get(this._bytesNeeded);
            if (this._masked) {
                if (data.array() == null) {
                    data = this._buffer.asMutableBuffer();
                }
                byte[] array = data.array();
                int end = data.putIndex();
                int i = data.getIndex();
                while (i < end) {
                    int n = i++;
                    array[n] = (byte)(array[n] ^ this._mask[this._m++ % 4]);
                }
            }
            ++events;
            this._handler.onFrame(this._flags, this._opcode, data);
            this._bytesNeeded = 0;
            this._state = State.START;
        }
        if (this._buffer.length() == 0) {
            this._buffers.returnBuffer(this._buffer);
            this._buffer = null;
        }
        return total_filled + events;
    }

    @Override
    public void fill(Buffer buffer) {
        if (buffer != null && buffer.length() > 0) {
            if (this._buffer == null) {
                this._buffer = this._buffers.getBuffer();
            }
            this._buffer.put(buffer);
            buffer.clear();
        }
    }

    public static enum State {
        START(0),
        OPCODE(1),
        LENGTH_7(1),
        LENGTH_16(2),
        LENGTH_63(8),
        MASK(4),
        PAYLOAD(0),
        DATA(0),
        SKIP(1);

        int _needs;

        private State(int needs) {
            this._needs = needs;
        }

        int getNeeds() {
            return this._needs;
        }
    }
}

