/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jkube.kit.build.api.helper;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.jkube.kit.build.api.helper.FormatParameterReplacer;
import org.eclipse.jkube.kit.build.api.helper.NameFormatter;
import org.eclipse.jkube.kit.common.JKubeFileInterpolator;
import org.eclipse.jkube.kit.common.JavaProject;

public class ImageNameFormatter
implements NameFormatter {
    public static final String DOCKER_IMAGE_USER = "jkube.image.user";
    public static final String SEMVER_PLUS_SUBSTITUTION = "jkube.image.tag.semver_plus_substitution";
    public static final String DEFAULT_SEMVER_PLUS_SUBSTITUTE = "-";
    private final FormatParameterReplacer formatParamReplacer;
    private final Date now;
    private final JavaProject project;

    public ImageNameFormatter(JavaProject project, Date now) {
        this.now = now;
        this.project = project;
        this.formatParamReplacer = new FormatParameterReplacer(this.initLookups(project));
    }

    @Override
    public String format(String name) {
        if (name == null) {
            return null;
        }
        name = JKubeFileInterpolator.interpolate((String)name, (Properties)this.project.getProperties(), (String)"${*}");
        return this.formatParamReplacer.replace(name);
    }

    private Map<String, FormatParameterReplacer.Lookup> initLookups(JavaProject project) {
        HashMap<String, FormatParameterReplacer.Lookup> lookups = new HashMap<String, FormatParameterReplacer.Lookup>();
        lookups.put("g", new DefaultUserLookup(project));
        lookups.put("a", new DefaultNameLookup(project));
        lookups.put("v", new DefaultTagLookup(project, DefaultTagLookup.Mode.PLAIN, this.now));
        lookups.put("t", new DefaultTagLookup(project, DefaultTagLookup.Mode.SNAPSHOT_WITH_TIMESTAMP, this.now));
        lookups.put("l", new DefaultTagLookup(project, DefaultTagLookup.Mode.SNAPSHOT_LATEST, this.now));
        return lookups;
    }

    private static String sanitizeName(String name) {
        StringBuilder ret = new StringBuilder(name.length());
        int underscores = 0;
        boolean lastWasADot = false;
        for (char c : name.toCharArray()) {
            if (c == '_') {
                if (++underscores > 2) continue;
                ret.append(c);
                continue;
            }
            if (c == '.') {
                if (!lastWasADot) {
                    ret.append(c);
                }
                lastWasADot = true;
                continue;
            }
            underscores = 0;
            lastWasADot = false;
            if (!Character.isLetter(c) && !Character.isDigit(c) && c != '-') continue;
            ret.append(c);
        }
        return ret.toString().toLowerCase();
    }

    private static class DefaultTagLookup
    extends AbstractLookup {
        private static final String DOCKER_IMAGE_TAG = "jkube.image.tag";
        private final Mode mode;
        private final Date now;

        private DefaultTagLookup(JavaProject project, Mode mode, Date now) {
            super(project);
            this.mode = mode;
            this.now = now;
        }

        @Override
        public String lookup() {
            String userProvidedTag = this.getProperty(DOCKER_IMAGE_TAG);
            if (!StringUtils.isBlank((CharSequence)userProvidedTag)) {
                return userProvidedTag;
            }
            String plusSubstitute = this.getProperty(ImageNameFormatter.SEMVER_PLUS_SUBSTITUTION, ImageNameFormatter.DEFAULT_SEMVER_PLUS_SUBSTITUTE).trim();
            if ("+".equals(plusSubstitute)) {
                plusSubstitute = ImageNameFormatter.DEFAULT_SEMVER_PLUS_SUBSTITUTE;
            }
            String tag = this.generateTag(plusSubstitute);
            return DefaultTagLookup.sanitizeTag(tag, plusSubstitute);
        }

        private String generateTag(String plusSubstitute) {
            String buildmetadata;
            String prerelease;
            String version = this.project.getVersion();
            if (this.mode == Mode.PLAIN) {
                return version;
            }
            int indexOfPlus = version.indexOf(43);
            if (indexOfPlus >= 0) {
                prerelease = version.substring(0, indexOfPlus);
                buildmetadata = plusSubstitute + version.substring(indexOfPlus + 1);
            } else {
                prerelease = version;
                buildmetadata = "";
            }
            if (!prerelease.endsWith("-SNAPSHOT")) {
                return version;
            }
            switch (this.mode) {
                case SNAPSHOT_WITH_TIMESTAMP: {
                    return "snapshot-" + new SimpleDateFormat("yyMMdd-HHmmss-SSSS").format(this.now) + buildmetadata;
                }
                case SNAPSHOT_LATEST: {
                    return "latest" + buildmetadata;
                }
            }
            throw new IllegalStateException("mode is '" + this.mode.name() + "', which is not implemented.");
        }

        private static String sanitizeTag(String tagName, String plusSubstitute) {
            StringBuilder ret = new StringBuilder(tagName.length());
            for (char c : tagName.toCharArray()) {
                boolean allowedCharacter;
                boolean bl = allowedCharacter = Character.isLetterOrDigit(c) || '_' == c || '.' == c || '-' == c;
                if (allowedCharacter) {
                    ret.append(c);
                    continue;
                }
                if ('+' == c) {
                    ret.append(plusSubstitute);
                    continue;
                }
                ret.append('-');
            }
            return ret.length() <= 127 ? ret.toString() : ret.substring(0, 128);
        }

        private static enum Mode {
            PLAIN,
            SNAPSHOT_WITH_TIMESTAMP,
            SNAPSHOT_LATEST;

        }
    }

    private static class DefaultNameLookup
    extends AbstractLookup {
        private DefaultNameLookup(JavaProject project) {
            super(project);
        }

        @Override
        public String lookup() {
            return ImageNameFormatter.sanitizeName(this.project.getArtifactId());
        }
    }

    private static class DefaultUserLookup
    extends AbstractLookup {
        private DefaultUserLookup(JavaProject project) {
            super(project);
        }

        @Override
        public String lookup() {
            String user = this.getProperty(ImageNameFormatter.DOCKER_IMAGE_USER);
            if (user != null) {
                return user;
            }
            String groupId = this.project.getGroupId();
            while (groupId.endsWith(".")) {
                groupId = groupId.substring(0, groupId.length() - 1);
            }
            int idx = groupId.lastIndexOf(".");
            return ImageNameFormatter.sanitizeName(groupId.substring(idx != -1 ? idx + 1 : 0));
        }
    }

    public static abstract class AbstractLookup
    implements FormatParameterReplacer.Lookup {
        protected final JavaProject project;

        private AbstractLookup(JavaProject project) {
            this.project = project;
        }

        protected String getProperty(String key) {
            return this.project.getProperties().getProperty(key);
        }

        protected String getProperty(String key, String defaultValue) {
            return this.project.getProperties().getProperty(key, defaultValue);
        }
    }
}

