/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jkube.kit.enricher.api;

import io.fabric8.kubernetes.api.model.KubernetesListBuilder;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import org.eclipse.jkube.kit.common.KitLogger;
import org.eclipse.jkube.kit.common.util.ClassUtil;
import org.eclipse.jkube.kit.common.util.PluginServiceFactory;
import org.eclipse.jkube.kit.config.resource.EnricherManager;
import org.eclipse.jkube.kit.config.resource.PlatformMode;
import org.eclipse.jkube.kit.config.resource.ProcessorConfig;
import org.eclipse.jkube.kit.enricher.api.Enricher;
import org.eclipse.jkube.kit.enricher.api.EnricherContext;
import org.eclipse.jkube.kit.enricher.api.util.Misc;

public class DefaultEnricherManager
implements EnricherManager {
    private static final String[] SERVICE_PATHS = new String[]{"META-INF/jkube/enricher-default", "META-INF/jkube-enricher-default", "META-INF/jkube-enricher", "META-INF/jkube/enricher"};
    private final List<Enricher> enrichers;
    private final ProcessorConfig defaultEnricherConfig;
    private final KitLogger log;

    public DefaultEnricherManager(EnricherContext enricherContext) {
        this(enricherContext, Collections.emptyList());
    }

    public DefaultEnricherManager(EnricherContext enricherContext, List<String> extraClasspathElements) {
        this.defaultEnricherConfig = Optional.ofNullable(enricherContext.getConfiguration().getProcessorConfig()).orElse(ProcessorConfig.EMPTY);
        this.log = enricherContext.getLog();
        PluginServiceFactory pluginFactory = new PluginServiceFactory((Object)enricherContext, new ClassLoader[0]);
        if (!extraClasspathElements.isEmpty()) {
            pluginFactory.addAdditionalClassLoader((ClassLoader)ClassUtil.createProjectClassLoader(extraClasspathElements, (KitLogger)enricherContext.getLog()));
        }
        this.enrichers = pluginFactory.createServiceObjects(SERVICE_PATHS);
        this.logEnrichers(Misc.filterEnrichers(this.defaultEnricherConfig, this.enrichers));
    }

    public void createDefaultResources(PlatformMode platformMode, KubernetesListBuilder builder) {
        this.createDefaultResources(platformMode, this.defaultEnricherConfig, builder);
    }

    public void createDefaultResources(PlatformMode platformMode, ProcessorConfig enricherConfig, KubernetesListBuilder builder) {
        this.loop(enricherConfig, enricher -> {
            enricher.create(platformMode, builder);
            return null;
        });
    }

    public void enrich(PlatformMode platformMode, KubernetesListBuilder builder) {
        this.enrich(platformMode, this.defaultEnricherConfig, builder);
    }

    public void enrich(PlatformMode platformMode, ProcessorConfig enricherConfig, KubernetesListBuilder builder) {
        this.loop(enricherConfig, enricher -> {
            enricher.enrich(platformMode, builder);
            return null;
        });
    }

    private void logEnrichers(List<Enricher> enrichers) {
        this.log.verbose("Enrichers:", new Object[0]);
        for (Enricher enricher : enrichers) {
            this.log.verbose("- %s", new Object[]{enricher.getName()});
        }
    }

    private void loop(ProcessorConfig config, Function<Enricher, Void> function) {
        for (Enricher enricher : Misc.filterEnrichers(config, this.enrichers)) {
            function.apply(enricher);
        }
    }
}

