/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jkube.kit.enricher.api.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.function.Function;
import org.eclipse.jkube.kit.config.image.ImageConfiguration;
import org.eclipse.jkube.kit.config.image.build.JKubeBuildStrategy;
import org.eclipse.jkube.kit.config.resource.ProcessorConfig;
import org.eclipse.jkube.kit.config.resource.ResourceConfig;

public class Configuration {
    private List<ImageConfiguration> images;
    private ResourceConfig resource;
    private BiFunction<String, String, Optional<Map<String, Object>>> pluginConfigLookup;
    private Function<String, Optional<Map<String, Object>>> secretConfigLookup;
    private ProcessorConfig processorConfig;
    private JKubeBuildStrategy jKubeBuildStrategy;

    public Configuration(List<ImageConfiguration> images, ResourceConfig resource, BiFunction<String, String, Optional<Map<String, Object>>> pluginConfigLookup, Function<String, Optional<Map<String, Object>>> secretConfigLookup, ProcessorConfig processorConfig, JKubeBuildStrategy jKubeBuildStrategy) {
        this.images = images;
        this.resource = resource;
        this.pluginConfigLookup = pluginConfigLookup;
        this.secretConfigLookup = secretConfigLookup;
        this.processorConfig = processorConfig;
        this.jKubeBuildStrategy = jKubeBuildStrategy;
    }

    public Optional<Map<String, Object>> getPluginConfiguration(String system, String id) {
        return this.pluginConfigLookup.apply(system, id);
    }

    public Optional<Map<String, Object>> getSecretConfiguration(String id) {
        return this.secretConfigLookup.apply(id);
    }

    public static ConfigurationBuilder builder() {
        return new ConfigurationBuilder();
    }

    public ConfigurationBuilder toBuilder() {
        ConfigurationBuilder builder = new ConfigurationBuilder().resource(this.resource).pluginConfigLookup(this.pluginConfigLookup).secretConfigLookup(this.secretConfigLookup).processorConfig(this.processorConfig).jKubeBuildStrategy(this.jKubeBuildStrategy);
        if (this.images != null) {
            builder.images(this.images);
        }
        return builder;
    }

    private Configuration() {
    }

    public List<ImageConfiguration> getImages() {
        return this.images;
    }

    public ResourceConfig getResource() {
        return this.resource;
    }

    public BiFunction<String, String, Optional<Map<String, Object>>> getPluginConfigLookup() {
        return this.pluginConfigLookup;
    }

    public Function<String, Optional<Map<String, Object>>> getSecretConfigLookup() {
        return this.secretConfigLookup;
    }

    public ProcessorConfig getProcessorConfig() {
        return this.processorConfig;
    }

    public JKubeBuildStrategy getJKubeBuildStrategy() {
        return this.jKubeBuildStrategy;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Configuration)) {
            return false;
        }
        Configuration other = (Configuration)o;
        if (!other.canEqual(this)) {
            return false;
        }
        List<ImageConfiguration> this$images = this.getImages();
        List<ImageConfiguration> other$images = other.getImages();
        if (this$images == null ? other$images != null : !((Object)this$images).equals(other$images)) {
            return false;
        }
        ResourceConfig this$resource = this.getResource();
        ResourceConfig other$resource = other.getResource();
        if (this$resource == null ? other$resource != null : !this$resource.equals(other$resource)) {
            return false;
        }
        BiFunction<String, String, Optional<Map<String, Object>>> this$pluginConfigLookup = this.getPluginConfigLookup();
        BiFunction<String, String, Optional<Map<String, Object>>> other$pluginConfigLookup = other.getPluginConfigLookup();
        if (this$pluginConfigLookup == null ? other$pluginConfigLookup != null : !this$pluginConfigLookup.equals(other$pluginConfigLookup)) {
            return false;
        }
        Function<String, Optional<Map<String, Object>>> this$secretConfigLookup = this.getSecretConfigLookup();
        Function<String, Optional<Map<String, Object>>> other$secretConfigLookup = other.getSecretConfigLookup();
        if (this$secretConfigLookup == null ? other$secretConfigLookup != null : !this$secretConfigLookup.equals(other$secretConfigLookup)) {
            return false;
        }
        ProcessorConfig this$processorConfig = this.getProcessorConfig();
        ProcessorConfig other$processorConfig = other.getProcessorConfig();
        if (this$processorConfig == null ? other$processorConfig != null : !this$processorConfig.equals(other$processorConfig)) {
            return false;
        }
        JKubeBuildStrategy this$jKubeBuildStrategy = this.getJKubeBuildStrategy();
        JKubeBuildStrategy other$jKubeBuildStrategy = other.getJKubeBuildStrategy();
        return !(this$jKubeBuildStrategy == null ? other$jKubeBuildStrategy != null : !this$jKubeBuildStrategy.equals(other$jKubeBuildStrategy));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Configuration;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        List<ImageConfiguration> $images = this.getImages();
        result = result * 59 + ($images == null ? 43 : ((Object)$images).hashCode());
        ResourceConfig $resource = this.getResource();
        result = result * 59 + ($resource == null ? 43 : $resource.hashCode());
        BiFunction<String, String, Optional<Map<String, Object>>> $pluginConfigLookup = this.getPluginConfigLookup();
        result = result * 59 + ($pluginConfigLookup == null ? 43 : $pluginConfigLookup.hashCode());
        Function<String, Optional<Map<String, Object>>> $secretConfigLookup = this.getSecretConfigLookup();
        result = result * 59 + ($secretConfigLookup == null ? 43 : $secretConfigLookup.hashCode());
        ProcessorConfig $processorConfig = this.getProcessorConfig();
        result = result * 59 + ($processorConfig == null ? 43 : $processorConfig.hashCode());
        JKubeBuildStrategy $jKubeBuildStrategy = this.getJKubeBuildStrategy();
        result = result * 59 + ($jKubeBuildStrategy == null ? 43 : $jKubeBuildStrategy.hashCode());
        return result;
    }

    public static class ConfigurationBuilder {
        private ArrayList<ImageConfiguration> images;
        private ResourceConfig resource;
        private BiFunction<String, String, Optional<Map<String, Object>>> pluginConfigLookup;
        private Function<String, Optional<Map<String, Object>>> secretConfigLookup;
        private ProcessorConfig processorConfig;
        private JKubeBuildStrategy jKubeBuildStrategy;

        ConfigurationBuilder() {
        }

        public ConfigurationBuilder image(ImageConfiguration image) {
            if (this.images == null) {
                this.images = new ArrayList();
            }
            this.images.add(image);
            return this;
        }

        public ConfigurationBuilder images(Collection<? extends ImageConfiguration> images) {
            if (images == null) {
                throw new NullPointerException("images cannot be null");
            }
            if (this.images == null) {
                this.images = new ArrayList();
            }
            this.images.addAll(images);
            return this;
        }

        public ConfigurationBuilder clearImages() {
            if (this.images != null) {
                this.images.clear();
            }
            return this;
        }

        public ConfigurationBuilder resource(ResourceConfig resource) {
            this.resource = resource;
            return this;
        }

        public ConfigurationBuilder pluginConfigLookup(BiFunction<String, String, Optional<Map<String, Object>>> pluginConfigLookup) {
            this.pluginConfigLookup = pluginConfigLookup;
            return this;
        }

        public ConfigurationBuilder secretConfigLookup(Function<String, Optional<Map<String, Object>>> secretConfigLookup) {
            this.secretConfigLookup = secretConfigLookup;
            return this;
        }

        public ConfigurationBuilder processorConfig(ProcessorConfig processorConfig) {
            this.processorConfig = processorConfig;
            return this;
        }

        public ConfigurationBuilder jKubeBuildStrategy(JKubeBuildStrategy jKubeBuildStrategy) {
            this.jKubeBuildStrategy = jKubeBuildStrategy;
            return this;
        }

        public Configuration build() {
            List<ImageConfiguration> images;
            switch (this.images == null ? 0 : this.images.size()) {
                case 0: {
                    images = Collections.emptyList();
                    break;
                }
                case 1: {
                    images = Collections.singletonList(this.images.get(0));
                    break;
                }
                default: {
                    images = Collections.unmodifiableList(new ArrayList<ImageConfiguration>(this.images));
                }
            }
            return new Configuration(images, this.resource, this.pluginConfigLookup, this.secretConfigLookup, this.processorConfig, this.jKubeBuildStrategy);
        }

        public String toString() {
            return "Configuration.ConfigurationBuilder(images=" + this.images + ", resource=" + this.resource + ", pluginConfigLookup=" + this.pluginConfigLookup + ", secretConfigLookup=" + this.secretConfigLookup + ", processorConfig=" + this.processorConfig + ", jKubeBuildStrategy=" + this.jKubeBuildStrategy + ")";
        }
    }
}

