/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jkube.kit.enricher.handler;

import io.fabric8.kubernetes.api.model.LocalObjectReference;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.fabric8.kubernetes.api.model.ObjectMetaBuilder;
import io.fabric8.kubernetes.api.model.PodSpec;
import io.fabric8.kubernetes.api.model.PodSpecBuilder;
import io.fabric8.kubernetes.api.model.PodTemplateSpec;
import io.fabric8.kubernetes.api.model.PodTemplateSpecBuilder;
import io.fabric8.kubernetes.api.model.Volume;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.eclipse.jkube.kit.config.image.ImageConfiguration;
import org.eclipse.jkube.kit.config.resource.ControllerResourceConfig;
import org.eclipse.jkube.kit.config.resource.VolumeConfig;
import org.eclipse.jkube.kit.config.resource.VolumeType;
import org.eclipse.jkube.kit.enricher.api.util.KubernetesResourceUtil;
import org.eclipse.jkube.kit.enricher.handler.ContainerHandler;

public class PodTemplateHandler {
    private final ContainerHandler containerHandler;

    public PodTemplateHandler(ContainerHandler containerHandler) {
        this.containerHandler = containerHandler;
    }

    public PodTemplateSpec getPodTemplate(ControllerResourceConfig config, String restartPolicy, List<ImageConfiguration> images) {
        return ((PodTemplateSpecBuilder)((PodTemplateSpecBuilder)new PodTemplateSpecBuilder().withMetadata(this.createPodMetaData())).withSpec(this.createPodSpec(config, restartPolicy, images))).build();
    }

    private ObjectMeta createPodMetaData() {
        return new ObjectMetaBuilder().build();
    }

    private PodSpec createPodSpec(ControllerResourceConfig config, String restartPolicy, List<ImageConfiguration> images) {
        return ((PodSpecBuilder)((PodSpecBuilder)((PodSpecBuilder)((PodSpecBuilder)((PodSpecBuilder)((PodSpecBuilder)new PodSpecBuilder().withRestartPolicy(restartPolicy)).withContainers(this.containerHandler.getContainers(config, images))).withInitContainers(KubernetesResourceUtil.createNewInitContainersFromConfig(config.getInitContainers()))).withVolumes(this.getVolumes(config))).withNodeSelector(config.getNodeSelector())).withImagePullSecrets(config.getImagePullSecrets() == null ? null : config.getImagePullSecrets().stream().map(LocalObjectReference::new).collect(Collectors.toList()))).build();
    }

    private List<Volume> getVolumes(ControllerResourceConfig config) {
        List volumeConfigs = config.getVolumes();
        ArrayList<Volume> ret = new ArrayList<Volume>();
        if (volumeConfigs != null) {
            for (VolumeConfig volumeConfig : volumeConfigs) {
                VolumeType type = VolumeType.typeFor((String)volumeConfig.getType());
                if (type == null) continue;
                ret.add(type.fromConfig(volumeConfig));
            }
        }
        return ret;
    }
}

