/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jkube.micronaut;

import java.net.URL;
import java.net.URLClassLoader;
import java.util.Properties;
import java.util.function.Supplier;
import org.eclipse.jkube.kit.common.JavaProject;
import org.eclipse.jkube.kit.common.util.JKubeProjectUtil;
import org.eclipse.jkube.kit.common.util.PropertiesUtil;
import org.eclipse.jkube.kit.common.util.YamlUtil;

public class MicronautUtils {
    private MicronautUtils() {
    }

    public static String extractPort(Properties properties, String defaultValue) {
        return properties.getProperty("micronaut.server.port", defaultValue);
    }

    public static boolean isHealthEnabled(Properties properties) {
        return properties.getProperty("endpoints.health.enabled", "false").equalsIgnoreCase("true");
    }

    public static Properties getMicronautConfiguration(URLClassLoader urlClassLoader) {
        Supplier[] sources;
        for (Supplier source : sources = new Supplier[]{() -> PropertiesUtil.getPropertiesFromResource((URL)urlClassLoader.findResource("application.properties")), () -> YamlUtil.getPropertiesFromYamlResource((URL)urlClassLoader.findResource("application.yml")), () -> YamlUtil.getPropertiesFromYamlResource((URL)urlClassLoader.findResource("application.json"))}) {
            Properties props = (Properties)source.get();
            if (props.isEmpty()) continue;
            return props;
        }
        return new Properties();
    }

    public static boolean hasMicronautPlugin(JavaProject javaProject) {
        return JKubeProjectUtil.hasPlugin((JavaProject)javaProject, (String)"io.micronaut.build", (String)"micronaut-maven-plugin") || JKubeProjectUtil.hasPlugin((JavaProject)javaProject, (String)"io.micronaut.maven", (String)"micronaut-maven-plugin") || JKubeProjectUtil.hasPlugin((JavaProject)javaProject, (String)"io.micronaut.application", (String)"io.micronaut.application.gradle.plugin");
    }

    public static boolean hasNativeImagePackaging(JavaProject javaProject) {
        if (javaProject != null) {
            if (javaProject.getProperties() != null && javaProject.getProperties().getProperty("packaging") != null && javaProject.getProperties().getProperty("packaging").equals("native-image")) {
                return true;
            }
            return javaProject.getGradlePlugins() != null && javaProject.getGradlePlugins().contains("org.graalvm.buildtools.gradle.NativeImagePlugin");
        }
        return false;
    }
}

