/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jkube.micronaut.generator;

import java.io.File;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import org.eclipse.jkube.generator.api.FromSelector;
import org.eclipse.jkube.generator.api.GeneratorConfig;
import org.eclipse.jkube.generator.api.GeneratorContext;
import org.eclipse.jkube.kit.common.Arguments;
import org.eclipse.jkube.kit.common.Assembly;
import org.eclipse.jkube.kit.common.AssemblyConfiguration;
import org.eclipse.jkube.kit.common.AssemblyFileSet;
import org.eclipse.jkube.kit.common.JavaProject;
import org.eclipse.jkube.kit.common.util.FileUtil;
import org.eclipse.jkube.micronaut.generator.AbstractMicronautNestedGenerator;

public class NativeGenerator
extends AbstractMicronautNestedGenerator {
    private final File nativeBinary;
    private final FromSelector fromSelector;

    public NativeGenerator(GeneratorContext generatorContext, GeneratorConfig generatorConfig, File nativeBinary) {
        super(generatorContext, generatorConfig);
        this.nativeBinary = nativeBinary;
        this.fromSelector = new FromSelector.Default(generatorContext, "micronaut-native");
    }

    @Override
    public String getFrom() {
        return this.fromSelector.getFrom();
    }

    @Override
    public String getDefaultJolokiaPort() {
        return "0";
    }

    @Override
    public String getDefaultPrometheusPort() {
        return "0";
    }

    @Override
    public Arguments getBuildEntryPoint() {
        return Arguments.builder().execArgument("./" + this.nativeBinary.getName()).build();
    }

    @Override
    public String getBuildWorkdir() {
        return "/";
    }

    @Override
    public String getTargetDir() {
        return "/";
    }

    @Override
    public Map<String, String> getEnv(Function<Boolean, Map<String, String>> javaExecEnvSupplier, boolean prePackagePhase) {
        return Collections.emptyMap();
    }

    @Override
    public AssemblyConfiguration createAssemblyConfiguration(List<AssemblyFileSet> defaultFileSets) {
        Assembly.AssemblyBuilder assemblyBuilder = Assembly.builder();
        JavaProject project = this.getProject();
        AssemblyFileSet.AssemblyFileSetBuilder artifactFileSetBuilder = AssemblyFileSet.builder().outputDirectory(new File(".")).directory(FileUtil.getRelativePath((File)project.getBaseDirectory(), (File)this.nativeBinary.getParentFile())).fileMode("0755");
        artifactFileSetBuilder.include(this.nativeBinary.getName());
        assemblyBuilder.fileSets(defaultFileSets);
        assemblyBuilder.fileSet(artifactFileSetBuilder.build());
        return AssemblyConfiguration.builder().targetDir(this.getTargetDir()).excludeFinalOutputArtifact(true).layer(assemblyBuilder.build()).build();
    }
}

