/*
 * Decompiled with CFR 0.152.
 */
package org.ff4j.services.validator;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.apache.commons.lang3.StringUtils;
import org.ff4j.FF4j;
import org.ff4j.core.Feature;
import org.ff4j.services.exceptions.FeatureIdBlankException;
import org.ff4j.services.exceptions.FeatureIdNotMatchException;
import org.ff4j.services.exceptions.FeatureNotFoundException;
import org.ff4j.services.exceptions.GroupExistsException;
import org.ff4j.services.exceptions.GroupNotExistsException;
import org.ff4j.services.exceptions.RoleExistsException;
import org.ff4j.services.exceptions.RoleNotExistsException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\n\b\u0017\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u001c\u0010\r\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\f2\b\u0010\u000e\u001a\u0004\u0018\u00010\fH\u0016J\u0012\u0010\u000f\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u0016J\u0010\u0010\u0010\u001a\u00020\n2\u0006\u0010\u0011\u001a\u00020\fH\u0016J\u0010\u0010\u0012\u001a\u00020\n2\u0006\u0010\u0011\u001a\u00020\fH\u0016J\u0018\u0010\u0013\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0014\u001a\u00020\fH\u0016J\u0018\u0010\u0015\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0014\u001a\u00020\fH\u0016R\u001e\u0010\u0003\u001a\u00020\u00048\u0016@\u0016X\u0097.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\b\u00a8\u0006\u0016"}, d2={"Lorg/ff4j/services/validator/FeatureValidator;", "", "()V", "ff4j", "Lorg/ff4j/FF4j;", "getFf4j", "()Lorg/ff4j/FF4j;", "setFf4j", "(Lorg/ff4j/FF4j;)V", "assertFeatureExists", "", "featureUID", "", "assertFeatureIdsMatch", "featureApiUID", "assertFeatureUIDIsNotBlank", "assertGroupDoesNotExist", "groupName", "assertGroupExist", "assertRoleDoesNotExist", "role", "assertRoleExist", "ff4j-spring-services"})
public class FeatureValidator {
    @Autowired
    @NotNull
    public FF4j ff4j;

    @NotNull
    public FF4j getFf4j() {
        FF4j fF4j = this.ff4j;
        if (fF4j == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"ff4j");
        }
        return fF4j;
    }

    public void setFf4j(@NotNull FF4j fF4j) {
        Intrinsics.checkParameterIsNotNull((Object)fF4j, (String)"<set-?>");
        this.ff4j = fF4j;
    }

    public void assertFeatureIdsMatch(@Nullable String featureUID, @Nullable String featureApiUID) {
        if (Intrinsics.areEqual((Object)featureUID, (Object)featureApiUID) ^ true) {
            throw (Throwable)new FeatureIdNotMatchException();
        }
    }

    public void assertFeatureUIDIsNotBlank(@Nullable String featureUID) {
        if (StringUtils.isBlank((CharSequence)featureUID)) {
            throw (Throwable)new FeatureIdBlankException();
        }
    }

    public void assertFeatureExists(@NotNull String featureUID) {
        Intrinsics.checkParameterIsNotNull((Object)featureUID, (String)"featureUID");
        if (!this.getFf4j().exist(featureUID)) {
            throw (Throwable)new FeatureNotFoundException();
        }
    }

    public void assertRoleDoesNotExist(@NotNull String featureUID, @NotNull String role) {
        Intrinsics.checkParameterIsNotNull((Object)featureUID, (String)"featureUID");
        Intrinsics.checkParameterIsNotNull((Object)role, (String)"role");
        Feature feature = this.getFf4j().getFeatureStore().read(featureUID);
        Intrinsics.checkExpressionValueIsNotNull((Object)feature, (String)"ff4j.featureStore.read(featureUID)");
        if (feature.getPermissions().contains(role)) {
            throw (Throwable)new RoleExistsException();
        }
    }

    public void assertRoleExist(@NotNull String featureUID, @NotNull String role) {
        Intrinsics.checkParameterIsNotNull((Object)featureUID, (String)"featureUID");
        Intrinsics.checkParameterIsNotNull((Object)role, (String)"role");
        Feature feature = this.getFf4j().getFeatureStore().read(featureUID);
        Intrinsics.checkExpressionValueIsNotNull((Object)feature, (String)"ff4j.featureStore.read(featureUID)");
        if (!feature.getPermissions().contains(role)) {
            throw (Throwable)new RoleNotExistsException();
        }
    }

    public void assertGroupDoesNotExist(@NotNull String groupName) {
        Intrinsics.checkParameterIsNotNull((Object)groupName, (String)"groupName");
        if (this.getFf4j().getFeatureStore().existGroup(groupName)) {
            throw (Throwable)new GroupExistsException();
        }
    }

    public void assertGroupExist(@NotNull String groupName) {
        Intrinsics.checkParameterIsNotNull((Object)groupName, (String)"groupName");
        if (!this.getFf4j().getFeatureStore().existGroup(groupName)) {
            throw (Throwable)new GroupNotExistsException();
        }
    }
}

