/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.bpmn.converter;

import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import org.apache.commons.lang3.StringUtils;
import org.flowable.bpmn.converter.BaseBpmnXMLConverter;
import org.flowable.bpmn.converter.util.BpmnXMLUtil;
import org.flowable.bpmn.model.Association;
import org.flowable.bpmn.model.AssociationDirection;
import org.flowable.bpmn.model.BaseElement;
import org.flowable.bpmn.model.BpmnModel;

public class AssociationXMLConverter
extends BaseBpmnXMLConverter {
    @Override
    public Class<? extends BaseElement> getBpmnElementType() {
        return Association.class;
    }

    @Override
    protected String getXMLElementName() {
        return "association";
    }

    @Override
    protected BaseElement convertXMLToElement(XMLStreamReader xtr, BpmnModel model) throws Exception {
        Association association = new Association();
        BpmnXMLUtil.addXMLLocation((BaseElement)association, xtr);
        association.setSourceRef(xtr.getAttributeValue(null, "sourceRef"));
        association.setTargetRef(xtr.getAttributeValue(null, "targetRef"));
        association.setId(xtr.getAttributeValue(null, "id"));
        String asociationDirectionString = xtr.getAttributeValue(null, "associationDirection");
        if (StringUtils.isNotEmpty((CharSequence)asociationDirectionString)) {
            AssociationDirection associationDirection = AssociationDirection.valueOf((String)asociationDirectionString.toUpperCase());
            association.setAssociationDirection(associationDirection);
        }
        this.parseChildElements(this.getXMLElementName(), (BaseElement)association, model, xtr);
        return association;
    }

    @Override
    protected void writeAdditionalAttributes(BaseElement element, BpmnModel model, XMLStreamWriter xtw) throws Exception {
        Association association = (Association)element;
        this.writeDefaultAttribute("sourceRef", association.getSourceRef(), xtw);
        this.writeDefaultAttribute("targetRef", association.getTargetRef(), xtw);
        AssociationDirection associationDirection = association.getAssociationDirection();
        if (associationDirection != null) {
            this.writeDefaultAttribute("associationDirection", associationDirection.getValue(), xtw);
        }
    }

    @Override
    protected void writeAdditionalChildElements(BaseElement element, BpmnModel model, XMLStreamWriter xtw) throws Exception {
    }
}

