/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.bpmn.converter.export;

import java.util.List;
import javax.xml.stream.XMLStreamWriter;
import org.apache.commons.lang3.StringUtils;
import org.flowable.bpmn.constants.BpmnXMLConstants;
import org.flowable.bpmn.model.BpmnModel;
import org.flowable.bpmn.model.FlowElement;
import org.flowable.bpmn.model.GraphicInfo;
import org.flowable.bpmn.model.MessageFlow;
import org.flowable.bpmn.model.SubProcess;

public class BPMNDIExport
implements BpmnXMLConstants {
    public static void writeBPMNDI(BpmnModel model, XMLStreamWriter xtw) throws Exception {
        xtw.writeStartElement("bpmndi", "BPMNDiagram", "http://www.omg.org/spec/BPMN/20100524/DI");
        String processId = null;
        processId = !model.getPools().isEmpty() ? "Collaboration" : model.getMainProcess().getId();
        xtw.writeAttribute("id", "BPMNDiagram_" + processId);
        xtw.writeStartElement("bpmndi", "BPMNPlane", "http://www.omg.org/spec/BPMN/20100524/DI");
        xtw.writeAttribute("bpmnElement", processId);
        xtw.writeAttribute("id", "BPMNPlane_" + processId);
        for (String elementId : model.getLocationMap().keySet()) {
            if (model.getFlowElement(elementId) == null && model.getArtifact(elementId) == null && model.getPool(elementId) == null && model.getLane(elementId) == null) continue;
            xtw.writeStartElement("bpmndi", "BPMNShape", "http://www.omg.org/spec/BPMN/20100524/DI");
            xtw.writeAttribute("bpmnElement", elementId);
            xtw.writeAttribute("id", "BPMNShape_" + elementId);
            GraphicInfo graphicInfo = model.getGraphicInfo(elementId);
            FlowElement flowElement = model.getFlowElement(elementId);
            if (flowElement instanceof SubProcess && graphicInfo.getExpanded() != null) {
                xtw.writeAttribute("isExpanded", String.valueOf(graphicInfo.getExpanded()));
            }
            xtw.writeStartElement("omgdc", "Bounds", "http://www.omg.org/spec/DD/20100524/DC");
            xtw.writeAttribute("height", String.valueOf(graphicInfo.getHeight()));
            xtw.writeAttribute("width", String.valueOf(graphicInfo.getWidth()));
            xtw.writeAttribute("x", String.valueOf(graphicInfo.getX()));
            xtw.writeAttribute("y", String.valueOf(graphicInfo.getY()));
            xtw.writeEndElement();
            xtw.writeEndElement();
        }
        for (String elementId : model.getFlowLocationMap().keySet()) {
            if (model.getFlowElement(elementId) == null && model.getArtifact(elementId) == null && model.getMessageFlow(elementId) == null) continue;
            xtw.writeStartElement("bpmndi", "BPMNEdge", "http://www.omg.org/spec/BPMN/20100524/DI");
            xtw.writeAttribute("bpmnElement", elementId);
            xtw.writeAttribute("id", "BPMNEdge_" + elementId);
            List graphicInfoList = model.getFlowLocationGraphicInfo(elementId);
            for (GraphicInfo graphicInfo : graphicInfoList) {
                xtw.writeStartElement("omgdi", "waypoint", "http://www.omg.org/spec/DD/20100524/DI");
                xtw.writeAttribute("x", String.valueOf(graphicInfo.getX()));
                xtw.writeAttribute("y", String.valueOf(graphicInfo.getY()));
                xtw.writeEndElement();
            }
            GraphicInfo labelGraphicInfo = model.getLabelGraphicInfo(elementId);
            FlowElement flowElement = model.getFlowElement(elementId);
            MessageFlow messageFlow = null;
            if (flowElement == null) {
                messageFlow = model.getMessageFlow(elementId);
            }
            boolean hasName = false;
            if (flowElement != null && StringUtils.isNotEmpty((CharSequence)flowElement.getName())) {
                hasName = true;
            } else if (messageFlow != null && StringUtils.isNotEmpty((CharSequence)messageFlow.getName())) {
                hasName = true;
            }
            if (labelGraphicInfo != null && hasName) {
                xtw.writeStartElement("bpmndi", "BPMNLabel", "http://www.omg.org/spec/BPMN/20100524/DI");
                xtw.writeStartElement("omgdc", "Bounds", "http://www.omg.org/spec/DD/20100524/DC");
                xtw.writeAttribute("height", String.valueOf(labelGraphicInfo.getHeight()));
                xtw.writeAttribute("width", String.valueOf(labelGraphicInfo.getWidth()));
                xtw.writeAttribute("x", String.valueOf(labelGraphicInfo.getX()));
                xtw.writeAttribute("y", String.valueOf(labelGraphicInfo.getY()));
                xtw.writeEndElement();
                xtw.writeEndElement();
            }
            xtw.writeEndElement();
        }
        xtw.writeEndElement();
        xtw.writeEndElement();
    }
}

