/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.engine.common.impl.interceptor;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.flowable.engine.common.api.FlowableException;
import org.flowable.engine.common.api.FlowableOptimisticLockingException;
import org.flowable.engine.common.impl.interceptor.BaseCommand;
import org.flowable.engine.common.impl.interceptor.BaseCommandContextCloseListener;
import org.flowable.engine.common.impl.interceptor.Session;
import org.flowable.engine.common.impl.interceptor.SessionFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AbstractCommandContext {
    private static Logger log = LoggerFactory.getLogger(AbstractCommandContext.class);
    protected BaseCommand<?, ? extends AbstractCommandContext> command;
    protected Map<Class<?>, SessionFactory> sessionFactories;
    protected Map<Class<?>, Session> sessions = new HashMap();
    protected Throwable exception;
    protected List<BaseCommandContextCloseListener<AbstractCommandContext>> closeListeners;
    protected Map<String, Object> attributes;
    protected boolean reused;

    public AbstractCommandContext(BaseCommand<?, ? extends AbstractCommandContext> command) {
        this.command = command;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void close() {
        block25: {
            try {
                try {
                    try {
                        this.executeCloseListenersClosing();
                        if (this.exception == null) {
                            this.flushSessions();
                        }
                    }
                    catch (Throwable exception) {
                        try {
                            this.exception(exception);
                            break block25;
                        }
                        catch (Throwable throwable) {
                            throw throwable;
                        }
                        finally {
                            try {
                                if (this.exception == null) {
                                    this.executeCloseListenersAfterSessionFlushed();
                                }
                            }
                            catch (Throwable exception2) {
                                this.exception(exception2);
                            }
                            if (this.exception != null) {
                                this.logException();
                                this.executeCloseListenersCloseFailure();
                            } else {
                                this.executeCloseListenersClosed();
                            }
                        }
                    }
                    try {
                        if (this.exception == null) {
                            this.executeCloseListenersAfterSessionFlushed();
                        }
                    }
                    catch (Throwable exception) {
                        this.exception(exception);
                    }
                    if (this.exception != null) {
                        this.logException();
                        this.executeCloseListenersCloseFailure();
                    } else {
                        this.executeCloseListenersClosed();
                    }
                }
                catch (Throwable exception) {
                    this.exception(exception);
                }
                finally {
                    this.closeSessions();
                }
            }
            catch (Throwable exception) {
                this.exception(exception);
            }
        }
        if (this.exception == null) return;
        this.rethrowExceptionIfNeeded();
    }

    protected void logException() {
        if (this.exception instanceof FlowableOptimisticLockingException) {
            log.debug("Optimistic locking exception : " + this.exception);
        } else {
            log.error("Error while closing command context", this.exception);
        }
    }

    protected void rethrowExceptionIfNeeded() throws Error {
        if (this.exception instanceof Error) {
            throw (Error)this.exception;
        }
        if (this.exception instanceof RuntimeException) {
            throw (RuntimeException)this.exception;
        }
        throw new FlowableException("exception while executing command " + this.command, this.exception);
    }

    public void addCloseListener(BaseCommandContextCloseListener<AbstractCommandContext> commandContextCloseListener) {
        if (this.closeListeners == null) {
            this.closeListeners = new ArrayList<BaseCommandContextCloseListener<AbstractCommandContext>>(1);
        }
        this.closeListeners.add(commandContextCloseListener);
    }

    public List<BaseCommandContextCloseListener<AbstractCommandContext>> getCloseListeners() {
        return this.closeListeners;
    }

    protected void executeCloseListenersClosing() {
        if (this.closeListeners != null) {
            try {
                for (BaseCommandContextCloseListener<AbstractCommandContext> listener : this.closeListeners) {
                    listener.closing(this);
                }
            }
            catch (Throwable exception) {
                this.exception(exception);
            }
        }
    }

    protected void executeCloseListenersAfterSessionFlushed() {
        if (this.closeListeners != null) {
            try {
                for (BaseCommandContextCloseListener<AbstractCommandContext> listener : this.closeListeners) {
                    listener.afterSessionsFlush(this);
                }
            }
            catch (Throwable exception) {
                this.exception(exception);
            }
        }
    }

    protected void executeCloseListenersClosed() {
        if (this.closeListeners != null) {
            try {
                for (BaseCommandContextCloseListener<AbstractCommandContext> listener : this.closeListeners) {
                    listener.closed(this);
                }
            }
            catch (Throwable exception) {
                this.exception(exception);
            }
        }
    }

    protected void executeCloseListenersCloseFailure() {
        if (this.closeListeners != null) {
            try {
                for (BaseCommandContextCloseListener<AbstractCommandContext> listener : this.closeListeners) {
                    listener.closeFailure(this);
                }
            }
            catch (Throwable exception) {
                this.exception(exception);
            }
        }
    }

    protected void flushSessions() {
        for (Session session : this.sessions.values()) {
            session.flush();
        }
    }

    protected void closeSessions() {
        for (Session session : this.sessions.values()) {
            try {
                session.close();
            }
            catch (Throwable exception) {
                this.exception(exception);
            }
        }
    }

    public void exception(Throwable exception) {
        if (this.exception == null) {
            this.exception = exception;
        } else {
            log.error("masked exception in command context. for root cause, see below as it will be rethrown later.", exception);
        }
    }

    public void addAttribute(String key, Object value) {
        if (this.attributes == null) {
            this.attributes = new HashMap<String, Object>(1);
        }
        this.attributes.put(key, value);
    }

    public Object getAttribute(String key) {
        if (this.attributes != null) {
            return this.attributes.get(key);
        }
        return null;
    }

    public <T> T getSession(Class<T> sessionClass) {
        Session session = this.sessions.get(sessionClass);
        if (session == null) {
            SessionFactory sessionFactory = this.sessionFactories.get(sessionClass);
            if (sessionFactory == null) {
                throw new FlowableException("no session factory configured for " + sessionClass.getName());
            }
            session = sessionFactory.openSession(this);
            this.sessions.put(sessionClass, session);
        }
        return (T)session;
    }

    public Map<Class<?>, SessionFactory> getSessionFactories() {
        return this.sessionFactories;
    }

    public BaseCommand<?, ? extends AbstractCommandContext> getCommand() {
        return this.command;
    }

    public Map<Class<?>, Session> getSessions() {
        return this.sessions;
    }

    public Throwable getException() {
        return this.exception;
    }

    public boolean isReused() {
        return this.reused;
    }

    public void setReused(boolean reused) {
        this.reused = reused;
    }
}

