/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.eventregistry.impl;

import java.util.List;
import org.flowable.common.engine.api.Engine;
import org.flowable.common.engine.api.engine.EngineLifecycleListener;
import org.flowable.eventregistry.api.ChannelDefinition;
import org.flowable.eventregistry.api.EventManagementService;
import org.flowable.eventregistry.api.EventRegistry;
import org.flowable.eventregistry.api.EventRepositoryService;
import org.flowable.eventregistry.impl.EventRegistryEngine;
import org.flowable.eventregistry.impl.EventRegistryEngineConfiguration;
import org.flowable.eventregistry.impl.EventRegistryEngines;
import org.flowable.eventregistry.model.ChannelModel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EventRegistryEngineImpl
implements EventRegistryEngine {
    private static final Logger LOGGER = LoggerFactory.getLogger(EventRegistryEngineImpl.class);
    protected String name;
    protected EventRepositoryService repositoryService;
    protected EventManagementService managementService;
    protected EventRegistry eventRegistry;
    protected EventRegistryEngineConfiguration engineConfiguration;

    public EventRegistryEngineImpl(EventRegistryEngineConfiguration engineConfiguration) {
        this.engineConfiguration = engineConfiguration;
        this.name = engineConfiguration.getEngineName();
        this.repositoryService = engineConfiguration.getEventRepositoryService();
        this.managementService = engineConfiguration.getEventManagementService();
        this.eventRegistry = engineConfiguration.getEventRegistry();
        if (engineConfiguration.getSchemaManagementCmd() != null) {
            engineConfiguration.getCommandExecutor().execute(engineConfiguration.getSchemaCommandConfig(), engineConfiguration.getSchemaManagementCmd());
        }
        if (this.name == null) {
            LOGGER.info("default flowable EventRegistryEngine created");
        } else {
            LOGGER.info("EventRegistryEngine {} created", (Object)this.name);
        }
        EventRegistryEngines.registerEventRegistryEngine(this);
        if (engineConfiguration.getEngineLifecycleListeners() != null) {
            for (EngineLifecycleListener engineLifecycleListener : engineConfiguration.getEngineLifecycleListeners()) {
                engineLifecycleListener.onEngineBuilt((Engine)this);
            }
        }
    }

    @Override
    public void handleDeployedChannelDefinitions() {
        List channelDefinitions = this.repositoryService.createChannelDefinitionQuery().latestVersion().list();
        for (ChannelDefinition channelDefinition : channelDefinitions) {
            ChannelModel channelModel = this.repositoryService.getChannelModelById(channelDefinition.getId());
            LOGGER.info("Booted up channel {} ", (Object)channelModel.getKey());
        }
    }

    public void close() {
        EventRegistryEngines.unregister(this);
        this.engineConfiguration.close();
        if (this.engineConfiguration.getEngineLifecycleListeners() != null) {
            for (EngineLifecycleListener engineLifecycleListener : this.engineConfiguration.getEngineLifecycleListeners()) {
                engineLifecycleListener.onEngineClosed((Engine)this);
            }
        }
    }

    public String getName() {
        return this.name;
    }

    @Override
    public EventRepositoryService getEventRepositoryService() {
        return this.repositoryService;
    }

    @Override
    public EventManagementService getEventManagementService() {
        return this.managementService;
    }

    @Override
    public EventRegistry getEventRegistry() {
        return this.eventRegistry;
    }

    @Override
    public EventRegistryEngineConfiguration getEventRegistryEngineConfiguration() {
        return this.engineConfiguration;
    }
}

