/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.eventregistry.impl.persistence.entity.data.impl;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.flowable.common.engine.impl.persistence.entity.Entity;
import org.flowable.eventregistry.impl.persistence.entity.ChannelDefinitionEntity;
import org.flowable.eventregistry.impl.persistence.entity.EventDefinitionEntity;
import org.flowable.eventregistry.impl.persistence.entity.EventDeploymentEntity;
import org.flowable.eventregistry.impl.persistence.entity.EventResourceEntity;
import org.flowable.eventregistry.impl.persistence.entity.data.TableDataManager;
import org.flowable.eventregistry.impl.util.CommandContextUtil;

public class TableDataManagerImpl
implements TableDataManager {
    public static Map<Class<? extends Entity>, String> entityToTableNameMap = new HashMap<Class<? extends Entity>, String>();

    @Override
    public Map<String, Long> getTableCount() {
        HashMap<String, Long> counts = new HashMap<String, Long>();
        for (String table : this.getTablesPresentInDatabase()) {
            counts.put(table, (Long)CommandContextUtil.getDbSqlSession().selectOne("org.flowable.eventregistry.impl.TableData.selectTableCount", (Object)table));
        }
        return counts;
    }

    @Override
    public Collection<String> getTablesPresentInDatabase() {
        return entityToTableNameMap.values();
    }

    @Override
    public String getTableName(Class<?> entityClass, boolean withPrefix) {
        String databaseTablePrefix = CommandContextUtil.getDbSqlSession().getDbSqlSessionFactory().getDatabaseTablePrefix();
        String tableName = entityToTableNameMap.get(entityClass);
        if (withPrefix) {
            return databaseTablePrefix + tableName;
        }
        return tableName;
    }

    static {
        entityToTableNameMap.put(EventDeploymentEntity.class, "FLW_EVENT_DEPLOYMENT");
        entityToTableNameMap.put(EventResourceEntity.class, "FLW_EVENT_RESOURCE");
        entityToTableNameMap.put(EventDefinitionEntity.class, "FLW_EVENT_DEFINITION");
        entityToTableNameMap.put(ChannelDefinitionEntity.class, "FLW_CHANNEL_DEFINITION");
    }
}

