/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.eventregistry.impl.cmd;

import java.io.Serializable;
import java.util.List;
import org.flowable.common.engine.api.FlowableIllegalArgumentException;
import org.flowable.common.engine.api.FlowableObjectNotFoundException;
import org.flowable.common.engine.impl.interceptor.Command;
import org.flowable.common.engine.impl.interceptor.CommandContext;
import org.flowable.eventregistry.api.EventDefinition;
import org.flowable.eventregistry.impl.EventDefinitionQueryImpl;
import org.flowable.eventregistry.impl.persistence.entity.EventDeploymentEntity;
import org.flowable.eventregistry.impl.util.CommandContextUtil;

public class SetDeploymentTenantIdCmd
implements Command<Void>,
Serializable {
    private static final long serialVersionUID = 1L;
    protected String deploymentId;
    protected String newTenantId;

    public SetDeploymentTenantIdCmd(String deploymentId, String newTenantId) {
        this.deploymentId = deploymentId;
        this.newTenantId = newTenantId;
    }

    public Void execute(CommandContext commandContext) {
        if (this.deploymentId == null) {
            throw new FlowableIllegalArgumentException("deploymentId is null");
        }
        EventDeploymentEntity deployment = (EventDeploymentEntity)CommandContextUtil.getDeploymentEntityManager(commandContext).findById(this.deploymentId);
        if (deployment == null) {
            throw new FlowableObjectNotFoundException("Could not find deployment with id " + this.deploymentId);
        }
        deployment.setTenantId(this.newTenantId);
        CommandContextUtil.getEventDefinitionEntityManager(commandContext).updateEventDefinitionTenantIdForDeployment(this.deploymentId, this.newTenantId);
        List eventDefinitions = new EventDefinitionQueryImpl().deploymentId(this.deploymentId).list();
        for (EventDefinition eventDefinition : eventDefinitions) {
            CommandContextUtil.getEventRegistryConfiguration().getEventDefinitionCache().remove(eventDefinition.getId());
        }
        CommandContextUtil.getDeploymentEntityManager(commandContext).update(deployment);
        return null;
    }
}

