/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.eventregistry.test;

import java.io.InputStream;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.flowable.common.engine.api.FlowableObjectNotFoundException;
import org.flowable.eventregistry.api.EventDeploymentBuilder;
import org.flowable.eventregistry.api.EventRepositoryService;
import org.flowable.eventregistry.impl.EventRegistryEngine;
import org.flowable.eventregistry.impl.EventRegistryEngineConfiguration;
import org.flowable.eventregistry.impl.deployer.ParsedDeploymentBuilder;
import org.flowable.eventregistry.test.ChannelDeploymentAnnotation;
import org.flowable.eventregistry.test.EventDeploymentAnnotation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class EventTestHelper {
    private static final Logger LOGGER = LoggerFactory.getLogger(EventTestHelper.class);
    public static final String EMPTY_LINE = "\n";
    static Map<String, EventRegistryEngine> eventRegistryEngines = new HashMap<String, EventRegistryEngine>();

    public static String annotationDeploymentSetUp(EventRepositoryService eventRepositoryService, Class<?> testClass, String methodName) {
        Method method = null;
        try {
            method = testClass.getMethod(methodName, null);
        }
        catch (Exception e) {
            LOGGER.warn("Could not get method by reflection. This could happen if you are using @Parameters in combination with annotations.", (Throwable)e);
            return null;
        }
        EventDeploymentAnnotation eventDeploymentAnnotation = method.getAnnotation(EventDeploymentAnnotation.class);
        ChannelDeploymentAnnotation channelDeploymentAnnotation = method.getAnnotation(ChannelDeploymentAnnotation.class);
        return EventTestHelper.annotationDeploymentSetUp(eventRepositoryService, testClass, method, eventDeploymentAnnotation, channelDeploymentAnnotation);
    }

    public static String annotationDeploymentSetUp(EventRepositoryService eventRepositoryService, Class<?> testClass, Method method, EventDeploymentAnnotation eventDeploymentAnnotation, ChannelDeploymentAnnotation channelDeploymentAnnotation) {
        String methodName;
        String deploymentId = null;
        String tenantId = null;
        String[] resources = null;
        if (eventDeploymentAnnotation != null) {
            methodName = method.getName();
            LOGGER.debug("annotation @EventDeployment creates deployment for {}.{}", (Object)testClass.getSimpleName(), (Object)methodName);
            resources = eventDeploymentAnnotation.resources();
            tenantId = eventDeploymentAnnotation.tenantId();
            if (resources.length == 0) {
                String resource = EventTestHelper.getEventResource(testClass, methodName);
                resources = new String[]{resource};
            }
        }
        if (channelDeploymentAnnotation != null) {
            methodName = method.getName();
            LOGGER.debug("annotation @ChannelDeployment creates deployment for {}.{}", (Object)testClass.getSimpleName(), (Object)methodName);
            String[] channelResources = channelDeploymentAnnotation.resources();
            tenantId = channelDeploymentAnnotation.tenantId();
            if (channelResources.length == 0) {
                String resource = EventTestHelper.getChannelResource(testClass, methodName);
                channelResources = new String[]{resource};
            }
            if (resources != null) {
                ArrayList<String> resourceList = new ArrayList<String>(Arrays.asList(resources));
                resourceList.addAll(new ArrayList<String>(Arrays.asList(channelResources)));
                resources = resourceList.toArray(new String[channelResources.length]);
            } else {
                resources = channelResources;
            }
        }
        if (resources != null && resources.length > 0) {
            EventDeploymentBuilder deploymentBuilder = eventRepositoryService.createDeployment().name(testClass.getSimpleName() + "." + method.getName());
            for (String resource : resources) {
                deploymentBuilder.addClasspathResource(resource);
            }
            if (StringUtils.isNotEmpty((CharSequence)tenantId)) {
                deploymentBuilder.tenantId(tenantId);
            }
            deploymentId = deploymentBuilder.deploy().getId();
        }
        return deploymentId;
    }

    public static void annotationDeploymentTearDown(EventRepositoryService eventRepositoryService, String deploymentId, Class<?> testClass, String methodName) {
        LOGGER.debug("annotation @Deployment deletes deployment for {}.{}", (Object)testClass.getSimpleName(), (Object)methodName);
        if (deploymentId != null) {
            try {
                eventRepositoryService.deleteDeployment(deploymentId);
            }
            catch (FlowableObjectNotFoundException flowableObjectNotFoundException) {
                // empty catch block
            }
        }
    }

    public static String getEventResource(Class<?> type, String name) {
        for (String suffix : ParsedDeploymentBuilder.EVENT_RESOURCE_SUFFIXES) {
            String resource = type.getName().replace('.', '/') + "." + name + "." + suffix;
            InputStream inputStream = EventTestHelper.class.getClassLoader().getResourceAsStream(resource);
            if (inputStream == null) continue;
            return resource;
        }
        return type.getName().replace('.', '/') + "." + name + "." + ParsedDeploymentBuilder.EVENT_RESOURCE_SUFFIXES[0];
    }

    public static String getChannelResource(Class<?> type, String name) {
        for (String suffix : ParsedDeploymentBuilder.CHANNEL_RESOURCE_SUFFIXES) {
            String resource = type.getName().replace('.', '/') + "." + name + "." + suffix;
            InputStream inputStream = EventTestHelper.class.getClassLoader().getResourceAsStream(resource);
            if (inputStream == null) continue;
            return resource;
        }
        return type.getName().replace('.', '/') + "." + name + "." + ParsedDeploymentBuilder.CHANNEL_RESOURCE_SUFFIXES[0];
    }

    public static EventRegistryEngine getEventRegistryEngine(String configurationResource) {
        EventRegistryEngine eventRegistryEngine = eventRegistryEngines.get(configurationResource);
        if (eventRegistryEngine == null) {
            LOGGER.debug("==== BUILDING EVENT REGISTRY ENGINE ========================================================================");
            eventRegistryEngine = ((EventRegistryEngineConfiguration)EventRegistryEngineConfiguration.createEventRegistryEngineConfigurationFromResource(configurationResource).setDatabaseSchemaUpdate("drop-create")).buildEventRegistryEngine();
            LOGGER.debug("==== EVENT REGISTRY ENGINE CREATED =========================================================================");
            eventRegistryEngines.put(configurationResource, eventRegistryEngine);
        }
        return eventRegistryEngine;
    }

    public static void closeEventRegistryEngines() {
        for (EventRegistryEngine eventRegistryEngine : eventRegistryEngines.values()) {
            eventRegistryEngine.close();
        }
        eventRegistryEngines.clear();
    }

    public static void assertAndEnsureCleanDb(EventRegistryEngine eventRegistryEngine) {
        LOGGER.debug("verifying that db is clean after test");
        EventRepositoryService repositoryService = eventRegistryEngine.getEventRegistryEngineConfiguration().getEventRepositoryService();
        List deployments = repositoryService.createDeploymentQuery().list();
        if (deployments != null && !deployments.isEmpty()) {
            throw new AssertionError((Object)"EventDeployments is not empty");
        }
    }
}

