/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.eventregistry.impl;

import java.util.List;
import java.util.Set;
import org.flowable.common.engine.api.FlowableIllegalArgumentException;
import org.flowable.common.engine.impl.interceptor.CommandContext;
import org.flowable.common.engine.impl.interceptor.CommandExecutor;
import org.flowable.common.engine.impl.query.AbstractQuery;
import org.flowable.eventregistry.api.EventDefinition;
import org.flowable.eventregistry.api.EventDefinitionQuery;
import org.flowable.eventregistry.impl.EventDefinitionQueryProperty;
import org.flowable.eventregistry.impl.util.CommandContextUtil;

public class EventDefinitionQueryImpl
extends AbstractQuery<EventDefinitionQuery, EventDefinition>
implements EventDefinitionQuery {
    private static final long serialVersionUID = 1L;
    protected String id;
    protected Set<String> ids;
    protected String category;
    protected String categoryLike;
    protected String categoryNotEquals;
    protected String name;
    protected String nameLike;
    protected String nameLikeIgnoreCase;
    protected String deploymentId;
    protected Set<String> deploymentIds;
    protected String parentDeploymentId;
    protected String key;
    protected String keyLike;
    protected String keyLikeIgnoreCase;
    protected Integer version;
    protected Integer versionGt;
    protected Integer versionGte;
    protected Integer versionLt;
    protected Integer versionLte;
    protected boolean latest;
    protected String resourceName;
    protected String resourceNameLike;
    protected String tenantId;
    protected String tenantIdLike;
    protected boolean withoutTenantId;

    public EventDefinitionQueryImpl() {
    }

    public EventDefinitionQueryImpl(CommandContext commandContext) {
        super(commandContext);
    }

    public EventDefinitionQueryImpl(CommandExecutor commandExecutor) {
        super(commandExecutor);
    }

    public EventDefinitionQueryImpl eventDefinitionId(String eventDefinitionId) {
        this.id = eventDefinitionId;
        return this;
    }

    public EventDefinitionQueryImpl eventDefinitionIds(Set<String> eventDefinitionIds) {
        this.ids = eventDefinitionIds;
        return this;
    }

    public EventDefinitionQueryImpl eventCategory(String category) {
        if (category == null) {
            throw new FlowableIllegalArgumentException("category is null");
        }
        this.category = category;
        return this;
    }

    public EventDefinitionQueryImpl eventCategoryLike(String categoryLike) {
        if (categoryLike == null) {
            throw new FlowableIllegalArgumentException("categoryLike is null");
        }
        this.categoryLike = categoryLike;
        return this;
    }

    public EventDefinitionQueryImpl eventCategoryNotEquals(String categoryNotEquals) {
        if (categoryNotEquals == null) {
            throw new FlowableIllegalArgumentException("categoryNotEquals is null");
        }
        this.categoryNotEquals = categoryNotEquals;
        return this;
    }

    public EventDefinitionQueryImpl eventDefinitionName(String name) {
        if (name == null) {
            throw new FlowableIllegalArgumentException("name is null");
        }
        this.name = name;
        return this;
    }

    public EventDefinitionQueryImpl eventDefinitionNameLike(String nameLike) {
        if (nameLike == null) {
            throw new FlowableIllegalArgumentException("nameLike is null");
        }
        this.nameLike = nameLike;
        return this;
    }

    public EventDefinitionQueryImpl eventDefinitionNameLikeIgnoreCase(String nameLikeIgnoreCase) {
        if (nameLikeIgnoreCase == null) {
            throw new FlowableIllegalArgumentException("nameLikeIgnoreCase is null");
        }
        this.nameLikeIgnoreCase = nameLikeIgnoreCase;
        return this;
    }

    public EventDefinitionQueryImpl deploymentId(String deploymentId) {
        if (deploymentId == null) {
            throw new FlowableIllegalArgumentException("id is null");
        }
        this.deploymentId = deploymentId;
        return this;
    }

    public EventDefinitionQueryImpl deploymentIds(Set<String> deploymentIds) {
        if (deploymentIds == null) {
            throw new FlowableIllegalArgumentException("ids are null");
        }
        this.deploymentIds = deploymentIds;
        return this;
    }

    public EventDefinitionQueryImpl parentDeploymentId(String parentDeploymentId) {
        if (parentDeploymentId == null) {
            throw new FlowableIllegalArgumentException("parentDeploymentId is null");
        }
        this.parentDeploymentId = parentDeploymentId;
        return this;
    }

    public EventDefinitionQueryImpl eventDefinitionKey(String key) {
        if (key == null) {
            throw new FlowableIllegalArgumentException("key is null");
        }
        this.key = key;
        return this;
    }

    public EventDefinitionQueryImpl eventDefinitionKeyLike(String keyLike) {
        if (keyLike == null) {
            throw new FlowableIllegalArgumentException("keyLike is null");
        }
        this.keyLike = keyLike;
        return this;
    }

    public EventDefinitionQueryImpl eventDefinitionKeyLikeIgnoreCase(String keyLikeIgnoreCase) {
        if (keyLikeIgnoreCase == null) {
            throw new FlowableIllegalArgumentException("keyLikeIgnoreCase is null");
        }
        this.keyLikeIgnoreCase = keyLikeIgnoreCase;
        return this;
    }

    public EventDefinitionQueryImpl eventVersion(Integer version) {
        this.checkVersion(version);
        this.version = version;
        return this;
    }

    public EventDefinitionQueryImpl eventVersionGreaterThan(Integer eventVersion) {
        this.checkVersion(eventVersion);
        this.versionGt = eventVersion;
        return this;
    }

    public EventDefinitionQueryImpl eventVersionGreaterThanOrEquals(Integer eventVersion) {
        this.checkVersion(eventVersion);
        this.versionGte = eventVersion;
        return this;
    }

    public EventDefinitionQueryImpl eventVersionLowerThan(Integer eventVersion) {
        this.checkVersion(eventVersion);
        this.versionLt = eventVersion;
        return this;
    }

    public EventDefinitionQueryImpl eventVersionLowerThanOrEquals(Integer eventVersion) {
        this.checkVersion(eventVersion);
        this.versionLte = eventVersion;
        return this;
    }

    protected void checkVersion(Integer version) {
        if (version == null) {
            throw new FlowableIllegalArgumentException("version is null");
        }
        if (version <= 0) {
            throw new FlowableIllegalArgumentException("version must be positive");
        }
    }

    public EventDefinitionQueryImpl latestVersion() {
        this.latest = true;
        return this;
    }

    public EventDefinitionQueryImpl eventDefinitionResourceName(String resourceName) {
        if (resourceName == null) {
            throw new FlowableIllegalArgumentException("resourceName is null");
        }
        this.resourceName = resourceName;
        return this;
    }

    public EventDefinitionQueryImpl eventDefinitionResourceNameLike(String resourceNameLike) {
        if (resourceNameLike == null) {
            throw new FlowableIllegalArgumentException("resourceNameLike is null");
        }
        this.resourceNameLike = resourceNameLike;
        return this;
    }

    public EventDefinitionQueryImpl tenantId(String tenantId) {
        if (tenantId == null) {
            throw new FlowableIllegalArgumentException("form tenantId is null");
        }
        this.tenantId = tenantId;
        return this;
    }

    public EventDefinitionQueryImpl tenantIdLike(String tenantIdLike) {
        if (tenantIdLike == null) {
            throw new FlowableIllegalArgumentException("form tenantId is null");
        }
        this.tenantIdLike = tenantIdLike;
        return this;
    }

    public EventDefinitionQueryImpl withoutTenantId() {
        this.withoutTenantId = true;
        return this;
    }

    public EventDefinitionQuery orderByDeploymentId() {
        return (EventDefinitionQuery)this.orderBy(EventDefinitionQueryProperty.DEPLOYMENT_ID);
    }

    public EventDefinitionQuery orderByEventDefinitionKey() {
        return (EventDefinitionQuery)this.orderBy(EventDefinitionQueryProperty.KEY);
    }

    public EventDefinitionQuery orderByEventDefinitionCategory() {
        return (EventDefinitionQuery)this.orderBy(EventDefinitionQueryProperty.CATEGORY);
    }

    public EventDefinitionQuery orderByEventDefinitionId() {
        return (EventDefinitionQuery)this.orderBy(EventDefinitionQueryProperty.ID);
    }

    public EventDefinitionQuery orderByEventDefinitionName() {
        return (EventDefinitionQuery)this.orderBy(EventDefinitionQueryProperty.NAME);
    }

    public EventDefinitionQuery orderByTenantId() {
        return (EventDefinitionQuery)this.orderBy(EventDefinitionQueryProperty.TENANT_ID);
    }

    public long executeCount(CommandContext commandContext) {
        return CommandContextUtil.getEventDefinitionEntityManager(commandContext).findEventDefinitionCountByQueryCriteria(this);
    }

    public List<EventDefinition> executeList(CommandContext commandContext) {
        return CommandContextUtil.getEventDefinitionEntityManager(commandContext).findEventDefinitionsByQueryCriteria(this);
    }

    public String getDeploymentId() {
        return this.deploymentId;
    }

    public Set<String> getDeploymentIds() {
        return this.deploymentIds;
    }

    public String getParentDeploymentId() {
        return this.parentDeploymentId;
    }

    public String getId() {
        return this.id;
    }

    public Set<String> getIds() {
        return this.ids;
    }

    public String getName() {
        return this.name;
    }

    public String getNameLike() {
        return this.nameLike;
    }

    public String getNameLikeIgnoreCase() {
        return this.nameLikeIgnoreCase;
    }

    public String getKey() {
        return this.key;
    }

    public String getKeyLike() {
        return this.keyLike;
    }

    public String getKeyLikeIgnoreCase() {
        return this.keyLikeIgnoreCase;
    }

    public String getCategory() {
        return this.category;
    }

    public String getCategoryLike() {
        return this.categoryLike;
    }

    public String getResourceName() {
        return this.resourceName;
    }

    public String getResourceNameLike() {
        return this.resourceNameLike;
    }

    public String getCategoryNotEquals() {
        return this.categoryNotEquals;
    }

    public String getTenantId() {
        return this.tenantId;
    }

    public String getTenantIdLike() {
        return this.tenantIdLike;
    }

    public boolean isWithoutTenantId() {
        return this.withoutTenantId;
    }
}

