/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.editor.language.json.converter;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.flowable.bpmn.model.BaseElement;
import org.flowable.bpmn.model.BpmnModel;
import org.flowable.bpmn.model.FlowElementsContainer;
import org.flowable.bpmn.model.GraphicInfo;
import org.flowable.bpmn.model.MessageFlow;
import org.flowable.editor.language.json.converter.ActivityProcessor;
import org.flowable.editor.language.json.converter.BaseBpmnJsonConverter;
import org.flowable.editor.language.json.converter.BpmnJsonConverterUtil;

public class MessageFlowJsonConverter
extends BaseBpmnJsonConverter {
    public static void fillTypes(Map<String, Class<? extends BaseBpmnJsonConverter>> convertersToBpmnMap, Map<Class<? extends BaseElement>, Class<? extends BaseBpmnJsonConverter>> convertersToJsonMap) {
        MessageFlowJsonConverter.fillJsonTypes(convertersToBpmnMap);
        MessageFlowJsonConverter.fillBpmnTypes(convertersToJsonMap);
    }

    public static void fillJsonTypes(Map<String, Class<? extends BaseBpmnJsonConverter>> convertersToBpmnMap) {
        convertersToBpmnMap.put("MessageFlow", MessageFlowJsonConverter.class);
    }

    public static void fillBpmnTypes(Map<Class<? extends BaseElement>, Class<? extends BaseBpmnJsonConverter>> convertersToJsonMap) {
        convertersToJsonMap.put(MessageFlow.class, MessageFlowJsonConverter.class);
    }

    @Override
    protected String getStencilId(BaseElement baseElement) {
        return "MessageFlow";
    }

    @Override
    public void convertToJson(BaseElement baseElement, ActivityProcessor processor, BpmnModel model, FlowElementsContainer container, ArrayNode shapesArrayNode, double subProcessX, double subProcessY) {
        MessageFlow messageFlow = (MessageFlow)baseElement;
        ObjectNode flowNode = BpmnJsonConverterUtil.createChildShape(messageFlow.getId(), "MessageFlow", 172.0, 212.0, 128.0, 212.0);
        ArrayNode dockersArrayNode = this.objectMapper.createArrayNode();
        ObjectNode dockNode = this.objectMapper.createObjectNode();
        dockNode.put("x", model.getGraphicInfo(messageFlow.getSourceRef()).getWidth() / 2.0);
        dockNode.put("y", model.getGraphicInfo(messageFlow.getSourceRef()).getHeight() / 2.0);
        dockersArrayNode.add((JsonNode)dockNode);
        if (model.getFlowLocationGraphicInfo(messageFlow.getId()).size() > 2) {
            for (int i = 1; i < model.getFlowLocationGraphicInfo(messageFlow.getId()).size() - 1; ++i) {
                GraphicInfo graphicInfo = (GraphicInfo)model.getFlowLocationGraphicInfo(messageFlow.getId()).get(i);
                dockNode = this.objectMapper.createObjectNode();
                dockNode.put("x", graphicInfo.getX());
                dockNode.put("y", graphicInfo.getY());
                dockersArrayNode.add((JsonNode)dockNode);
            }
        }
        dockNode = this.objectMapper.createObjectNode();
        dockNode.put("x", model.getGraphicInfo(messageFlow.getTargetRef()).getWidth() / 2.0);
        dockNode.put("y", model.getGraphicInfo(messageFlow.getTargetRef()).getHeight() / 2.0);
        dockersArrayNode.add((JsonNode)dockNode);
        flowNode.set("dockers", (JsonNode)dockersArrayNode);
        ArrayNode outgoingArrayNode = this.objectMapper.createArrayNode();
        outgoingArrayNode.add((JsonNode)BpmnJsonConverterUtil.createResourceNode(messageFlow.getTargetRef()));
        flowNode.set("outgoing", (JsonNode)outgoingArrayNode);
        flowNode.set("target", (JsonNode)BpmnJsonConverterUtil.createResourceNode(messageFlow.getTargetRef()));
        ObjectNode propertiesNode = this.objectMapper.createObjectNode();
        propertiesNode.put("overrideid", messageFlow.getId());
        if (StringUtils.isNotEmpty((CharSequence)messageFlow.getName())) {
            propertiesNode.put("name", messageFlow.getName());
        }
        flowNode.set("properties", (JsonNode)propertiesNode);
        shapesArrayNode.add((JsonNode)flowNode);
    }

    @Override
    protected void convertElementToJson(ObjectNode propertiesNode, BaseElement baseElement) {
    }

    @Override
    protected BaseElement convertJsonToElement(JsonNode elementNode, JsonNode modelNode, Map<String, JsonNode> shapeMap) {
        MessageFlow flow = new MessageFlow();
        String sourceRef = BpmnJsonConverterUtil.lookForSourceRef(elementNode.get("resourceId").asText(), modelNode.get("childShapes"));
        if (sourceRef != null) {
            String targetId;
            flow.setSourceRef(sourceRef);
            JsonNode targetNode = elementNode.get("target");
            if (targetNode != null && !targetNode.isNull() && shapeMap.get(targetId = targetNode.get("resourceId").asText()) != null) {
                flow.setTargetRef(BpmnJsonConverterUtil.getElementId(shapeMap.get(targetId)));
            }
        }
        return flow;
    }
}

