/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.editor.language.json.converter;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.List;
import java.util.Map;
import org.flowable.bpmn.model.BaseElement;
import org.flowable.bpmn.model.CompensateEventDefinition;
import org.flowable.bpmn.model.EscalationEventDefinition;
import org.flowable.bpmn.model.Event;
import org.flowable.bpmn.model.EventDefinition;
import org.flowable.bpmn.model.FlowElement;
import org.flowable.bpmn.model.SignalEventDefinition;
import org.flowable.bpmn.model.ThrowEvent;
import org.flowable.editor.language.json.converter.BaseBpmnJsonConverter;
import org.flowable.editor.language.json.converter.BpmnJsonConverterUtil;

public class ThrowEventJsonConverter
extends BaseBpmnJsonConverter {
    public static void fillTypes(Map<String, Class<? extends BaseBpmnJsonConverter>> convertersToBpmnMap, Map<Class<? extends BaseElement>, Class<? extends BaseBpmnJsonConverter>> convertersToJsonMap) {
        ThrowEventJsonConverter.fillJsonTypes(convertersToBpmnMap);
        ThrowEventJsonConverter.fillBpmnTypes(convertersToJsonMap);
    }

    public static void fillJsonTypes(Map<String, Class<? extends BaseBpmnJsonConverter>> convertersToBpmnMap) {
        convertersToBpmnMap.put("ThrowNoneEvent", ThrowEventJsonConverter.class);
        convertersToBpmnMap.put("ThrowSignalEvent", ThrowEventJsonConverter.class);
        convertersToBpmnMap.put("ThrowEscalationEvent", ThrowEventJsonConverter.class);
        convertersToBpmnMap.put("ThrowCompensationEvent", ThrowEventJsonConverter.class);
    }

    public static void fillBpmnTypes(Map<Class<? extends BaseElement>, Class<? extends BaseBpmnJsonConverter>> convertersToJsonMap) {
        convertersToJsonMap.put(ThrowEvent.class, ThrowEventJsonConverter.class);
    }

    @Override
    protected String getStencilId(BaseElement baseElement) {
        ThrowEvent throwEvent = (ThrowEvent)baseElement;
        List eventDefinitions = throwEvent.getEventDefinitions();
        if (eventDefinitions.size() != 1) {
            return "ThrowNoneEvent";
        }
        EventDefinition eventDefinition = (EventDefinition)eventDefinitions.get(0);
        if (eventDefinition instanceof SignalEventDefinition) {
            return "ThrowSignalEvent";
        }
        if (eventDefinition instanceof EscalationEventDefinition) {
            return "ThrowEscalationEvent";
        }
        if (eventDefinition instanceof CompensateEventDefinition) {
            return "ThrowCompensationEvent";
        }
        return "ThrowNoneEvent";
    }

    @Override
    protected void convertElementToJson(ObjectNode propertiesNode, BaseElement baseElement) {
        ThrowEvent throwEvent = (ThrowEvent)baseElement;
        if (throwEvent.isAsynchronous()) {
            propertiesNode.put("asynchronousdefinition", true);
        }
        this.addEventProperties((Event)throwEvent, propertiesNode);
    }

    protected FlowElement convertJsonToElement(JsonNode elementNode, JsonNode modelNode, Map<String, JsonNode> shapeMap) {
        String stencilId;
        ThrowEvent throwEvent = new ThrowEvent();
        boolean isAsync = this.getPropertyValueAsBoolean("asynchronousdefinition", elementNode);
        if (isAsync) {
            throwEvent.setAsynchronous(isAsync);
        }
        if ("ThrowSignalEvent".equals(stencilId = BpmnJsonConverterUtil.getStencilId(elementNode))) {
            this.convertJsonToSignalDefinition(elementNode, (Event)throwEvent);
        } else if ("ThrowEscalationEvent".equals(stencilId)) {
            this.convertJsonToEscalationDefinition(elementNode, (Event)throwEvent);
        } else if ("ThrowCompensationEvent".equals(stencilId)) {
            this.convertJsonToCompensationDefinition(elementNode, (Event)throwEvent);
        }
        return throwEvent;
    }
}

