/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.grizzly.http2;

import java.util.Arrays;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.net.ssl.SSLEngine;
import org.glassfish.grizzly.Connection;
import org.glassfish.grizzly.Grizzly;
import org.glassfish.grizzly.http2.AlpnSupport;
import org.glassfish.grizzly.http2.Http2ClientFilter;
import org.glassfish.grizzly.http2.Http2Connection;
import org.glassfish.grizzly.http2.Http2State;
import org.glassfish.grizzly.npn.AlpnClientNegotiator;

class AlpnClientNegotiatorImpl
implements AlpnClientNegotiator {
    private static final Logger LOGGER = Grizzly.logger(AlpnClientNegotiatorImpl.class);
    private final String[] supportedProtocolsStr = new String[]{"h2", "http/1.1"};
    private final Http2ClientFilter filter;

    public AlpnClientNegotiatorImpl(Http2ClientFilter filter) {
        this.filter = filter;
    }

    public String[] getProtocols(SSLEngine sslEngine) {
        if (LOGGER.isLoggable(Level.INFO)) {
            LOGGER.log(Level.INFO, "Alpn getProtocols. Connection={0}, protocols={1}", new Object[]{AlpnSupport.getConnection(sslEngine), Arrays.toString(this.supportedProtocolsStr)});
        }
        return this.supportedProtocolsStr;
    }

    public void protocolSelected(SSLEngine sslEngine, String selectedProtocol) {
        if (LOGGER.isLoggable(Level.INFO)) {
            LOGGER.log(Level.INFO, "Alpn protocolSelected. Connection={0}, protocol={1}", new Object[]{AlpnSupport.getConnection(sslEngine), selectedProtocol});
        }
        Connection connection = AlpnSupport.getConnection(sslEngine);
        if ("h2".equals(selectedProtocol)) {
            Http2Connection http2Connection = this.filter.createClientHttp2Connection(connection);
            http2Connection.getHttp2State().setDirectUpgradePhase();
            http2Connection.sendPreface();
        } else {
            Http2State.create(connection).setNeverHttp2();
        }
    }
}

