/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.grizzly.http2;

import java.util.Arrays;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.net.ssl.SSLEngine;
import org.glassfish.grizzly.Connection;
import org.glassfish.grizzly.Grizzly;
import org.glassfish.grizzly.http2.AlpnSupport;
import org.glassfish.grizzly.http2.Http2BaseFilter;
import org.glassfish.grizzly.http2.Http2Connection;
import org.glassfish.grizzly.http2.Http2ServerFilter;
import org.glassfish.grizzly.http2.Http2State;
import org.glassfish.grizzly.npn.AlpnServerNegotiator;

final class AlpnServerNegotiatorImpl
implements AlpnServerNegotiator {
    private static final Logger LOGGER = Grizzly.logger(AlpnServerNegotiatorImpl.class);
    private final String[] supportedProtocols = new String[]{"h2", "http/1.1"};
    private final Http2BaseFilter filter;

    public AlpnServerNegotiatorImpl(Http2ServerFilter http2HandlerFilter) {
        this.filter = http2HandlerFilter;
    }

    public String selectProtocol(SSLEngine sslEngine, String[] clientProtocols) {
        Connection connection = AlpnSupport.getConnection(sslEngine);
        if (LOGGER.isLoggable(Level.INFO)) {
            LOGGER.log(Level.INFO, "Alpn selectProtocol. Connection={0} sslEngine={1} clientProtocols={2}", new Object[]{connection, sslEngine, Arrays.toString(clientProtocols)});
        }
        for (String supportedProtocol : this.supportedProtocols) {
            for (String clientProtocol : clientProtocols) {
                if (!supportedProtocol.equals(clientProtocol)) continue;
                if (LOGGER.isLoggable(Level.INFO)) {
                    LOGGER.log(Level.INFO, "Alpn select {0}", clientProtocol);
                }
                this.configureHttp2(connection, clientProtocol);
                return clientProtocol;
            }
        }
        Http2State.create(connection).setNeverHttp2();
        return null;
    }

    private void configureHttp2(Connection connection, String supportedProtocol) {
        if ("h2".equals(supportedProtocol)) {
            Http2Connection http2Connection = this.filter.createHttp2Connection(connection, true);
            http2Connection.getHttp2State().setDirectUpgradePhase();
        }
    }
}

