/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.grizzly.http2;

import java.io.EOFException;
import java.io.IOException;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.grizzly.Buffer;
import org.glassfish.grizzly.Grizzly;
import org.glassfish.grizzly.http.HttpBrokenContent;
import org.glassfish.grizzly.http.HttpContent;
import org.glassfish.grizzly.http.HttpHeader;
import org.glassfish.grizzly.http.HttpPacket;
import org.glassfish.grizzly.http2.Constants;
import org.glassfish.grizzly.http2.Http2Connection;
import org.glassfish.grizzly.http2.Http2Stream;
import org.glassfish.grizzly.http2.StreamInputBuffer;
import org.glassfish.grizzly.memory.Buffers;
import org.glassfish.grizzly.memory.CompositeBuffer;
import org.glassfish.grizzly.memory.MemoryManager;
import org.glassfish.grizzly.utils.DataStructures;

class DefaultInputBuffer
implements StreamInputBuffer {
    private static final Logger LOGGER = Grizzly.logger(StreamInputBuffer.class);
    private static final long NULL_CONTENT_LENGTH = Long.MIN_VALUE;
    private static final AtomicIntegerFieldUpdater<DefaultInputBuffer> inputQueueSizeUpdater = AtomicIntegerFieldUpdater.newUpdater(DefaultInputBuffer.class, "inputQueueSize");
    private volatile int inputQueueSize;
    private final BlockingQueue<InputElement> inputQueue = DataStructures.getLTQInstance(InputElement.class);
    private final AtomicBoolean inputClosed = new AtomicBoolean();
    private static final AtomicReferenceFieldUpdater<DefaultInputBuffer, Http2Stream.Termination> closeFlagUpdater = AtomicReferenceFieldUpdater.newUpdater(DefaultInputBuffer.class, Http2Stream.Termination.class, "closeFlag");
    private volatile Http2Stream.Termination closeFlag;
    private final Object terminateSync = new Object();
    private final Http2Stream stream;
    private final Http2Connection http2Connection;
    private final Object expectInputSwitchSync = new Object();
    private boolean expectInputSwitch;
    private long remainingContentLength = Long.MIN_VALUE;

    DefaultInputBuffer(Http2Stream stream) {
        this.stream = stream;
        this.http2Connection = stream.getHttp2Connection();
    }

    @Override
    public void onReadEventComplete() {
        if (this.stream.isProcessingComplete || !this.stream.getInputHttpHeader().isExpectContent()) {
            return;
        }
        if (this.isClosed()) {
            this.http2Connection.sendMessageUpstream(this.stream, (HttpPacket)this.buildBrokenHttpContent(new EOFException(this.closeFlag.getDescription())));
            return;
        }
        this.switchOnExpectInput();
        int queueSize = this.switchOffExpectInputIfQueueNotEmpty();
        if (queueSize > 0) {
            this.passPayloadUpstream(null, queueSize);
        }
    }

    @Override
    public boolean offer(Buffer data, boolean isLast) {
        if (this.inputClosed.get()) {
            data.tryDispose();
            return false;
        }
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.log(Level.FINE, "{0}: offer {1} isLast={2}", new Object[]{this.stream.getId(), data, isLast});
        }
        boolean isLastData = isLast | this.checkContentLength(data.remaining());
        InputElement element = new InputElement(data, isLastData, false);
        this.offer0(element);
        if (isLastData) {
            this.inputClosed.set(true);
        }
        if (this.isClosed() && this.inputQueue.remove(element)) {
            data.tryDispose();
            return false;
        }
        return true;
    }

    private void offer0(InputElement inputElement) {
        if (this.switchOffExpectInput()) {
            this.passPayloadUpstream(inputElement, this.inputQueueSize);
        } else {
            if (!this.inputQueue.offer(inputElement)) {
                throw new IllegalStateException("New element can't be added");
            }
            inputQueueSizeUpdater.incrementAndGet(this);
            int readyBuffersCount = this.switchOffExpectInputIfQueueNotEmpty();
            if (readyBuffersCount > 0) {
                this.passPayloadUpstream(null, readyBuffersCount);
            }
        }
    }

    private void passPayloadUpstream(InputElement inputElement, int readyBuffersCount) {
        try {
            if (readyBuffersCount == -1) {
                readyBuffersCount = this.inputQueueSize;
            }
            Buffer payload = null;
            if (readyBuffersCount > 0) {
                payload = this.poll0();
                assert (payload != null);
            }
            if (inputElement != null) {
                Buffer data = inputElement.toBuffer();
                if (!inputElement.isService) {
                    payload = Buffers.appendBuffers((MemoryManager)this.http2Connection.getMemoryManager(), (Buffer)payload, (Buffer)data);
                    this.http2Connection.ackConsumedData(this.stream, DefaultInputBuffer.bufSz(data));
                } else if (payload == null) {
                    payload = data;
                }
                this.checkEOF(inputElement);
            }
            HttpContent content = this.buildHttpContent(payload);
            this.http2Connection.sendMessageUpstreamWithParseNotify(this.stream, content);
        }
        catch (IOException e) {
            LOGGER.log(Level.WARNING, "Unexpected IOException: {0}", e.getMessage());
        }
    }

    @Override
    public HttpContent poll() throws IOException {
        return this.buildHttpContent(this.poll0());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Buffer poll0() throws IOException {
        Buffer buffer;
        if (this.isClosed()) {
            return Buffers.EMPTY_BUFFER;
        }
        Object object = this.terminateSync;
        synchronized (object) {
            int inputQueueSizeNow = inputQueueSizeUpdater.getAndSet(this, 0);
            if (inputQueueSizeNow <= 0) {
                InputElement inputElement;
                try {
                    inputElement = this.inputQueue.poll(this.http2Connection.getConnection().getReadTimeout(TimeUnit.MILLISECONDS), TimeUnit.MILLISECONDS);
                }
                catch (InterruptedException e) {
                    throw new IOException("Blocking read was interrupted");
                }
                if (inputElement == null) {
                    throw new IOException("Blocking read timeout");
                }
                inputQueueSizeUpdater.addAndGet(this, inputQueueSizeNow - 1);
                this.checkEOF(inputElement);
                buffer = inputElement.toBuffer();
            } else if (inputQueueSizeNow == 1) {
                InputElement inputElement = (InputElement)this.inputQueue.poll();
                this.checkEOF(inputElement);
                buffer = inputElement.toBuffer();
            } else {
                CompositeBuffer compositeBuffer = CompositeBuffer.newBuffer((MemoryManager)this.http2Connection.getMemoryManager());
                for (int i = 0; i < inputQueueSizeNow; ++i) {
                    InputElement currentElement = (InputElement)this.inputQueue.poll();
                    this.checkEOF(currentElement);
                    if (!currentElement.isService) {
                        compositeBuffer.append(currentElement.toBuffer());
                    }
                    if (currentElement.isLast) break;
                }
                compositeBuffer.allowBufferDispose(true);
                compositeBuffer.allowInternalBuffersDispose(true);
                buffer = compositeBuffer;
            }
        }
        this.http2Connection.ackConsumedData(this.stream, DefaultInputBuffer.bufSz(buffer));
        return buffer;
    }

    @Override
    public void close(Http2Stream.Termination termination) {
        if (this.inputClosed.compareAndSet(false, true)) {
            this.offer0(new InputElement(termination, true, true));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void terminate(Http2Stream.Termination termination) {
        boolean isSet = closeFlagUpdater.compareAndSet(this, null, termination);
        if (this.inputClosed.compareAndSet(false, true)) {
            this.offer0(new InputElement(termination, true, true));
        }
        if (isSet) {
            int szToRelease = 0;
            Object object = this.terminateSync;
            synchronized (object) {
                InputElement element;
                while ((element = (InputElement)this.inputQueue.poll()) != null) {
                    if (element.isService) continue;
                    Buffer buffer = element.toBuffer();
                    szToRelease += buffer.remaining();
                    buffer.tryDispose();
                }
            }
            if (szToRelease > 0) {
                this.http2Connection.ackConsumedData(szToRelease);
            }
            this.stream.onInputClosed();
        }
    }

    @Override
    public boolean isClosed() {
        return this.closeFlag != null;
    }

    private void checkEOF(InputElement inputElement) {
        if (inputElement.isLast) {
            Http2Stream.Termination termination;
            Http2Stream.Termination termination2 = termination = !inputElement.isService ? Constants.IN_FIN_TERMINATION : (Http2Stream.Termination)inputElement.content;
            if (closeFlagUpdater.compareAndSet(this, null, termination)) {
                termination.doTask();
                this.stream.onInputClosed();
            }
        }
    }

    private boolean checkContentLength(int newDataChunkSize) {
        if (this.remainingContentLength == Long.MIN_VALUE) {
            this.remainingContentLength = this.stream.getInputHttpHeader().getContentLength();
        }
        if (this.remainingContentLength >= 0L) {
            this.remainingContentLength -= (long)newDataChunkSize;
            if (this.remainingContentLength == 0L) {
                return true;
            }
            if (this.remainingContentLength < 0L) {
                throw new IllegalStateException("Http2Stream #" + this.stream.getId() + ": peer is sending data beyound specified content-length limit");
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean switchOffExpectInput() {
        Object object = this.expectInputSwitchSync;
        synchronized (object) {
            if (this.expectInputSwitch) {
                this.expectInputSwitch = false;
                return true;
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int switchOffExpectInputIfQueueNotEmpty() {
        Object object = this.expectInputSwitchSync;
        synchronized (object) {
            int queueSize;
            if (this.expectInputSwitch && (queueSize = this.inputQueueSize) > 0) {
                this.expectInputSwitch = false;
                return queueSize;
            }
            return 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void switchOnExpectInput() {
        Object object = this.expectInputSwitchSync;
        synchronized (object) {
            this.expectInputSwitch = true;
        }
    }

    private HttpContent buildHttpContent(Buffer payload) {
        HttpContent httpContent;
        boolean isFin;
        Http2Stream.Termination localTermination = this.closeFlag;
        boolean bl = isFin = localTermination == Constants.IN_FIN_TERMINATION;
        if (payload.hasRemaining() || localTermination == null || isFin) {
            HttpHeader inputHttpHeader = this.stream.getInputHttpHeader();
            inputHttpHeader.setExpectContent(!isFin);
            httpContent = HttpContent.builder((HttpHeader)inputHttpHeader).content(payload).last(isFin).build();
        } else {
            httpContent = this.buildBrokenHttpContent(new EOFException(localTermination.getDescription()));
        }
        return httpContent;
    }

    private HttpContent buildBrokenHttpContent(Throwable t) {
        this.stream.getInputHttpHeader().setExpectContent(false);
        return HttpBrokenContent.builder((HttpHeader)this.stream.getInputHttpHeader()).error(t).build();
    }

    private static int bufSz(Buffer buffer) {
        return buffer != null ? buffer.remaining() : 0;
    }

    private static final class InputElement {
        private final Object content;
        private final boolean isLast;
        private final boolean isService;

        public InputElement(Object content, boolean isLast, boolean isService) {
            this.content = content;
            this.isLast = isLast;
            this.isService = isService;
        }

        private Buffer toBuffer() {
            return !this.isService ? (Buffer)this.content : Buffers.EMPTY_BUFFER;
        }
    }
}

