/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.grizzly.http2;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.net.ssl.SSLEngine;
import org.glassfish.grizzly.Buffer;
import org.glassfish.grizzly.Closeable;
import org.glassfish.grizzly.CompletionHandler;
import org.glassfish.grizzly.Connection;
import org.glassfish.grizzly.Grizzly;
import org.glassfish.grizzly.OutputSink;
import org.glassfish.grizzly.WriteResult;
import org.glassfish.grizzly.asyncqueue.MessageCloner;
import org.glassfish.grizzly.attributes.Attribute;
import org.glassfish.grizzly.attributes.AttributeBuilder;
import org.glassfish.grizzly.attributes.AttributeStorage;
import org.glassfish.grizzly.filterchain.FilterChainContext;
import org.glassfish.grizzly.filterchain.FilterChainEvent;
import org.glassfish.grizzly.filterchain.NextAction;
import org.glassfish.grizzly.http.HttpBrokenContentException;
import org.glassfish.grizzly.http.HttpContent;
import org.glassfish.grizzly.http.HttpContext;
import org.glassfish.grizzly.http.HttpEvents;
import org.glassfish.grizzly.http.HttpHeader;
import org.glassfish.grizzly.http.HttpPacket;
import org.glassfish.grizzly.http.HttpRequestPacket;
import org.glassfish.grizzly.http.HttpResponsePacket;
import org.glassfish.grizzly.http.Method;
import org.glassfish.grizzly.http.Protocol;
import org.glassfish.grizzly.http.util.DataChunk;
import org.glassfish.grizzly.http.util.FastHttpDateFormat;
import org.glassfish.grizzly.http.util.Header;
import org.glassfish.grizzly.http.util.HttpStatus;
import org.glassfish.grizzly.http.util.MimeHeaders;
import org.glassfish.grizzly.http2.Constants;
import org.glassfish.grizzly.http2.DecoderUtils;
import org.glassfish.grizzly.http2.Http2BaseFilter;
import org.glassfish.grizzly.http2.Http2Connection;
import org.glassfish.grizzly.http2.Http2ConnectionException;
import org.glassfish.grizzly.http2.Http2Request;
import org.glassfish.grizzly.http2.Http2State;
import org.glassfish.grizzly.http2.Http2Stream;
import org.glassfish.grizzly.http2.Http2StreamException;
import org.glassfish.grizzly.http2.Http2StreamState;
import org.glassfish.grizzly.http2.InvalidCharacterException;
import org.glassfish.grizzly.http2.PushResource;
import org.glassfish.grizzly.http2.Source;
import org.glassfish.grizzly.http2.frames.ErrorCode;
import org.glassfish.grizzly.http2.frames.HeaderBlockHead;
import org.glassfish.grizzly.http2.frames.HeadersFrame;
import org.glassfish.grizzly.http2.frames.Http2Frame;
import org.glassfish.grizzly.http2.frames.SettingsFrame;
import org.glassfish.grizzly.ssl.SSLUtils;
import org.glassfish.grizzly.utils.Pair;

public class Http2ServerFilter
extends Http2BaseFilter {
    private static final Logger LOGGER = Grizzly.logger(Http2ServerFilter.class);
    protected static final String[] CIPHER_SUITE_BLACK_LIST = new String[]{"TLS_NULL_WITH_NULL_NULL", "TLS_RSA_WITH_NULL_MD5", "TLS_RSA_WITH_NULL_SHA", "TLS_RSA_EXPORT_WITH_RC4_40_MD5", "TLS_RSA_WITH_RC4_128_MD5", "TLS_RSA_WITH_RC4_128_SHA", "TLS_RSA_EXPORT_WITH_RC2_CBC_40_MD5", "TLS_RSA_WITH_IDEA_CBC_SHA", "TLS_RSA_EXPORT_WITH_DES40_CBC_SHA", "TLS_RSA_WITH_DES_CBC_SHA", "TLS_RSA_WITH_3DES_EDE_CBC_SHA", "TLS_DH_DSS_EXPORT_WITH_DES40_CBC_SHA", "TLS_DH_DSS_WITH_DES_CBC_SHA", "TLS_DH_DSS_WITH_3DES_EDE_CBC_SHA", "TLS_DH_RSA_EXPORT_WITH_DES40_CBC_SHA", "TLS_DH_RSA_WITH_DES_CBC_SHA", "TLS_DH_RSA_WITH_3DES_EDE_CBC_SHA", "TLS_DHE_DSS_EXPORT_WITH_DES40_CBC_SHA", "TLS_DHE_DSS_WITH_DES_CBC_SHA", "TLS_DHE_DSS_WITH_3DES_EDE_CBC_SHA", "TLS_DHE_RSA_EXPORT_WITH_DES40_CBC_SHA", "TLS_DHE_RSA_WITH_DES_CBC_SHA", "TLS_DHE_RSA_WITH_3DES_EDE_CBC_SHA", "TLS_DH_anon_EXPORT_WITH_RC4_40_MD5", "TLS_DH_anon_WITH_RC4_128_MD5", "TLS_DH_anon_EXPORT_WITH_DES40_CBC_SHA", "TLS_DH_anon_WITH_DES_CBC_SHA", "TLS_DH_anon_WITH_3DES_EDE_CBC_SHA", "TLS_KRB5_WITH_DES_CBC_SHA", "TLS_KRB5_WITH_3DES_EDE_CBC_SHA", "TLS_KRB5_WITH_RC4_128_SHA", "TLS_KRB5_WITH_IDEA_CBC_SHA", "TLS_KRB5_WITH_DES_CBC_MD5", "TLS_KRB5_WITH_3DES_EDE_CBC_MD5", "TLS_KRB5_WITH_RC4_128_MD5", "TLS_KRB5_WITH_IDEA_CBC_MD5", "TLS_KRB5_EXPORT_WITH_DES_CBC_40_SHA", "TLS_KRB5_EXPORT_WITH_RC2_CBC_40_SHA", "TLS_KRB5_EXPORT_WITH_RC4_40_SHA", "TLS_KRB5_EXPORT_WITH_DES_CBC_40_MD5", "TLS_KRB5_EXPORT_WITH_RC2_CBC_40_MD5", "TLS_KRB5_EXPORT_WITH_RC4_40_MD5", "TLS_PSK_WITH_NULL_SHA", "TLS_DHE_PSK_WITH_NULL_SHA", "TLS_RSA_PSK_WITH_NULL_SHA", "TLS_RSA_WITH_AES_128_CBC_SHA", "TLS_DH_DSS_WITH_AES_128_CBC_SHA", "TLS_DH_RSA_WITH_AES_128_CBC_SHA", "TLS_DHE_DSS_WITH_AES_128_CBC_SHA", "TLS_DHE_RSA_WITH_AES_128_CBC_SHA", "TLS_DH_anon_WITH_AES_128_CBC_SHA", "TLS_RSA_WITH_AES_256_CBC_SHA", "TLS_DH_DSS_WITH_AES_256_CBC_SHA", "TLS_DH_RSA_WITH_AES_256_CBC_SHA", "TLS_DHE_DSS_WITH_AES_256_CBC_SHA", "TLS_DHE_RSA_WITH_AES_256_CBC_SHA", "TLS_DH_anon_WITH_AES_256_CBC_SHA", "TLS_RSA_WITH_NULL_SHA256", "TLS_RSA_WITH_AES_128_CBC_SHA256", "TLS_RSA_WITH_AES_256_CBC_SHA256", "TLS_DH_DSS_WITH_AES_128_CBC_SHA256", "TLS_DH_RSA_WITH_AES_128_CBC_SHA256", "TLS_DHE_DSS_WITH_AES_128_CBC_SHA256", "TLS_RSA_WITH_CAMELLIA_128_CBC_SHA", "TLS_DH_DSS_WITH_CAMELLIA_128_CBC_SHA", "TLS_DH_RSA_WITH_CAMELLIA_128_CBC_SHA", "TLS_DHE_DSS_WITH_CAMELLIA_128_CBC_SHA", "TLS_DHE_RSA_WITH_CAMELLIA_128_CBC_SHA", "TLS_DH_anon_WITH_CAMELLIA_128_CBC_SHA", "TLS_DHE_RSA_WITH_AES_128_CBC_SHA256", "TLS_DH_DSS_WITH_AES_256_CBC_SHA256", "TLS_DH_RSA_WITH_AES_256_CBC_SHA256", "TLS_DHE_DSS_WITH_AES_256_CBC_SHA256", "TLS_DHE_RSA_WITH_AES_256_CBC_SHA256", "TLS_DH_anon_WITH_AES_128_CBC_SHA256", "TLS_DH_anon_WITH_AES_256_CBC_SHA256", "TLS_RSA_WITH_CAMELLIA_256_CBC_SHA", "TLS_DH_DSS_WITH_CAMELLIA_256_CBC_SHA", "TLS_DH_RSA_WITH_CAMELLIA_256_CBC_SHA", "TLS_DHE_DSS_WITH_CAMELLIA_256_CBC_SHA", "TLS_DHE_RSA_WITH_CAMELLIA_256_CBC_SHA", "TLS_DH_anon_WITH_CAMELLIA_256_CBC_SHA", "TLS_PSK_WITH_RC4_128_SHA", "TLS_PSK_WITH_3DES_EDE_CBC_SHA", "TLS_PSK_WITH_AES_128_CBC_SHA", "TLS_PSK_WITH_AES_256_CBC_SHA", "TLS_DHE_PSK_WITH_RC4_128_SHA", "TLS_DHE_PSK_WITH_3DES_EDE_CBC_SHA", "TLS_DHE_PSK_WITH_AES_128_CBC_SHA", "TLS_DHE_PSK_WITH_AES_256_CBC_SHA", "TLS_RSA_PSK_WITH_RC4_128_SHA", "TLS_RSA_PSK_WITH_3DES_EDE_CBC_SHA", "TLS_RSA_PSK_WITH_AES_128_CBC_SHA", "TLS_RSA_PSK_WITH_AES_256_CBC_SHA", "TLS_RSA_WITH_SEED_CBC_SHA", "TLS_DH_DSS_WITH_SEED_CBC_SHA", "TLS_DH_RSA_WITH_SEED_CBC_SHA", "TLS_DHE_DSS_WITH_SEED_CBC_SHA", "TLS_DHE_RSA_WITH_SEED_CBC_SHA", "TLS_DH_anon_WITH_SEED_CBC_SHA", "TLS_RSA_WITH_AES_128_GCM_SHA256", "TLS_RSA_WITH_AES_256_GCM_SHA384", "TLS_DH_RSA_WITH_AES_128_GCM_SHA256", "TLS_DH_RSA_WITH_AES_256_GCM_SHA384", "TLS_DH_DSS_WITH_AES_128_GCM_SHA256", "TLS_DH_DSS_WITH_AES_256_GCM_SHA384", "TLS_DH_anon_WITH_AES_128_GCM_SHA256", "TLS_DH_anon_WITH_AES_256_GCM_SHA384", "TLS_PSK_WITH_AES_128_GCM_SHA256", "TLS_PSK_WITH_AES_256_GCM_SHA384", "TLS_RSA_PSK_WITH_AES_128_GCM_SHA256", "TLS_RSA_PSK_WITH_AES_256_GCM_SHA384", "TLS_PSK_WITH_AES_128_CBC_SHA256", "TLS_PSK_WITH_AES_256_CBC_SHA384", "TLS_PSK_WITH_NULL_SHA256", "TLS_PSK_WITH_NULL_SHA384", "TLS_DHE_PSK_WITH_AES_128_CBC_SHA256", "TLS_DHE_PSK_WITH_AES_256_CBC_SHA384", "TLS_DHE_PSK_WITH_NULL_SHA256", "TLS_DHE_PSK_WITH_NULL_SHA384", "TLS_RSA_PSK_WITH_AES_128_CBC_SHA256", "TLS_RSA_PSK_WITH_AES_256_CBC_SHA384", "TLS_RSA_PSK_WITH_NULL_SHA256", "TLS_RSA_PSK_WITH_NULL_SHA384", "TLS_RSA_WITH_CAMELLIA_128_CBC_SHA256", "TLS_DH_DSS_WITH_CAMELLIA_128_CBC_SHA256", "TLS_DH_RSA_WITH_CAMELLIA_128_CBC_SHA256", "TLS_DHE_DSS_WITH_CAMELLIA_128_CBC_SHA256", "TLS_DHE_RSA_WITH_CAMELLIA_128_CBC_SHA256", "TLS_DH_anon_WITH_CAMELLIA_128_CBC_SHA256", "TLS_RSA_WITH_CAMELLIA_256_CBC_SHA256", "TLS_DH_DSS_WITH_CAMELLIA_256_CBC_SHA256", "TLS_DH_RSA_WITH_CAMELLIA_256_CBC_SHA256", "TLS_DHE_DSS_WITH_CAMELLIA_256_CBC_SHA256", "TLS_DHE_RSA_WITH_CAMELLIA_256_CBC_SHA256", "TLS_DH_anon_WITH_CAMELLIA_256_CBC_SHA256", "TLS_EMPTY_RENEGOTIATION_INFO_SCSV", "TLS_ECDH_ECDSA_WITH_NULL_SHA", "TLS_ECDH_ECDSA_WITH_RC4_128_SHA", "TLS_ECDH_ECDSA_WITH_3DES_EDE_CBC_SHA", "TLS_ECDH_ECDSA_WITH_AES_128_CBC_SHA", "TLS_ECDH_ECDSA_WITH_AES_256_CBC_SHA", "TLS_ECDHE_ECDSA_WITH_NULL_SHA", "TLS_ECDHE_ECDSA_WITH_RC4_128_SHA", "TLS_ECDHE_ECDSA_WITH_3DES_EDE_CBC_SHA", "TLS_ECDHE_ECDSA_WITH_AES_128_CBC_SHA", "TLS_ECDHE_ECDSA_WITH_AES_256_CBC_SHA", "TLS_ECDH_RSA_WITH_NULL_SHA", "TLS_ECDH_RSA_WITH_RC4_128_SHA", "TLS_ECDH_RSA_WITH_3DES_EDE_CBC_SHA", "TLS_ECDH_RSA_WITH_AES_128_CBC_SHA", "TLS_ECDH_RSA_WITH_AES_256_CBC_SHA", "TLS_ECDHE_RSA_WITH_NULL_SHA", "TLS_ECDHE_RSA_WITH_RC4_128_SHA", "TLS_ECDHE_RSA_WITH_3DES_EDE_CBC_SHA", "TLS_ECDHE_RSA_WITH_AES_128_CBC_SHA", "TLS_ECDHE_RSA_WITH_AES_256_CBC_SHA", "TLS_ECDH_anon_WITH_NULL_SHA", "TLS_ECDH_anon_WITH_RC4_128_SHA", "TLS_ECDH_anon_WITH_3DES_EDE_CBC_SHA", "TLS_ECDH_anon_WITH_AES_128_CBC_SHA", "TLS_ECDH_anon_WITH_AES_256_CBC_SHA", "TLS_SRP_SHA_WITH_3DES_EDE_CBC_SHA", "TLS_SRP_SHA_RSA_WITH_3DES_EDE_CBC_SHA", "TLS_SRP_SHA_DSS_WITH_3DES_EDE_CBC_SHA", "TLS_SRP_SHA_WITH_AES_128_CBC_SHA", "TLS_SRP_SHA_RSA_WITH_AES_128_CBC_SHA", "TLS_SRP_SHA_DSS_WITH_AES_128_CBC_SHA", "TLS_SRP_SHA_WITH_AES_256_CBC_SHA", "TLS_SRP_SHA_RSA_WITH_AES_256_CBC_SHA", "TLS_SRP_SHA_DSS_WITH_AES_256_CBC_SHA", "TLS_ECDHE_ECDSA_WITH_AES_128_CBC_SHA256", "TLS_ECDHE_ECDSA_WITH_AES_256_CBC_SHA384", "TLS_ECDH_ECDSA_WITH_AES_128_CBC_SHA256", "TLS_ECDH_ECDSA_WITH_AES_256_CBC_SHA384", "TLS_ECDHE_RSA_WITH_AES_128_CBC_SHA256", "TLS_ECDHE_RSA_WITH_AES_256_CBC_SHA384", "TLS_ECDH_RSA_WITH_AES_128_CBC_SHA256", "TLS_ECDH_RSA_WITH_AES_256_CBC_SHA384", "TLS_ECDH_ECDSA_WITH_AES_128_GCM_SHA256", "TLS_ECDH_ECDSA_WITH_AES_256_GCM_SHA384", "TLS_ECDH_RSA_WITH_AES_128_GCM_SHA256", "TLS_ECDH_RSA_WITH_AES_256_GCM_SHA384", "TLS_ECDHE_PSK_WITH_RC4_128_SHA", "TLS_ECDHE_PSK_WITH_3DES_EDE_CBC_SHA", "TLS_ECDHE_PSK_WITH_AES_128_CBC_SHA", "TLS_ECDHE_PSK_WITH_AES_256_CBC_SHA", "TLS_ECDHE_PSK_WITH_AES_128_CBC_SHA256", "TLS_ECDHE_PSK_WITH_AES_256_CBC_SHA384", "TLS_ECDHE_PSK_WITH_NULL_SHA", "TLS_ECDHE_PSK_WITH_NULL_SHA256", "TLS_ECDHE_PSK_WITH_NULL_SHA384", "TLS_RSA_WITH_ARIA_128_CBC_SHA256", "TLS_RSA_WITH_ARIA_256_CBC_SHA384", "TLS_DH_DSS_WITH_ARIA_128_CBC_SHA256", "TLS_DH_DSS_WITH_ARIA_256_CBC_SHA384", "TLS_DH_RSA_WITH_ARIA_128_CBC_SHA256", "TLS_DH_RSA_WITH_ARIA_256_CBC_SHA384", "TLS_DHE_DSS_WITH_ARIA_128_CBC_SHA256", "TLS_DHE_DSS_WITH_ARIA_256_CBC_SHA384", "TLS_DHE_RSA_WITH_ARIA_128_CBC_SHA256", "TLS_DHE_RSA_WITH_ARIA_256_CBC_SHA384", "TLS_DH_anon_WITH_ARIA_128_CBC_SHA256", "TLS_DH_anon_WITH_ARIA_256_CBC_SHA384", "TLS_ECDHE_ECDSA_WITH_ARIA_128_CBC_SHA256", "TLS_ECDHE_ECDSA_WITH_ARIA_256_CBC_SHA384", "TLS_ECDH_ECDSA_WITH_ARIA_128_CBC_SHA256", "TLS_ECDH_ECDSA_WITH_ARIA_256_CBC_SHA384", "TLS_ECDHE_RSA_WITH_ARIA_128_CBC_SHA256", "TLS_ECDHE_RSA_WITH_ARIA_256_CBC_SHA384", "TLS_ECDH_RSA_WITH_ARIA_128_CBC_SHA256", "TLS_ECDH_RSA_WITH_ARIA_256_CBC_SHA384", "TLS_RSA_WITH_ARIA_128_GCM_SHA256", "TLS_RSA_WITH_ARIA_256_GCM_SHA384", "TLS_DH_RSA_WITH_ARIA_128_GCM_SHA256", "TLS_DH_RSA_WITH_ARIA_256_GCM_SHA384", "TLS_DH_DSS_WITH_ARIA_128_GCM_SHA256", "TLS_DH_DSS_WITH_ARIA_256_GCM_SHA384", "TLS_DH_anon_WITH_ARIA_128_GCM_SHA256", "TLS_DH_anon_WITH_ARIA_256_GCM_SHA384", "TLS_ECDH_ECDSA_WITH_ARIA_128_GCM_SHA256", "TLS_ECDH_ECDSA_WITH_ARIA_256_GCM_SHA384", "TLS_ECDH_RSA_WITH_ARIA_128_GCM_SHA256", "TLS_ECDH_RSA_WITH_ARIA_256_GCM_SHA384", "TLS_PSK_WITH_ARIA_128_CBC_SHA256", "TLS_PSK_WITH_ARIA_256_CBC_SHA384", "TLS_DHE_PSK_WITH_ARIA_128_CBC_SHA256", "TLS_DHE_PSK_WITH_ARIA_256_CBC_SHA384", "TLS_RSA_PSK_WITH_ARIA_128_CBC_SHA256", "TLS_RSA_PSK_WITH_ARIA_256_CBC_SHA384", "TLS_PSK_WITH_ARIA_128_GCM_SHA256", "TLS_PSK_WITH_ARIA_256_GCM_SHA384", "TLS_RSA_PSK_WITH_ARIA_128_GCM_SHA256", "TLS_RSA_PSK_WITH_ARIA_256_GCM_SHA384", "TLS_ECDHE_PSK_WITH_ARIA_128_CBC_SHA256", "TLS_ECDHE_PSK_WITH_ARIA_256_CBC_SHA384", "TLS_ECDHE_ECDSA_WITH_CAMELLIA_128_CBC_SHA256", "TLS_ECDHE_ECDSA_WITH_CAMELLIA_256_CBC_SHA384", "TLS_ECDH_ECDSA_WITH_CAMELLIA_128_CBC_SHA256", "TLS_ECDH_ECDSA_WITH_CAMELLIA_256_CBC_SHA384", "TLS_ECDHE_RSA_WITH_CAMELLIA_128_CBC_SHA256", "TLS_ECDHE_RSA_WITH_CAMELLIA_256_CBC_SHA384", "TLS_ECDH_RSA_WITH_CAMELLIA_128_CBC_SHA256", "TLS_ECDH_RSA_WITH_CAMELLIA_256_CBC_SHA384", "TLS_RSA_WITH_CAMELLIA_128_GCM_SHA256", "TLS_RSA_WITH_CAMELLIA_256_GCM_SHA384", "TLS_DH_RSA_WITH_CAMELLIA_128_GCM_SHA256", "TLS_DH_RSA_WITH_CAMELLIA_256_GCM_SHA384", "TLS_DH_DSS_WITH_CAMELLIA_128_GCM_SHA256", "TLS_DH_DSS_WITH_CAMELLIA_256_GCM_SHA384", "TLS_DH_anon_WITH_CAMELLIA_128_GCM_SHA256", "TLS_DH_anon_WITH_CAMELLIA_256_GCM_SHA384", "TLS_ECDH_ECDSA_WITH_CAMELLIA_128_GCM_SHA256", "TLS_ECDH_ECDSA_WITH_CAMELLIA_256_GCM_SHA384", "TLS_ECDH_RSA_WITH_CAMELLIA_128_GCM_SHA256", "TLS_ECDH_RSA_WITH_CAMELLIA_256_GCM_SHA384", "TLS_PSK_WITH_CAMELLIA_128_GCM_SHA256", "TLS_PSK_WITH_CAMELLIA_256_GCM_SHA384", "TLS_RSA_PSK_WITH_CAMELLIA_128_GCM_SHA256", "TLS_RSA_PSK_WITH_CAMELLIA_256_GCM_SHA384", "TLS_PSK_WITH_CAMELLIA_128_CBC_SHA256", "TLS_PSK_WITH_CAMELLIA_256_CBC_SHA384", "TLS_DHE_PSK_WITH_CAMELLIA_128_CBC_SHA256", "TLS_DHE_PSK_WITH_CAMELLIA_256_CBC_SHA384", "TLS_RSA_PSK_WITH_CAMELLIA_128_CBC_SHA256", "TLS_RSA_PSK_WITH_CAMELLIA_256_CBC_SHA384", "TLS_ECDHE_PSK_WITH_CAMELLIA_128_CBC_SHA256", "TLS_ECDHE_PSK_WITH_CAMELLIA_256_CBC_SHA384", "TLS_RSA_WITH_AES_128_CCM", "TLS_RSA_WITH_AES_256_CCM", "TLS_RSA_WITH_AES_128_CCM_8", "TLS_RSA_WITH_AES_256_CCM_8", "TLS_PSK_WITH_AES_128_CCM", "TLS_PSK_WITH_AES_256_CCM", "TLS_PSK_WITH_AES_128_CCM_8", "TLS_PSK_WITH_AES_256_CCM_8"};
    private boolean allowPayloadForUndefinedHttpMethods;
    private final Attribute<Connection> CIPHER_CHECKED = AttributeBuilder.DEFAULT_ATTRIBUTE_BUILDER.createAttribute("BLACK_LIST_CIPHER_SUITE_CHEKCED");

    public Http2ServerFilter() {
        this(null);
    }

    public Http2ServerFilter(ExecutorService threadPool) {
        super(threadPool);
    }

    public boolean isAllowPayloadForUndefinedHttpMethods() {
        return this.allowPayloadForUndefinedHttpMethods;
    }

    public void setAllowPayloadForUndefinedHttpMethods(boolean allowPayloadForUndefinedHttpMethods) {
        this.allowPayloadForUndefinedHttpMethods = allowPayloadForUndefinedHttpMethods;
    }

    public NextAction handleRead(FilterChainContext ctx) throws IOException {
        Buffer framePayload;
        if (this.checkIfHttp2StreamChain(ctx)) {
            return ctx.getInvokeAction();
        }
        Connection connection = ctx.getConnection();
        Http2State http2State = Http2State.get(connection);
        if (http2State != null && http2State.isNeverHttp2()) {
            return ctx.getInvokeAction();
        }
        HttpContent httpContent = (HttpContent)ctx.getMessage();
        HttpHeader httpHeader = httpContent.getHttpHeader();
        if (http2State == null) {
            assert (httpHeader.isRequest());
            if (httpHeader.isSecure()) {
                Http2State.create(connection).setNeverHttp2();
                return ctx.getInvokeAction();
            }
            HttpRequestPacket httpRequest = (HttpRequestPacket)httpHeader;
            if (!Method.PRI.equals(httpRequest.getMethod())) {
                boolean isLast = httpContent.isLast();
                if (this.tryHttpUpgrade(ctx, httpRequest, isLast) && isLast) {
                    this.enableOpReadNow(ctx);
                }
                return ctx.getInvokeAction();
            }
            http2State = this.doDirectUpgrade(ctx);
        }
        Http2Connection http2Connection = this.obtainHttp2Connection(http2State, ctx, true);
        if (!this.CIPHER_CHECKED.isSet((AttributeStorage)connection)) {
            this.CIPHER_CHECKED.set((AttributeStorage)connection, (Object)connection);
            SSLEngine engine = SSLUtils.getSSLEngine((Connection)connection);
            if (engine != null && Arrays.binarySearch(CIPHER_SUITE_BLACK_LIST, engine.getSession().getCipherSuite()) >= 0) {
                http2Connection.goAway(ErrorCode.INADEQUATE_SECURITY);
                ctx.getConnection().closeSilently();
                return ctx.getStopAction();
            }
        }
        if (!http2Connection.isHttp2InputEnabled()) {
            if (http2State.isHttpUpgradePhase()) {
                if (httpContent.isLast()) {
                    http2State.setDirectUpgradePhase();
                    this.enableOpReadNow(ctx);
                }
                return ctx.getInvokeAction();
            }
            HttpRequestPacket httpRequest = (HttpRequestPacket)httpHeader;
            try {
                if (!this.checkPRI(ctx, httpRequest, httpContent)) {
                    return ctx.getStopAction((Object)httpContent);
                }
            }
            catch (Exception e) {
                httpRequest.getProcessingState().setError(true);
                httpRequest.getProcessingState().setKeepAlive(false);
                HttpResponsePacket httpResponse = httpRequest.getResponse();
                httpResponse.setStatus(HttpStatus.BAD_REQUEST_400);
                ctx.write((Object)httpResponse);
                connection.closeSilently();
                return ctx.getStopAction();
            }
            Buffer payload = httpContent.getContent();
            framePayload = payload.split(payload.position() + PRI_PAYLOAD.length);
        } else {
            framePayload = httpContent.getContent();
        }
        httpContent.recycle();
        List<Http2Frame> framesList = this.frameCodec.parse(http2Connection, http2State.getFrameParsingState(), framePayload);
        if (!this.processFrames(ctx, http2Connection, framesList)) {
            return ctx.getSuspendAction();
        }
        return ctx.getStopAction();
    }

    @Override
    public NextAction handleEvent(FilterChainContext ctx, FilterChainEvent event) throws IOException {
        Object type = event.type();
        if (type == HttpEvents.IncomingHttpUpgradeEvent.TYPE) {
            HttpHeader header = ((HttpEvents.IncomingHttpUpgradeEvent)event).getHttpHeader();
            if (header.isRequest() && this.checkRequestHeadersOnUpgrade((HttpRequestPacket)header)) {
                header.setIgnoreContentModifiers(false);
                return ctx.getStopAction();
            }
            return ctx.getInvokeAction();
        }
        Http2State state = Http2State.get(ctx.getConnection());
        if (state == null || state.isNeverHttp2()) {
            return ctx.getInvokeAction();
        }
        if (type == HttpEvents.ResponseCompleteEvent.TYPE) {
            HttpContext httpContext = HttpContext.get((FilterChainContext)ctx);
            Http2Stream stream = (Http2Stream)httpContext.getContextStorage();
            stream.onProcessingComplete();
            Http2Connection http2Connection = stream.getHttp2Connection();
            if (!http2Connection.isHttp2InputEnabled()) {
                state.finishHttpUpgradePhase();
                return ctx.getInvokeAction();
            }
            return ctx.getStopAction();
        }
        return super.handleEvent(ctx, event);
    }

    @Override
    protected void onPrefaceReceived(Http2Connection http2Connection) {
        http2Connection.sendPreface();
    }

    private Http2State doDirectUpgrade(FilterChainContext ctx) {
        Connection connection = ctx.getConnection();
        Http2Connection http2Connection = new Http2Connection(connection, true, this);
        Http2State http2State = Http2State.create(connection);
        http2State.setHttp2Connection(http2Connection);
        http2State.setDirectUpgradePhase();
        http2Connection.setupFilterChains(ctx, true);
        http2Connection.sendPreface();
        return http2State;
    }

    private boolean tryHttpUpgrade(FilterChainContext ctx, HttpRequestPacket httpRequest, boolean isLast) throws Http2StreamException {
        if (!this.checkHttpMethodOnUpgrade(httpRequest)) {
            return false;
        }
        if (!this.checkRequestHeadersOnUpgrade(httpRequest)) {
            return false;
        }
        boolean http2Upgrade = this.isHttp2UpgradingVersion((HttpHeader)httpRequest);
        if (!http2Upgrade) {
            return false;
        }
        SettingsFrame settingsFrame = this.getHttp2UpgradeSettings(httpRequest);
        if (settingsFrame == null) {
            return false;
        }
        Connection connection = ctx.getConnection();
        Http2Connection http2Connection = new Http2Connection(connection, true, this);
        Http2State http2State = Http2State.create(connection);
        http2State.setHttp2Connection(http2Connection);
        if (isLast) {
            http2State.setDirectUpgradePhase();
        }
        try {
            this.applySettings(http2Connection, settingsFrame);
        }
        catch (Http2ConnectionException e) {
            Http2State.remove(connection);
            return false;
        }
        HttpResponsePacket httpResponse = httpRequest.getResponse();
        httpResponse.setStatus(HttpStatus.SWITCHING_PROTOCOLS_101);
        httpResponse.setHeader(Header.Connection, "Upgrade");
        httpResponse.setHeader(Header.Upgrade, "h2c");
        httpResponse.setIgnoreContentModifiers(true);
        ctx.write((Object)httpResponse);
        httpResponse.setCommitted(false);
        http2Connection.setupFilterChains(ctx, true);
        http2Connection.sendPreface();
        httpResponse.setStatus(HttpStatus.OK_200);
        httpResponse.getHeaders().clear();
        httpRequest.setProtocol(Protocol.HTTP_2_0);
        httpResponse.setProtocol(Protocol.HTTP_2_0);
        httpRequest.getUpgradeDC().recycle();
        httpResponse.getProcessingState().setKeepAlive(true);
        Http2Stream stream = http2Connection.acceptUpgradeStream(httpRequest, 0, !httpRequest.isExpectContent());
        HttpContext httpContext = HttpContext.newInstance((AttributeStorage)stream, (OutputSink)stream, (Closeable)stream, (HttpRequestPacket)httpRequest);
        httpRequest.getProcessingState().setHttpContext(httpContext);
        httpRequest.setAttribute(Http2Stream.HTTP2_STREAM_ATTRIBUTE, (Object)stream);
        httpContext.attach(ctx);
        return true;
    }

    private boolean checkHttpMethodOnUpgrade(HttpRequestPacket httpRequest) {
        return httpRequest.getMethod() != Method.CONNECT;
    }

    private boolean checkPRI(FilterChainContext ctx, HttpRequestPacket httpRequest, HttpContent httpContent) {
        if (!Method.PRI.equals(httpRequest.getMethod())) {
            throw new HttpBrokenContentException();
        }
        Buffer payload = httpContent.getContent();
        if (payload.remaining() < PRI_PAYLOAD.length) {
            return false;
        }
        int pos = payload.position();
        for (int i = 0; i < PRI_PAYLOAD.length; ++i) {
            if (payload.get(pos + i) == PRI_PAYLOAD[i]) continue;
            throw new HttpBrokenContentException();
        }
        return true;
    }

    @Override
    protected void processCompleteHeader(Http2Connection http2Connection, FilterChainContext context, HeaderBlockHead firstHeaderFrame) throws IOException {
        this.processInRequest(http2Connection, context, (HeadersFrame)firstHeaderFrame);
    }

    private void processInRequest(Http2Connection http2Connection, FilterChainContext context, HeadersFrame headersFrame) throws IOException {
        boolean isExpectContent;
        Http2Request request = Http2Request.create();
        request.setConnection(context.getConnection());
        Http2Stream stream = http2Connection.acceptStream(request, headersFrame.getStreamId(), 0, 0, Http2StreamState.IDLE);
        if (stream == null) {
            request.recycle();
            return;
        }
        try {
            DecoderUtils.decodeRequestHeaders(http2Connection, request);
        }
        catch (IOException ioe) {
            if (ioe instanceof InvalidCharacterException) {
                if (LOGGER.isLoggable(Level.WARNING)) {
                    LOGGER.warning(ioe.getMessage());
                }
                if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.log(Level.FINE, ioe.getMessage(), ioe);
                }
                http2Connection.sendRstFrame(ErrorCode.PROTOCOL_ERROR, stream.getId());
                return;
            }
            throw ioe;
        }
        this.onHttpHeadersParsed((HttpHeader)request, context);
        this.prepareIncomingRequest(stream, request);
        boolean isEOS = headersFrame.isEndStream();
        stream.onRcvHeaders(isEOS);
        if (isEOS) {
            request.setExpectContent(false);
        }
        if (!(isExpectContent = request.isExpectContent())) {
            stream.inputBuffer.terminate(Constants.IN_FIN_TERMINATION);
        }
        this.sendUpstream(http2Connection, stream, (HttpHeader)request, isExpectContent);
    }

    @Override
    protected void processOutgoingHttpHeader(FilterChainContext ctx, Http2Connection http2Connection, HttpHeader httpHeader, HttpPacket entireHttpPacket) throws IOException {
        HttpResponsePacket response = (HttpResponsePacket)httpHeader;
        Http2Stream stream = Http2Stream.getStreamFor((HttpHeader)response);
        assert (stream != null);
        if (!response.isCommitted()) {
            this.prepareOutgoingResponse(response);
            this.pushAssociatedResoureses(ctx, stream);
        }
        FilterChainContext.TransportContext transportContext = ctx.getTransportContext();
        stream.getOutputSink().writeDownStream(entireHttpPacket, ctx, (CompletionHandler<WriteResult>)transportContext.getCompletionHandler(), (MessageCloner<Buffer>)transportContext.getMessageCloner());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void pushAssociatedResoureses(FilterChainContext ctx, Http2Stream stream) throws IOException {
        Map<String, PushResource> pushResourceMap = stream.getAssociatedResourcesToPush();
        if (pushResourceMap != null) {
            int streamId = stream.getId();
            HttpRequestPacket streamReq = stream.getRequest();
            String referer = this.composeRefererOf(stream.getRequest());
            ArrayList<Pair> pushStreams = new ArrayList<Pair>(pushResourceMap.size());
            Http2Connection http2Connection = stream.getHttp2Connection();
            boolean isNewClientStreamLocked = true;
            boolean isDeflaterLocked = true;
            http2Connection.getNewClientStreamLock().lock();
            try {
                Http2Stream pushStream;
                for (Map.Entry<String, PushResource> entry : pushResourceMap.entrySet()) {
                    Map<String, String> extraHeaders;
                    String userAgent;
                    PushResource pushResource = entry.getValue();
                    Source source = pushResource.getSource();
                    Http2Request request = Http2Request.create();
                    HttpResponsePacket response = request.getResponse();
                    request.setRequestURI(entry.getKey());
                    request.setProtocol(Protocol.HTTP_2_0);
                    request.setMethod(Method.GET);
                    MimeHeaders reqHeaders = request.getHeaders();
                    DataChunk valueDC = reqHeaders.setValue(Header.Host);
                    if (valueDC.isNull()) {
                        valueDC.setString(streamReq.getHeader(Header.Host));
                    }
                    if ((userAgent = streamReq.getHeader(Header.UserAgent)) != null && (valueDC = reqHeaders.setValue(Header.UserAgent)).isNull()) {
                        valueDC.setString(userAgent);
                    }
                    if ((valueDC = reqHeaders.setValue(Header.Referer)).isNull()) {
                        valueDC.setString(referer);
                    }
                    for (String cookie : streamReq.getHeaders().values(Header.Cookie)) {
                        request.addHeader(Header.Cookie, cookie);
                    }
                    request.setSecure(streamReq.isSecure());
                    request.setExpectContent(false);
                    response.setStatus(pushResource.getStatusCode());
                    response.setProtocol(Protocol.HTTP_2_0);
                    response.setContentType(pushResource.getContentType());
                    if (source != null) {
                        response.setContentLengthLong(source.remaining());
                    }
                    if ((extraHeaders = pushResource.getHeaders()) != null) {
                        for (Map.Entry<String, String> headerEntry : extraHeaders.entrySet()) {
                            response.addHeader(headerEntry.getKey(), headerEntry.getValue());
                        }
                    }
                    this.prepareOutgoingRequest(request);
                    this.prepareOutgoingResponse(response);
                    try {
                        Http2Stream pushStream2 = http2Connection.openStream(request, http2Connection.getNextLocalStreamId(), streamId, pushResource.getPriority(), Http2StreamState.RESERVED_LOCAL);
                        pushStream2.inputBuffer.terminate(Constants.IN_FIN_TERMINATION);
                        pushStreams.add(new Pair((Object)pushStream2, (Object)source));
                    }
                    catch (Exception e) {
                        LOGGER.log(Level.FINE, "Can not push: " + entry.getKey(), e);
                    }
                }
                http2Connection.getDeflaterLock().lock();
                http2Connection.getNewClientStreamLock().unlock();
                isDeflaterLocked = true;
                isNewClientStreamLocked = false;
                List<Http2Frame> pushPromiseFrames = null;
                for (Pair pair : pushStreams) {
                    pushStream = (Http2Stream)pair.getFirst();
                    pushPromiseFrames = http2Connection.encodeHttpRequestAsPushPromiseFrames(ctx, pushStream.getRequest(), streamId, pushStream.getId(), pushPromiseFrames);
                }
                http2Connection.getOutputSink().writeDownStream(pushPromiseFrames);
                http2Connection.getDeflaterLock().unlock();
                isDeflaterLocked = false;
                for (Pair pair : pushStreams) {
                    pushStream = (Http2Stream)pair.getFirst();
                    pushStream.getOutputSink().writeDownStream((Source)pair.getSecond(), ctx);
                }
            }
            finally {
                if (isDeflaterLocked) {
                    http2Connection.getDeflaterLock().unlock();
                }
                if (isNewClientStreamLocked) {
                    http2Connection.getNewClientStreamLock().unlock();
                }
            }
        }
    }

    private void prepareOutgoingResponse(HttpResponsePacket response) {
        response.setProtocol(Protocol.HTTP_2_0);
        String contentType = response.getContentType();
        if (contentType != null) {
            response.getHeaders().setValue(Header.ContentType).setString(contentType);
        }
        if (response.getContentLength() != -1L) {
            FIXED_LENGTH_ENCODING.prepareSerialize(null, (HttpHeader)response, null);
        }
        if (!response.containsHeader(Header.Date)) {
            response.getHeaders().addValue(Header.Date).setBytes(FastHttpDateFormat.getCurrentDateBytes());
        }
    }

    private String composeRefererOf(HttpRequestPacket request) {
        return (request.isSecure() ? "https" : "http") + "://" + request.getHeader(Header.Host) + request.getRequestURI();
    }

    private void enableOpReadNow(FilterChainContext ctx) {
        FilterChainContext newContext = ctx.copy();
        ctx.getInternalContext().removeAllLifeCycleListeners();
        newContext.resume(newContext.getStopAction());
    }

    static {
        Arrays.sort(CIPHER_SUITE_BLACK_LIST);
    }
}

