/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.grizzly.http2;

import java.util.HashMap;
import java.util.Map;
import org.glassfish.grizzly.http.util.Header;
import org.glassfish.grizzly.http.util.HttpStatus;
import org.glassfish.grizzly.http2.Source;

public final class PushResource {
    private Source resource;
    private int priority;
    private HttpStatus statusCode = HttpStatus.OK_200;
    private String contentType;
    private Map<String, String> headers;

    public static PushResourceBuilder builder() {
        return new PushResourceBuilder();
    }

    private PushResource() {
    }

    public Source getSource() {
        return this.resource;
    }

    public int getPriority() {
        return this.priority;
    }

    public HttpStatus getStatusCode() {
        return this.statusCode;
    }

    public String getContentType() {
        return this.contentType;
    }

    public Map<String, String> getHeaders() {
        return this.headers;
    }

    public static class PushResourceBuilder {
        private final PushResource pushResource = new PushResource();

        public PushResourceBuilder source(Source source) {
            this.pushResource.resource = source;
            return this;
        }

        public PushResourceBuilder priority(int priority) {
            this.pushResource.priority = priority;
            return this;
        }

        public PushResourceBuilder statusCode(HttpStatus statusCode) {
            this.pushResource.statusCode = statusCode;
            return this;
        }

        public PushResourceBuilder statusCode(int statusCode) {
            this.pushResource.statusCode = HttpStatus.getHttpStatus((int)statusCode);
            return this;
        }

        public PushResourceBuilder statusCode(int statusCode, String reasonPhrase) {
            this.pushResource.statusCode = HttpStatus.newHttpStatus((int)statusCode, (String)reasonPhrase);
            return this;
        }

        public PushResourceBuilder contentType(String contentType) {
            this.pushResource.contentType = contentType;
            return this;
        }

        public PushResourceBuilder header(String name, String value) {
            if (this.pushResource.headers == null) {
                this.pushResource.headers = new HashMap(4);
            }
            this.pushResource.headers.put(name, value);
            return this;
        }

        public PushResourceBuilder header(Header name, String value) {
            if (this.pushResource.headers == null) {
                this.pushResource.headers = new HashMap(4);
            }
            this.pushResource.headers.put(name.toString(), value);
            return this;
        }

        public PushResource build() {
            return this.pushResource;
        }
    }
}

