/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.grizzly.http2.frames;

import org.glassfish.grizzly.Buffer;
import org.glassfish.grizzly.ThreadCache;
import org.glassfish.grizzly.http2.Http2Connection;
import org.glassfish.grizzly.http2.frames.HeaderBlockFragment;
import org.glassfish.grizzly.memory.CompositeBuffer;
import org.glassfish.grizzly.memory.MemoryManager;

public class ContinuationFrame
extends HeaderBlockFragment {
    private static final ThreadCache.CachedTypeIndex<ContinuationFrame> CACHE_IDX = ThreadCache.obtainIndex(ContinuationFrame.class, (int)8);
    public static final int TYPE = 9;

    private ContinuationFrame() {
    }

    public static ContinuationFrame fromBuffer(int length, int flags, int streamId, Buffer buffer) {
        ContinuationFrame frame = ContinuationFrame.create();
        frame.setFlags(flags);
        frame.setStreamId(streamId);
        frame.compressedHeaders = buffer.split(buffer.position());
        frame.setFrameBuffer(buffer);
        return frame;
    }

    static ContinuationFrame create() {
        ContinuationFrame frame = (ContinuationFrame)ThreadCache.takeFromCache(CACHE_IDX);
        if (frame == null) {
            frame = new ContinuationFrame();
        }
        return frame;
    }

    public static ContinuationFrameBuilder builder() {
        return new ContinuationFrameBuilder();
    }

    @Override
    public void recycle() {
        if (DONT_RECYCLE) {
            return;
        }
        super.recycle();
        ThreadCache.putToCache(CACHE_IDX, (Object)this);
    }

    @Override
    public int getType() {
        return 9;
    }

    @Override
    public Buffer toBuffer(Http2Connection http2Connection) {
        MemoryManager memoryManager = http2Connection.getMemoryManager();
        Buffer buffer = memoryManager.allocate(http2Connection.getFrameHeaderSize());
        http2Connection.serializeHttp2FrameHeader(this, buffer);
        buffer.trim();
        CompositeBuffer cb = CompositeBuffer.newBuffer((MemoryManager)memoryManager, (Buffer[])new Buffer[]{buffer, this.compressedHeaders});
        cb.allowBufferDispose(true);
        cb.allowInternalBuffersDispose(true);
        return cb;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("ContinuationFrame {").append(this.headerToString()).append(", compressedHeaders=").append(this.compressedHeaders).append('}');
        return sb.toString();
    }

    @Override
    protected int calcLength() {
        return this.compressedHeaders.remaining();
    }

    public static class ContinuationFrameBuilder
    extends HeaderBlockFragment.HeaderBlockFragmentBuilder<ContinuationFrameBuilder> {
        protected ContinuationFrameBuilder() {
        }

        @Override
        public ContinuationFrame build() {
            ContinuationFrame frame = ContinuationFrame.create();
            this.setHeaderValuesTo(frame);
            frame.compressedHeaders = this.compressedHeaders;
            return frame;
        }

        @Override
        protected ContinuationFrameBuilder getThis() {
            return this;
        }
    }
}

