/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.grizzly.http2.frames;

import java.util.HashMap;
import java.util.Map;
import org.glassfish.grizzly.Buffer;
import org.glassfish.grizzly.ThreadCache;
import org.glassfish.grizzly.http2.Http2Connection;
import org.glassfish.grizzly.http2.frames.Http2Frame;
import org.glassfish.grizzly.memory.CompositeBuffer;
import org.glassfish.grizzly.memory.MemoryManager;

public class DataFrame
extends Http2Frame {
    private static final ThreadCache.CachedTypeIndex<DataFrame> CACHE_IDX = ThreadCache.obtainIndex(DataFrame.class, (int)8);
    public static final int TYPE = 0;
    public static final byte END_STREAM = 1;
    public static final byte PADDED = 8;
    static final Map<Integer, String> FLAG_NAMES_MAP = new HashMap<Integer, String>(4);
    private Buffer data;
    private int padLength;

    private DataFrame() {
    }

    static DataFrame create() {
        DataFrame frame = (DataFrame)ThreadCache.takeFromCache(CACHE_IDX);
        if (frame == null) {
            frame = new DataFrame();
        }
        return frame;
    }

    public static DataFrame fromBuffer(int length, int flags, int streamId, Buffer buffer) {
        DataFrame frame = DataFrame.create();
        frame.setFlags(flags);
        frame.setStreamId(streamId);
        if (frame.isFlagSet(8)) {
            frame.padLength = buffer.get() & 0xFF;
        }
        frame.data = buffer.split(buffer.position());
        frame.setFrameBuffer(buffer);
        frame.onPayloadUpdated();
        return frame;
    }

    public static DataFrameBuilder builder() {
        return new DataFrameBuilder();
    }

    public DataFrame normalize() {
        if (this.isPadded()) {
            this.clearFlag(8);
            this.data.limit(this.data.limit() - this.padLength);
            this.padLength = 0;
            this.onPayloadUpdated();
        }
        return this;
    }

    public Buffer getData() {
        return this.data;
    }

    public boolean isEndStream() {
        return this.isFlagSet(1);
    }

    public boolean isPadded() {
        return this.isFlagSet(8);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("DataFrame {").append(this.headerToString()).append(", data=").append(this.data).append('}');
        return sb.toString();
    }

    @Override
    protected int calcLength() {
        return this.data.remaining() + (this.isPadded() ? 1 : 0);
    }

    @Override
    public void recycle() {
        if (DONT_RECYCLE) {
            return;
        }
        this.padLength = 0;
        this.data = null;
        super.recycle();
        ThreadCache.putToCache(CACHE_IDX, (Object)this);
    }

    @Override
    public int getType() {
        return 0;
    }

    @Override
    public Buffer toBuffer(Http2Connection http2Connection) {
        MemoryManager memoryManager = http2Connection.getMemoryManager();
        boolean isPadded = this.isFlagSet(8);
        int extraHeaderLen = isPadded ? 1 : 0;
        Buffer buffer = memoryManager.allocate(http2Connection.getFrameHeaderSize() + extraHeaderLen);
        http2Connection.serializeHttp2FrameHeader(this, buffer);
        if (isPadded) {
            buffer.put((byte)(this.padLength & 0xFF));
        }
        buffer.trim();
        CompositeBuffer cb = CompositeBuffer.newBuffer((MemoryManager)memoryManager, (Buffer[])new Buffer[]{buffer, this.data});
        cb.allowBufferDispose(true);
        cb.allowInternalBuffersDispose(true);
        return cb;
    }

    @Override
    protected Map<Integer, String> getFlagNamesMap() {
        return FLAG_NAMES_MAP;
    }

    static {
        FLAG_NAMES_MAP.put(1, "END_STREAM");
        FLAG_NAMES_MAP.put(8, "PADDED");
    }

    public static class DataFrameBuilder
    extends Http2Frame.Http2FrameBuilder<DataFrameBuilder> {
        private Buffer data;
        private int padLength;

        protected DataFrameBuilder() {
        }

        public DataFrameBuilder data(Buffer data) {
            this.data = data;
            return this;
        }

        public DataFrameBuilder endStream(boolean endStream) {
            if (endStream) {
                this.setFlag(1);
            }
            return this;
        }

        public DataFrameBuilder padded(boolean isPadded) {
            if (isPadded) {
                this.setFlag(8);
            }
            return this;
        }

        public void padLength(int padLength) {
            this.padLength = padLength;
        }

        @Override
        public DataFrame build() {
            DataFrame frame = DataFrame.create();
            this.setHeaderValuesTo(frame);
            frame.data = this.data;
            frame.padLength = this.padLength;
            return frame;
        }

        @Override
        protected DataFrameBuilder getThis() {
            return this;
        }
    }
}

