/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.grizzly.http2.frames;

import java.util.Collections;
import java.util.Map;
import org.glassfish.grizzly.Buffer;
import org.glassfish.grizzly.ThreadCache;
import org.glassfish.grizzly.http2.Http2Connection;
import org.glassfish.grizzly.http2.frames.Http2Frame;

public class PriorityFrame
extends Http2Frame {
    private static final ThreadCache.CachedTypeIndex<PriorityFrame> CACHE_IDX = ThreadCache.obtainIndex(PriorityFrame.class, (int)8);
    public static final int TYPE = 2;
    private boolean isExclusive;
    private int streamDependency;
    private int weight;

    private PriorityFrame() {
    }

    static PriorityFrame create() {
        PriorityFrame frame = (PriorityFrame)ThreadCache.takeFromCache(CACHE_IDX);
        if (frame == null) {
            frame = new PriorityFrame();
        }
        return frame;
    }

    public static Http2Frame fromBuffer(int streamId, Buffer frameBuffer) {
        PriorityFrame frame = PriorityFrame.create();
        frame.setStreamId(streamId);
        int int4 = frameBuffer.getInt();
        frame.isExclusive = int4 < 0;
        frame.streamDependency = int4 & Integer.MAX_VALUE;
        frame.weight = frameBuffer.get() & 0xFF;
        frame.setFrameBuffer(frameBuffer);
        return frame;
    }

    public static PriorityFrameBuilder builder() {
        return new PriorityFrameBuilder();
    }

    public int getStreamDependency() {
        return this.streamDependency;
    }

    public int getWeight() {
        return this.weight;
    }

    public boolean isExclusive() {
        return this.isExclusive;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("PriorityFrame {").append(this.headerToString()).append(", exclusive=").append(this.isExclusive).append(", streamDependency=").append(this.streamDependency).append(", weight=").append(this.weight).append('}');
        return sb.toString();
    }

    @Override
    public int getType() {
        return 2;
    }

    @Override
    public Buffer toBuffer(Http2Connection http2Connection) {
        Buffer buffer = http2Connection.getMemoryManager().allocate(http2Connection.getFrameHeaderSize() + 5);
        http2Connection.serializeHttp2FrameHeader(this, buffer);
        buffer.putInt((this.isExclusive ? Integer.MIN_VALUE : 0) | this.streamDependency & Integer.MAX_VALUE);
        buffer.put((byte)this.weight);
        buffer.trim();
        return buffer;
    }

    @Override
    protected int calcLength() {
        return 5;
    }

    @Override
    protected Map<Integer, String> getFlagNamesMap() {
        return Collections.emptyMap();
    }

    @Override
    public void recycle() {
        if (DONT_RECYCLE) {
            return;
        }
        this.streamDependency = 0;
        this.weight = 0;
        super.recycle();
        ThreadCache.putToCache(CACHE_IDX, (Object)this);
    }

    public static class PriorityFrameBuilder
    extends Http2Frame.Http2FrameBuilder<PriorityFrameBuilder> {
        private int streamDependency;
        private int weight;
        private boolean exclusive;

        protected PriorityFrameBuilder() {
        }

        public PriorityFrameBuilder streamDependency(int streamDependency) {
            this.streamDependency = streamDependency;
            return this;
        }

        public PriorityFrameBuilder weight(int weight) {
            this.weight = weight;
            return this;
        }

        public PriorityFrameBuilder exclusive(boolean exclusive) {
            this.exclusive = exclusive;
            return this;
        }

        @Override
        public PriorityFrame build() {
            PriorityFrame frame = PriorityFrame.create();
            this.setHeaderValuesTo(frame);
            frame.streamDependency = this.streamDependency;
            frame.weight = this.weight;
            frame.isExclusive = this.exclusive;
            return frame;
        }

        @Override
        protected PriorityFrameBuilder getThis() {
            return this;
        }
    }
}

