/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.grizzly.http2.frames;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.grizzly.Buffer;
import org.glassfish.grizzly.Grizzly;
import org.glassfish.grizzly.ThreadCache;
import org.glassfish.grizzly.http.util.BufferChunk;
import org.glassfish.grizzly.http.util.ByteChunk;
import org.glassfish.grizzly.http.util.DataChunk;
import org.glassfish.grizzly.http2.Http2Connection;
import org.glassfish.grizzly.http2.frames.Http2Frame;

public class SettingsFrame
extends Http2Frame {
    private static final Logger LOGGER = Grizzly.logger(SettingsFrame.class);
    private static final char[] CA = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789-_".toCharArray();
    private static final int[] IA = new int[256];
    private static final ThreadCache.CachedTypeIndex<SettingsFrame> CACHE_IDX;
    private static final String[] OPTION_TEXT;
    public static final int TYPE = 4;
    public static final byte ACK_FLAG = 1;
    static final Map<Integer, String> FLAG_NAMES_MAP;
    public static final int MAX_DEFINED_SETTINGS = 6;
    public static final int SETTINGS_HEADER_TABLE_SIZE = 1;
    public static final int SETTINGS_ENABLE_PUSH = 2;
    public static final int SETTINGS_MAX_CONCURRENT_STREAMS = 3;
    public static final int SETTINGS_INITIAL_WINDOW_SIZE = 4;
    public static final int SETTINGS_MAX_FRAME_SIZE = 5;
    public static final int SETTINGS_MAX_HEADER_LIST_SIZE = 6;
    private int numberOfSettings;
    private final Setting[] settings = new Setting[6];

    private SettingsFrame() {
        for (int i = 0; i < 6; ++i) {
            this.settings[i] = new Setting();
        }
    }

    static SettingsFrame create() {
        SettingsFrame frame = (SettingsFrame)ThreadCache.takeFromCache(CACHE_IDX);
        if (frame == null) {
            frame = new SettingsFrame();
        }
        return frame;
    }

    public static SettingsFrame fromBuffer(int length, int flags, Buffer frameBuffer) {
        SettingsFrame frame = SettingsFrame.create();
        frame.setFlags(flags);
        frame.setFrameBuffer(frameBuffer);
        while (frameBuffer.hasRemaining()) {
            frame.addSetting(frameBuffer.getShort(), frameBuffer.getInt());
        }
        return frame;
    }

    @Override
    public int getType() {
        return 4;
    }

    public static SettingsFrame fromBase64Uri(DataChunk src) {
        if (src.getType() == DataChunk.Type.Bytes) {
            ByteChunk bc = src.getByteChunk();
            return SettingsFrame.parseBase64Uri(bc.getBuffer(), bc.getStart(), bc.getEnd());
        }
        if (src.getType() == DataChunk.Type.Buffer) {
            BufferChunk bc = src.getBufferChunk();
            return SettingsFrame.parseBase64Uri(bc.getBuffer(), bc.getStart(), bc.getEnd());
        }
        return SettingsFrame.parseBase64Uri(src.toString());
    }

    private static SettingsFrame parseBase64Uri(byte[] bytes, int offs, int end) {
        SettingsFrame frame = new SettingsFrame();
        while (offs < end) {
            frame.addBase64UriSetting(IA[bytes[offs++]], IA[bytes[offs++]], IA[bytes[offs++]], IA[bytes[offs++]], IA[bytes[offs++]], IA[bytes[offs++]], IA[bytes[offs++]], IA[bytes[offs++]]);
        }
        return frame;
    }

    private static SettingsFrame parseBase64Uri(Buffer buffer, int offs, int end) {
        SettingsFrame frame = new SettingsFrame();
        while (offs < end) {
            frame.addBase64UriSetting(IA[buffer.get(offs++)], IA[buffer.get(offs++)], IA[buffer.get(offs++)], IA[buffer.get(offs++)], IA[buffer.get(offs++)], IA[buffer.get(offs++)], IA[buffer.get(offs++)], IA[buffer.get(offs++)]);
        }
        return frame;
    }

    private static SettingsFrame parseBase64Uri(String s) {
        SettingsFrame frame = new SettingsFrame();
        int offs = 0;
        int end = s.length();
        while (offs < end) {
            frame.addBase64UriSetting(IA[s.charAt(offs++)], IA[s.charAt(offs++)], IA[s.charAt(offs++)], IA[s.charAt(offs++)], IA[s.charAt(offs++)], IA[s.charAt(offs++)], IA[s.charAt(offs++)], IA[s.charAt(offs++)]);
        }
        return frame;
    }

    public static SettingsFrameBuilder builder() {
        return new SettingsFrameBuilder();
    }

    public boolean isAck() {
        return this.isFlagSet(1);
    }

    public int getNumberOfSettings() {
        return this.numberOfSettings;
    }

    public int getSettingValue(int settingId) {
        int idx = this.idx(settingId);
        return idx != -1 ? this.settings[idx].value : -1;
    }

    public Setting getSettingByIndex(int idx) {
        return idx >= 0 && idx < this.numberOfSettings ? this.settings[idx] : null;
    }

    public String toBase64Uri() {
        if (this.numberOfSettings == 0) {
            return "";
        }
        StringBuilder sb = new StringBuilder(this.numberOfSettings * 8);
        for (int i = 0; i < this.numberOfSettings; ++i) {
            int id = this.settings[i].id;
            int value = this.settings[i].value;
            this.threeBytesToBase64Uri(id >> 8 & 0xFF, id & 0xFF, value >>> 24, sb);
            this.threeBytesToBase64Uri(value >> 16 & 0xFF, value >> 8 & 0xFF, value & 0xFF, sb);
        }
        return sb.toString();
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("SettingsFrame {").append(this.headerToString()).append(", numberOfSettings=").append(this.numberOfSettings);
        if (this.numberOfSettings > 0) {
            sb.append(", [");
            for (int i = 0; i < this.numberOfSettings; ++i) {
                sb.append(' ');
                sb.append(OPTION_TEXT[this.settings[i].id - 1]).append('=').append(this.settings[i].value);
            }
        }
        sb.append(" ]}");
        return sb.toString();
    }

    @Override
    protected int calcLength() {
        return this.numberOfSettings * 6;
    }

    @Override
    public void recycle() {
        if (DONT_RECYCLE) {
            return;
        }
        this.numberOfSettings = 0;
        super.recycle();
        ThreadCache.putToCache(CACHE_IDX, (Object)this);
    }

    @Override
    public Buffer toBuffer(Http2Connection http2Connection) {
        Buffer buffer = http2Connection.getMemoryManager().allocate(http2Connection.getFrameHeaderSize() + this.numberOfSettings * 6);
        http2Connection.serializeHttp2FrameHeader(this, buffer);
        if (this.numberOfSettings > 0) {
            for (int i = 0; i < this.numberOfSettings; ++i) {
                Setting setting = this.settings[i];
                buffer.putShort((short)setting.id);
                buffer.putInt(setting.value);
            }
        }
        buffer.trim();
        return buffer;
    }

    @Override
    protected Map<Integer, String> getFlagNamesMap() {
        return FLAG_NAMES_MAP;
    }

    private void threeBytesToBase64Uri(int b1, int b2, int b3, StringBuilder to) {
        to.append(CA[b1 >>> 2]).append(CA[(b1 & 3) << 4 | b2 >>> 4]).append(CA[(b2 & 0xF) << 2 | b3 >>> 6]).append(CA[b3 & 0x3F]);
    }

    private void addBase64UriSetting(int b1, int b2, int b3, int b4, int b5, int b6, int b7, int b8) {
        if (b1 == -1 || b2 == -1 || b3 == -1 || b4 == -1 || b5 == -1 || b6 == -1 || b7 == -1 || b8 == -1) {
            throw new IllegalStateException("Unknown base64uri character");
        }
        int tmp1 = b1 << 18 | b2 << 12 | b3 << 6 | b4;
        int tmp2 = b5 << 18 | b6 << 12 | b7 << 6 | b8;
        int setting = tmp1 >> 8;
        int value = (tmp1 & 0xFF) << 24 | tmp2;
        this.addSetting(setting, value);
    }

    private void addSetting(int settingId, int value) {
        if (settingId > 0 && settingId <= 6) {
            int oldIdx = this.idx(settingId);
            if (oldIdx != -1) {
                --this.numberOfSettings;
                if (oldIdx < this.numberOfSettings) {
                    Setting oldSetting = this.settings[oldIdx];
                    System.arraycopy(this.settings, oldIdx + 1, this.settings, oldIdx, this.numberOfSettings - oldIdx);
                    this.settings[this.numberOfSettings] = oldSetting;
                }
            }
            Setting storedSetting = this.settings[this.numberOfSettings++];
            storedSetting.id = settingId;
            storedSetting.value = value;
        } else {
            LOGGER.log(Level.WARNING, "Setting {0} is unknown and will be ignored", settingId);
        }
    }

    private int idx(int settingId) {
        for (int i = 0; i < this.numberOfSettings; ++i) {
            if (this.settings[i].id != settingId) continue;
            return i;
        }
        return -1;
    }

    static {
        Arrays.fill(IA, -1);
        int iS = CA.length;
        for (int i = 0; i < iS; ++i) {
            SettingsFrame.IA[SettingsFrame.CA[i]] = i;
        }
        CACHE_IDX = ThreadCache.obtainIndex(SettingsFrame.class, (int)8);
        OPTION_TEXT = new String[]{"HEADER_TABLE_SIZE", "ENABLE_PUSH", "MAX_CONCURRENT_STREAMS", "INITIAL_WINDOW_SIZE", "MAX_FRAME_SIZE", "MAX_HEADER_LIST_SIZE"};
        FLAG_NAMES_MAP = new HashMap<Integer, String>(2);
        FLAG_NAMES_MAP.put(1, "ACK");
    }

    public static final class Setting {
        private int id;
        private int value;

        private Setting() {
        }

        private Setting(int settingId, int value) {
            this.id = settingId;
            this.value = value;
        }

        public int getId() {
            return this.id;
        }

        public int getValue() {
            return this.value;
        }
    }

    public static class SettingsFrameBuilder
    extends Http2Frame.Http2FrameBuilder<SettingsFrameBuilder> {
        private int numberOfSettings;
        private final Setting[] settings = new Setting[6];

        protected SettingsFrameBuilder() {
        }

        public SettingsFrameBuilder setting(int settingId, int value) {
            if (settingId > 0 && settingId <= 6) {
                Setting settingContainer;
                int oldIdx = this.idx(settingId);
                if (oldIdx != -1) {
                    --this.numberOfSettings;
                    if (oldIdx < this.numberOfSettings) {
                        Setting oldSetting = this.settings[oldIdx];
                        System.arraycopy(this.settings, oldIdx + 1, this.settings, oldIdx, this.numberOfSettings - oldIdx);
                        this.settings[this.numberOfSettings++] = oldSetting;
                        settingContainer = oldSetting;
                    } else {
                        settingContainer = this.settings[this.numberOfSettings++];
                    }
                } else {
                    settingContainer = new Setting();
                    this.settings[this.numberOfSettings++] = settingContainer;
                }
                settingContainer.id = settingId;
                settingContainer.value = value;
            } else {
                LOGGER.log(Level.WARNING, "Setting {0} is unknown and will be ignored", settingId);
            }
            return this;
        }

        public SettingsFrameBuilder setAck() {
            this.setFlag(1);
            return this;
        }

        @Override
        public SettingsFrame build() {
            SettingsFrame frame = SettingsFrame.create();
            this.setHeaderValuesTo(frame);
            for (int i = 0; i < this.numberOfSettings; ++i) {
                frame.addSetting(this.settings[i].id, this.settings[i].value);
            }
            return frame;
        }

        private int idx(int settingId) {
            for (int i = 0; i < this.numberOfSettings; ++i) {
                if (this.settings[i].id != settingId) continue;
                return i;
            }
            return -1;
        }

        @Override
        protected SettingsFrameBuilder getThis() {
            return this;
        }
    }
}

