/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.grizzly.spdy;

import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import org.glassfish.grizzly.Buffer;
import org.glassfish.grizzly.http.HttpRequestPacket;
import org.glassfish.grizzly.http.HttpResponsePacket;
import org.glassfish.grizzly.http.util.Ascii;
import org.glassfish.grizzly.http.util.BufferChunk;
import org.glassfish.grizzly.http.util.ByteChunk;
import org.glassfish.grizzly.http.util.DataChunk;
import org.glassfish.grizzly.http.util.Header;
import org.glassfish.grizzly.http.util.HttpCodecUtils;
import org.glassfish.grizzly.http.util.HttpStatus;
import org.glassfish.grizzly.http.util.MimeHeaders;
import org.glassfish.grizzly.memory.MemoryManager;
import org.glassfish.grizzly.spdy.Constants;
import org.glassfish.grizzly.spdy.SpdyResponse;
import org.glassfish.grizzly.spdy.SpdySession;
import org.glassfish.grizzly.spdy.SpdyStream;
import org.glassfish.grizzly.spdy.compression.SpdyDeflaterOutputStream;
import org.glassfish.grizzly.utils.BufferOutputStream;
import org.glassfish.grizzly.utils.Exceptions;

class SpdyEncoderUtils {
    private static final byte[] SPACE_BYTES = new byte[]{32};
    private static final byte[] HTTPS_BYTES = "https".getBytes(org.glassfish.grizzly.http.util.Constants.DEFAULT_HTTP_CHARSET);

    SpdyEncoderUtils() {
    }

    static Buffer encodeSynReplyHeadersAndLock(SpdySession spdySession, HttpResponsePacket response) throws IOException {
        MemoryManager mm = spdySession.getMemoryManager();
        Buffer compressedBuffer = mm.allocate(2048);
        Buffer plainBuffer = mm.allocate(2048);
        MimeHeaders headers = response.getHeaders();
        headers.removeHeader(Header.Connection);
        headers.removeHeader(Header.KeepAlive);
        headers.removeHeader(Header.ProxyConnection);
        headers.removeHeader(Header.TransferEncoding);
        BufferOutputStream userHeadersBOS = new BufferOutputStream(mm);
        DataOutputStream userHeadersDOS = new DataOutputStream((OutputStream)userHeadersBOS);
        userHeadersBOS.setInitialOutputBuffer(plainBuffer);
        int userHeadersNum = SpdyEncoderUtils.encodeUserHeaders(spdySession, headers, userHeadersDOS);
        userHeadersDOS.flush();
        Buffer userHeadersBuffer = userHeadersBOS.getBuffer();
        userHeadersBOS.reset();
        userHeadersBuffer.trim();
        spdySession.getDeflaterLock().lock();
        try {
            DataOutputStream dataOutputStream = spdySession.getDeflaterDataOutputStream();
            SpdyDeflaterOutputStream deflaterOutputStream = spdySession.getDeflaterOutputStream();
            deflaterOutputStream.setInitialOutputBuffer(compressedBuffer);
            dataOutputStream.writeInt(userHeadersNum + 2);
            if (response.isCustomReasonPhraseSet()) {
                SpdyEncoderUtils.encodeHeaderValue(dataOutputStream, Constants.STATUS_HEADER_BYTES, response.getHttpStatus().getStatusBytes(), SPACE_BYTES, response.getReasonPhraseDC().toString().getBytes("ISO-8859-1"));
            } else {
                SpdyEncoderUtils.encodeHeaderValue(dataOutputStream, Constants.STATUS_HEADER_BYTES, response.getHttpStatus().getStatusBytes(), SPACE_BYTES, response.getHttpStatus().getReasonPhraseBytes());
            }
            SpdyEncoderUtils.encodeHeaderValue(dataOutputStream, Constants.VERSION_HEADER_BYTES, response.getProtocol().getProtocolBytes());
            dataOutputStream.flush();
            deflaterOutputStream.write(userHeadersBuffer);
            Buffer buffer = deflaterOutputStream.checkpoint();
            return buffer;
        }
        catch (Exception e) {
            spdySession.getDeflaterLock().unlock();
            throw Exceptions.makeIOException((Throwable)e);
        }
        finally {
            userHeadersBuffer.dispose();
        }
    }

    static Buffer encodeSynStreamHeadersAndLock(SpdyStream spdyStream, HttpRequestPacket request) throws IOException {
        int hostHeaderLen;
        int hostHeaderStart;
        byte[] hostHeaderBytes;
        int len;
        int nonSpaceIdx;
        int schemeStart = -1;
        int schemeLen = -1;
        byte[] requestURI = request.getRequestURI().getBytes("ISO-8859-1");
        int idx = ByteChunk.indexOf((byte[])requestURI, (int)(nonSpaceIdx = HttpCodecUtils.skipSpaces((byte[])requestURI, (int)0, (int)(len = requestURI.length), (int)len)), (int)len, (char)'/');
        if (idx > 0 && idx < len - 1 && requestURI[idx - 1] == 58 && requestURI[idx + 1] == 47) {
            schemeStart = nonSpaceIdx;
            schemeLen = idx - schemeStart - 1;
        }
        int pathStart = schemeStart == -1 ? idx : ByteChunk.indexOf((byte[])requestURI, (int)(idx + 2), (int)len, (char)'/');
        int pathLen = len - pathStart;
        if (pathStart == -1) {
            throw new IllegalStateException("Request URI path is not set");
        }
        MimeHeaders headers = request.getHeaders();
        String hostHeader = headers.getHeader(Header.Host);
        if (hostHeader == null) {
            if (schemeStart == -1) {
                throw new IllegalStateException("Missing the Host header");
            }
            hostHeaderBytes = requestURI;
            hostHeaderStart = schemeStart + schemeLen + 3;
            hostHeaderLen = pathStart - hostHeaderStart;
        } else {
            hostHeaderBytes = hostHeader.getBytes("ISO-8859-1");
            hostHeaderStart = 0;
            hostHeaderLen = hostHeaderBytes.length;
        }
        SpdySession spdySession = spdyStream.getSpdySession();
        MemoryManager mm = spdySession.getMemoryManager();
        Buffer compressedBuffer = mm.allocate(2048);
        Buffer plainBuffer = mm.allocate(2048);
        headers.removeHeader(Header.Connection);
        headers.removeHeader(Header.Host);
        headers.removeHeader(Header.KeepAlive);
        headers.removeHeader(Header.ProxyConnection);
        headers.removeHeader(Header.TransferEncoding);
        BufferOutputStream userHeadersBOS = new BufferOutputStream(mm);
        DataOutputStream userHeadersDOS = new DataOutputStream((OutputStream)userHeadersBOS);
        userHeadersBOS.setInitialOutputBuffer(plainBuffer);
        int userHeadersNum = SpdyEncoderUtils.encodeUserHeaders(spdySession, headers, userHeadersDOS);
        userHeadersDOS.flush();
        Buffer userHeadersBuffer = userHeadersBOS.getBuffer();
        userHeadersBOS.reset();
        userHeadersBuffer.trim();
        spdySession.getDeflaterLock().lock();
        try {
            DataOutputStream dataOutputStream = spdySession.getDeflaterDataOutputStream();
            SpdyDeflaterOutputStream deflaterOutputStream = spdySession.getDeflaterOutputStream();
            deflaterOutputStream.setInitialOutputBuffer(compressedBuffer);
            dataOutputStream.writeInt(userHeadersNum + 5);
            SpdyEncoderUtils.encodeHeaderValue(dataOutputStream, Constants.METHOD_HEADER_BYTES, request.getMethod().getMethodBytes());
            SpdyEncoderUtils.encodeHeaderValue(dataOutputStream, Constants.PATH_HEADER_BYTES, requestURI, pathStart, pathLen);
            SpdyEncoderUtils.encodeHeaderValue(dataOutputStream, Constants.VERSION_HEADER_BYTES, request.getProtocol().getProtocolBytes());
            SpdyEncoderUtils.encodeHeaderValue(dataOutputStream, Constants.HOST_HEADER_BYTES, hostHeaderBytes, hostHeaderStart, hostHeaderLen);
            if (schemeLen > 0) {
                SpdyEncoderUtils.encodeHeaderValue(dataOutputStream, Constants.SCHEMA_HEADER_BYTES, requestURI, schemeStart, schemeLen);
            } else {
                SpdyEncoderUtils.encodeHeaderValue(dataOutputStream, Constants.SCHEMA_HEADER_BYTES, HTTPS_BYTES);
            }
            dataOutputStream.flush();
            deflaterOutputStream.write(userHeadersBuffer);
            Buffer buffer = deflaterOutputStream.checkpoint();
            return buffer;
        }
        catch (Exception e) {
            spdySession.getDeflaterLock().unlock();
            throw Exceptions.makeIOException((Throwable)e);
        }
        finally {
            userHeadersBuffer.dispose();
        }
    }

    static Buffer encodeUnidirectionalSynStreamHeadersAndLock(SpdyStream spdyStream, SpdyResponse response) throws IOException {
        int hostHeaderLen;
        int hostHeaderStart;
        byte[] hostHeaderBytes;
        int len;
        int nonSpaceIdx;
        int schemeStart = -1;
        int schemeLen = -1;
        byte[] requestURI = response.getRequest().getRequestURI().getBytes("ISO-8859-1");
        int idx = ByteChunk.indexOf((byte[])requestURI, (int)(nonSpaceIdx = HttpCodecUtils.skipSpaces((byte[])requestURI, (int)0, (int)(len = requestURI.length), (int)len)), (int)len, (char)'/');
        if (idx > 0 && idx < len - 1 && requestURI[idx - 1] == 58 && requestURI[idx + 1] == 47) {
            schemeStart = nonSpaceIdx;
            schemeLen = idx - schemeStart - 1;
        }
        int pathStart = schemeStart == -1 ? idx : ByteChunk.indexOf((byte[])requestURI, (int)(idx + 2), (int)len, (char)'/');
        int pathLen = len - pathStart;
        if (pathStart == -1) {
            throw new IllegalStateException("Request URI path is not set");
        }
        MimeHeaders headers = response.getHeaders();
        String hostHeader = headers.getHeader(Header.Host);
        if (hostHeader == null) {
            if (schemeStart == -1) {
                throw new IllegalStateException("Missing the Host header");
            }
            hostHeaderBytes = requestURI;
            hostHeaderStart = schemeStart + schemeLen + 3;
            hostHeaderLen = pathStart - hostHeaderStart;
        } else {
            hostHeaderBytes = hostHeader.getBytes("ISO-8859-1");
            hostHeaderStart = 0;
            hostHeaderLen = hostHeaderBytes.length;
        }
        SpdySession spdySession = spdyStream.getSpdySession();
        MemoryManager mm = spdySession.getMemoryManager();
        Buffer compressedBuffer = mm.allocate(2048);
        Buffer plainBuffer = mm.allocate(2048);
        headers.removeHeader(Header.Connection);
        headers.removeHeader(Header.Host);
        headers.removeHeader(Header.KeepAlive);
        headers.removeHeader(Header.ProxyConnection);
        headers.removeHeader(Header.TransferEncoding);
        BufferOutputStream userHeadersBOS = new BufferOutputStream(mm);
        DataOutputStream userHeadersDOS = new DataOutputStream((OutputStream)userHeadersBOS);
        userHeadersBOS.setInitialOutputBuffer(plainBuffer);
        int userHeadersNum = SpdyEncoderUtils.encodeUserHeaders(spdySession, headers, userHeadersDOS);
        userHeadersDOS.flush();
        Buffer userHeadersBuffer = userHeadersBOS.getBuffer();
        userHeadersBOS.reset();
        userHeadersBuffer.trim();
        spdySession.getDeflaterLock().lock();
        try {
            DataOutputStream dataOutputStream = spdySession.getDeflaterDataOutputStream();
            SpdyDeflaterOutputStream deflaterOutputStream = spdySession.getDeflaterOutputStream();
            deflaterOutputStream.setInitialOutputBuffer(compressedBuffer);
            dataOutputStream.writeInt(userHeadersNum + 5);
            if (schemeLen > 0) {
                SpdyEncoderUtils.encodeHeaderValue(dataOutputStream, Constants.SCHEMA_HEADER_BYTES, requestURI, schemeStart, schemeLen);
            } else {
                SpdyEncoderUtils.encodeHeaderValue(dataOutputStream, Constants.SCHEMA_HEADER_BYTES, HTTPS_BYTES);
            }
            SpdyEncoderUtils.encodeHeaderValue(dataOutputStream, Constants.HOST_HEADER_BYTES, hostHeaderBytes, hostHeaderStart, hostHeaderLen);
            SpdyEncoderUtils.encodeHeaderValue(dataOutputStream, Constants.PATH_HEADER_BYTES, requestURI, pathStart, pathLen);
            SpdyEncoderUtils.encodeHeaderValue(dataOutputStream, Constants.VERSION_HEADER_BYTES, response.getProtocol().getProtocolBytes());
            HttpStatus httpStatus = response.getHttpStatus();
            if (response.isCustomReasonPhraseSet()) {
                SpdyEncoderUtils.encodeHeaderValue(dataOutputStream, Constants.STATUS_HEADER_BYTES, httpStatus.getStatusBytes(), SPACE_BYTES, response.getReasonPhraseRawDC().toString().getBytes("ISO-8859-1"));
            } else {
                SpdyEncoderUtils.encodeHeaderValue(dataOutputStream, Constants.STATUS_HEADER_BYTES, httpStatus.getStatusBytes(), SPACE_BYTES, httpStatus.getReasonPhraseBytes());
            }
            dataOutputStream.flush();
            deflaterOutputStream.write(userHeadersBuffer);
            Buffer buffer = deflaterOutputStream.checkpoint();
            return buffer;
        }
        catch (Exception e) {
            spdySession.getDeflaterLock().unlock();
            throw Exceptions.makeIOException((Throwable)e);
        }
        finally {
            userHeadersBuffer.dispose();
        }
    }

    private static int encodeUserHeaders(SpdySession spdySession, MimeHeaders headers, DataOutputStream dataOutputStream) throws IOException {
        int mimeHeadersCount = headers.size();
        ArrayList<DataChunk> tmpList = null;
        int headersNum = 0;
        for (int i = 0; i < mimeHeadersCount; ++i) {
            DataChunk name;
            int valueSize = 0;
            if (headers.setSerialized(i, true) || (name = headers.getName(i)).isNull() || name.getLength() == 0) continue;
            DataChunk value1 = headers.getValue(i);
            for (int j = i; j < mimeHeadersCount; ++j) {
                if (headers.isSerialized(j) || !name.equalsIgnoreCase((Object)headers.getName(j))) continue;
                headers.setSerialized(j, true);
                DataChunk value = headers.getValue(j);
                if (value.isNull()) continue;
                if (tmpList == null) {
                    tmpList = new ArrayList<DataChunk>(2);
                }
                tmpList.add(value);
                valueSize += value.getLength();
            }
            ++headersNum;
            SpdyEncoderUtils.encodeDataChunkWithLenPrefixLowerCase(dataOutputStream, headers.getName(i));
            if (tmpList != null && !tmpList.isEmpty()) {
                int extraValuesCount = tmpList.size();
                valueSize += extraValuesCount - 1;
                if (!value1.isNull()) {
                    valueSize += value1.getLength();
                    dataOutputStream.writeInt(++valueSize);
                    SpdyEncoderUtils.encodeDataChunk(dataOutputStream, value1);
                    dataOutputStream.write(0);
                } else {
                    dataOutputStream.writeInt(valueSize);
                }
                for (int j = 0; j < extraValuesCount; ++j) {
                    SpdyEncoderUtils.encodeDataChunk(dataOutputStream, (DataChunk)tmpList.get(j));
                    if (j >= extraValuesCount - 1) continue;
                    dataOutputStream.write(0);
                }
                tmpList.clear();
                continue;
            }
            SpdyEncoderUtils.encodeDataChunkWithLenPrefix(dataOutputStream, value1);
        }
        return headersNum;
    }

    private static void encodeDataChunkWithLenPrefix(DataOutputStream dataOutputStream, DataChunk dc) throws IOException {
        int len = dc.getLength();
        dataOutputStream.writeInt(len);
        SpdyEncoderUtils.encodeDataChunk(dataOutputStream, dc);
    }

    private static void encodeDataChunkWithLenPrefixLowerCase(DataOutputStream dataOutputStream, DataChunk dc) throws IOException {
        int len = dc.getLength();
        dataOutputStream.writeInt(len);
        SpdyEncoderUtils.encodeDataChunkLowerCase(dataOutputStream, dc);
    }

    private static void encodeDataChunk(DataOutputStream dataOutputStream, DataChunk dc) throws IOException {
        if (dc.isNull()) {
            return;
        }
        switch (dc.getType()) {
            case Bytes: {
                ByteChunk bc = dc.getByteChunk();
                dataOutputStream.write(bc.getBuffer(), bc.getStart(), bc.getLength());
                break;
            }
            case Buffer: {
                BufferChunk bufferChunk = dc.getBufferChunk();
                SpdyEncoderUtils.encodeDataChunk(dataOutputStream, bufferChunk.getBuffer(), bufferChunk.getStart(), bufferChunk.getLength());
                break;
            }
            default: {
                SpdyEncoderUtils.encodeDataChunk(dataOutputStream, dc.toString());
            }
        }
    }

    private static void encodeDataChunk(DataOutputStream dataOutputStream, Buffer buffer, int offs, int len) throws IOException {
        if (buffer.hasArray()) {
            dataOutputStream.write(buffer.array(), buffer.arrayOffset() + offs, len);
        } else {
            int lim = offs + len;
            for (int i = offs; i < lim; ++i) {
                dataOutputStream.write(buffer.get(i));
            }
        }
    }

    private static void encodeDataChunk(DataOutputStream dataOutputStream, String s) throws IOException {
        int len = s.length();
        for (int i = 0; i < len; ++i) {
            char c = s.charAt(i);
            if (c != '\u0000') {
                dataOutputStream.write(c);
                continue;
            }
            dataOutputStream.write(32);
        }
    }

    private static void encodeDataChunkLowerCase(DataOutputStream dataOutputStream, DataChunk dc) throws IOException {
        if (dc.isNull()) {
            return;
        }
        switch (dc.getType()) {
            case Bytes: {
                ByteChunk bc = dc.getByteChunk();
                SpdyEncoderUtils.encodeDataChunkLowerCase(dataOutputStream, bc.getBuffer(), bc.getStart(), bc.getLength());
                break;
            }
            case Buffer: {
                BufferChunk bufferChunk = dc.getBufferChunk();
                SpdyEncoderUtils.encodeDataChunkLowerCase(dataOutputStream, bufferChunk.getBuffer(), bufferChunk.getStart(), bufferChunk.getLength());
                break;
            }
            default: {
                SpdyEncoderUtils.encodeDataChunkLowerCase(dataOutputStream, dc.toString());
            }
        }
    }

    private static void encodeDataChunkLowerCase(DataOutputStream dataOutputStream, byte[] array, int offs, int len) throws IOException {
        int lim = offs + len;
        for (int i = offs; i < lim; ++i) {
            dataOutputStream.write(Ascii.toLower((int)array[i]));
        }
    }

    private static void encodeDataChunkLowerCase(DataOutputStream dataOutputStream, Buffer buffer, int offs, int len) throws IOException {
        if (buffer.hasArray()) {
            SpdyEncoderUtils.encodeDataChunkLowerCase(dataOutputStream, buffer.array(), buffer.arrayOffset() + offs, len);
        } else {
            int lim = offs + len;
            for (int i = offs; i < lim; ++i) {
                dataOutputStream.write(Ascii.toLower((int)buffer.get(i)));
            }
        }
    }

    private static void encodeDataChunkLowerCase(DataOutputStream dataOutputStream, String s) throws IOException {
        int len = s.length();
        for (int i = 0; i < len; ++i) {
            char c = s.charAt(i);
            if (c != '\u0000') {
                dataOutputStream.write(Ascii.toLower((int)c));
                continue;
            }
            dataOutputStream.write(32);
        }
    }

    private static void encodeHeaderValue(DataOutputStream dataOutputStream, byte[] nameBytes, byte[] valueBytes) throws IOException {
        SpdyEncoderUtils.encodeHeaderValue(dataOutputStream, nameBytes, valueBytes, 0, valueBytes.length);
    }

    private static void encodeHeaderValue(DataOutputStream dataOutputStream, byte[] nameBytes, byte[] valueBytes, int valueStart, int valueLen) throws IOException {
        dataOutputStream.writeInt(nameBytes.length);
        dataOutputStream.write(nameBytes);
        dataOutputStream.writeInt(valueLen);
        dataOutputStream.write(valueBytes, valueStart, valueLen);
    }

    private static void encodeHeaderValue(DataOutputStream dataOutputStream, byte[] nameBytes, byte[] valuePart1, byte[] valuePart2, byte[] valuePart3) throws IOException {
        dataOutputStream.writeInt(nameBytes.length);
        dataOutputStream.write(nameBytes);
        dataOutputStream.writeInt(valuePart1.length + valuePart2.length + valuePart3.length);
        dataOutputStream.write(valuePart1);
        dataOutputStream.write(valuePart2);
        dataOutputStream.write(valuePart3);
    }
}

