/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.grizzly.spdy;

import org.glassfish.grizzly.ThreadCache;
import org.glassfish.grizzly.http.HttpHeader;
import org.glassfish.grizzly.http.HttpResponsePacket;
import org.glassfish.grizzly.http.ProcessingState;
import org.glassfish.grizzly.http.util.DataChunk;
import org.glassfish.grizzly.http.util.Header;
import org.glassfish.grizzly.spdy.SpdyHeader;
import org.glassfish.grizzly.spdy.SpdyStream;

class SpdyResponse
extends HttpResponsePacket
implements SpdyHeader {
    private static final ThreadCache.CachedTypeIndex<SpdyResponseRecyclable> CACHE_IDX = ThreadCache.obtainIndex(SpdyResponseRecyclable.class, (int)2);
    final ProcessingState processingState = new ProcessingState();
    private boolean charEncodingParsed;
    private boolean contentTypeParsed;

    SpdyResponse() {
    }

    public static SpdyResponse create() {
        SpdyResponse spdyResponse = (SpdyResponse)ThreadCache.takeFromCache(CACHE_IDX);
        if (spdyResponse == null) {
            spdyResponse = new SpdyResponse();
        }
        return spdyResponse;
    }

    public ProcessingState getProcessingState() {
        return this.processingState;
    }

    @Override
    public SpdyStream getSpdyStream() {
        return SpdyStream.getSpdyStream((HttpHeader)this);
    }

    public String getCharacterEncoding() {
        if (this.characterEncoding != null || this.charEncodingParsed) {
            return this.characterEncoding;
        }
        this.getContentType();
        this.charEncodingParsed = true;
        return this.characterEncoding;
    }

    public String getContentType() {
        if (!this.contentTypeParsed) {
            DataChunk dc;
            this.contentTypeParsed = true;
            if (this.contentType == null && (dc = this.headers.getValue(Header.ContentType)) != null && !dc.isNull()) {
                this.setContentType(dc.toString());
            }
        }
        return super.getContentType();
    }

    @Override
    public void setExpectContent(boolean isExpectContent) {
        super.setExpectContent(isExpectContent);
    }

    protected void reset() {
        this.charEncodingParsed = false;
        this.contentTypeParsed = false;
        this.processingState.recycle();
        super.reset();
    }

    private static class SpdyResponseRecyclable
    extends SpdyResponse {
        private SpdyResponseRecyclable() {
        }

        public void recycle() {
            this.reset();
            ThreadCache.putToCache((ThreadCache.CachedTypeIndex)CACHE_IDX, (Object)this);
        }
    }
}

