/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.grizzly.spdy.frames;

import org.glassfish.grizzly.Buffer;
import org.glassfish.grizzly.ThreadCache;
import org.glassfish.grizzly.memory.MemoryManager;
import org.glassfish.grizzly.spdy.frames.SpdyFrame;
import org.glassfish.grizzly.spdy.frames.SpdyHeader;

public class WindowUpdateFrame
extends SpdyFrame {
    private static final ThreadCache.CachedTypeIndex<WindowUpdateFrame> CACHE_IDX = ThreadCache.obtainIndex(WindowUpdateFrame.class, (int)8);
    public static final int TYPE = 9;
    private int streamId;
    private int delta;

    private WindowUpdateFrame() {
    }

    static WindowUpdateFrame create() {
        WindowUpdateFrame frame = (WindowUpdateFrame)ThreadCache.takeFromCache(CACHE_IDX);
        if (frame == null) {
            frame = new WindowUpdateFrame();
        }
        return frame;
    }

    static WindowUpdateFrame create(SpdyHeader header) {
        WindowUpdateFrame frame = WindowUpdateFrame.create();
        frame.initialize(header);
        return frame;
    }

    public static WindowUpdateFrameBuilder builder() {
        return new WindowUpdateFrameBuilder();
    }

    public int getStreamId() {
        return this.streamId;
    }

    public int getDelta() {
        return this.delta;
    }

    @Override
    public boolean isFlagSet(byte flag) {
        return false;
    }

    @Override
    public void setFlag(byte flag) {
    }

    @Override
    public void clearFlag(byte flag) {
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("WindowUpdateFrame");
        sb.append("{streamId=").append(this.streamId);
        sb.append(", delta=").append(this.delta);
        sb.append('}');
        return sb.toString();
    }

    @Override
    public void recycle() {
        this.streamId = 0;
        this.delta = 0;
        super.recycle();
        ThreadCache.putToCache(CACHE_IDX, (Object)this);
    }

    @Override
    public Buffer toBuffer(MemoryManager memoryManager) {
        Buffer buffer = memoryManager.allocate(16);
        buffer.putInt(0, -2147287031);
        buffer.putInt(4, 8);
        buffer.putInt(8, this.streamId & Integer.MAX_VALUE);
        buffer.putInt(12, this.delta & Integer.MAX_VALUE);
        return buffer;
    }

    @Override
    protected void initialize(SpdyHeader header) {
        super.initialize(header);
        this.streamId = header.buffer.getInt() & 0x7FFFFFF;
        this.delta = header.buffer.getInt() & 0x7FFFFFF;
    }

    public static class WindowUpdateFrameBuilder
    extends SpdyFrame.SpdyFrameBuilder<WindowUpdateFrameBuilder> {
        private WindowUpdateFrame windowUpdateFrame;

        protected WindowUpdateFrameBuilder() {
            super(WindowUpdateFrame.create());
            this.windowUpdateFrame = (WindowUpdateFrame)this.frame;
        }

        public WindowUpdateFrameBuilder streamId(int streamId) {
            this.windowUpdateFrame.streamId = streamId;
            return this;
        }

        public WindowUpdateFrameBuilder delta(int delta) {
            this.windowUpdateFrame.delta = delta;
            return this;
        }

        public WindowUpdateFrame build() {
            return this.windowUpdateFrame;
        }

        @Override
        protected WindowUpdateFrameBuilder getThis() {
            return this;
        }
    }
}

