/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.grizzly.spdy;

import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.locks.ReentrantLock;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.net.ssl.SSLEngine;
import org.glassfish.grizzly.Buffer;
import org.glassfish.grizzly.Closeable;
import org.glassfish.grizzly.CompletionHandler;
import org.glassfish.grizzly.Connection;
import org.glassfish.grizzly.EmptyCompletionHandler;
import org.glassfish.grizzly.Grizzly;
import org.glassfish.grizzly.OutputSink;
import org.glassfish.grizzly.WriteResult;
import org.glassfish.grizzly.attributes.AttributeStorage;
import org.glassfish.grizzly.filterchain.FilterChain;
import org.glassfish.grizzly.filterchain.FilterChainContext;
import org.glassfish.grizzly.filterchain.FilterChainEvent;
import org.glassfish.grizzly.filterchain.NextAction;
import org.glassfish.grizzly.filterchain.TransportFilter;
import org.glassfish.grizzly.http.FixedLengthTransferEncoding;
import org.glassfish.grizzly.http.HttpBaseFilter;
import org.glassfish.grizzly.http.HttpContent;
import org.glassfish.grizzly.http.HttpContext;
import org.glassfish.grizzly.http.HttpHeader;
import org.glassfish.grizzly.http.HttpPacket;
import org.glassfish.grizzly.http.HttpRequestPacket;
import org.glassfish.grizzly.http.HttpResponsePacket;
import org.glassfish.grizzly.http.HttpServerFilter;
import org.glassfish.grizzly.http.Method;
import org.glassfish.grizzly.http.ProcessingState;
import org.glassfish.grizzly.http.Protocol;
import org.glassfish.grizzly.http.TransferEncoding;
import org.glassfish.grizzly.http.util.DataChunk;
import org.glassfish.grizzly.http.util.Header;
import org.glassfish.grizzly.http.util.HttpStatus;
import org.glassfish.grizzly.http.util.MimeHeaders;
import org.glassfish.grizzly.npn.ClientSideNegotiator;
import org.glassfish.grizzly.spdy.Constants;
import org.glassfish.grizzly.spdy.NextProtoNegSupport;
import org.glassfish.grizzly.spdy.PushResource;
import org.glassfish.grizzly.spdy.Source;
import org.glassfish.grizzly.spdy.SpdyDecoderUtils;
import org.glassfish.grizzly.spdy.SpdyMode;
import org.glassfish.grizzly.spdy.SpdyRequest;
import org.glassfish.grizzly.spdy.SpdyResponse;
import org.glassfish.grizzly.spdy.SpdySession;
import org.glassfish.grizzly.spdy.SpdySessionException;
import org.glassfish.grizzly.spdy.SpdyStream;
import org.glassfish.grizzly.spdy.SpdyStreamException;
import org.glassfish.grizzly.spdy.compression.SpdyInflaterOutputStream;
import org.glassfish.grizzly.spdy.frames.DataFrame;
import org.glassfish.grizzly.spdy.frames.GoAwayFrame;
import org.glassfish.grizzly.spdy.frames.HeadersProviderFrame;
import org.glassfish.grizzly.spdy.frames.PingFrame;
import org.glassfish.grizzly.spdy.frames.RstStreamFrame;
import org.glassfish.grizzly.spdy.frames.ServiceFrame;
import org.glassfish.grizzly.spdy.frames.SettingsFrame;
import org.glassfish.grizzly.spdy.frames.SpdyFrame;
import org.glassfish.grizzly.spdy.frames.SpdyHeader;
import org.glassfish.grizzly.spdy.frames.SynReplyFrame;
import org.glassfish.grizzly.spdy.frames.SynStreamFrame;
import org.glassfish.grizzly.spdy.frames.WindowUpdateFrame;
import org.glassfish.grizzly.ssl.SSLBaseFilter;
import org.glassfish.grizzly.ssl.SSLFilter;

public class SpdyHandlerFilter
extends HttpBaseFilter {
    private static final Logger LOGGER = Grizzly.logger(SpdyHandlerFilter.class);
    private static final ClientNpnNegotiator DEFAULT_CLIENT_NPN_NEGOTIATOR = new ClientNpnNegotiator();
    private static final TransferEncoding FIXED_LENGTH_ENCODING = new FixedLengthTransferEncoding();
    private final SpdyMode spdyMode;
    private final ExecutorService threadPool;
    private volatile int maxConcurrentStreams = 100;
    private volatile int initialWindowSize = 65536;

    public SpdyHandlerFilter(SpdyMode spdyMode) {
        this(spdyMode, null);
    }

    public SpdyHandlerFilter(SpdyMode spdyMode, ExecutorService threadPool) {
        this.spdyMode = spdyMode;
        this.threadPool = threadPool;
    }

    public void setMaxConcurrentStreams(int maxConcurrentStreams) {
        this.maxConcurrentStreams = maxConcurrentStreams;
    }

    public int getMaxConcurrentStreams() {
        return this.maxConcurrentStreams;
    }

    public void setInitialWindowSize(int initialWindowSize) {
        this.initialWindowSize = initialWindowSize;
    }

    public int getInitialWindowSize() {
        return this.initialWindowSize;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NextAction handleRead(FilterChainContext ctx) throws IOException {
        SpdySession spdySession = this.checkSpdySession(ctx, true);
        Object message = ctx.getMessage();
        if (message == null) {
            SpdyStream spdyStream = (SpdyStream)HttpContext.get((FilterChainContext)ctx).getContextStorage();
            HttpContent httpContent = spdyStream.pollInputData();
            ctx.setMessage((Object)httpContent);
            return ctx.getInvokeAction();
        }
        if (HttpPacket.isHttp((Object)message)) {
            return ctx.getInvokeAction();
        }
        try {
            if (message instanceof SpdyFrame) {
                SpdyFrame frame = (SpdyFrame)message;
                try {
                    this.processInFrame(spdySession, ctx, frame);
                }
                catch (SpdyStreamException e) {
                    if (LOGGER.isLoggable(Level.FINE)) {
                        LOGGER.log(Level.FINE, "SpdyStreamException occurred on connection=" + ctx.getConnection() + " during SpdyFrame processing", e);
                    }
                    SpdyHandlerFilter.sendRstStream(ctx, e.getStreamId(), e.getRstReason());
                }
            } else {
                ArrayList framesList = (ArrayList)message;
                int sz = framesList.size();
                try {
                    for (int i = 0; i < sz; ++i) {
                        try {
                            this.processInFrame(spdySession, ctx, (SpdyFrame)framesList.get(i));
                            continue;
                        }
                        catch (SpdyStreamException e) {
                            if (LOGGER.isLoggable(Level.FINE)) {
                                LOGGER.log(Level.FINE, "SpdyStreamException occurred on connection=" + ctx.getConnection() + " during SpdyFrame processing", e);
                            }
                            SpdyHandlerFilter.sendRstStream(ctx, e.getStreamId(), e.getRstReason());
                        }
                    }
                }
                finally {
                    framesList.clear();
                }
            }
            List<SpdyStream> streamsToFlushInput = spdySession.streamsToFlushInput;
            for (int i = 0; i < streamsToFlushInput.size(); ++i) {
                streamsToFlushInput.get(i).flushInputData();
            }
            streamsToFlushInput.clear();
        }
        catch (SpdySessionException e) {
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.log(Level.FINE, "SpdySessionException occurred on connection=" + ctx.getConnection() + " during SpdyFrame processing", e);
            }
            SpdyHandlerFilter.sendGoAwayAndClose(ctx, spdySession, e.getStreamId(), e.getGoAwayStatus(), e.getRstReason());
            return ctx.getSuspendAction();
        }
        catch (IOException e) {
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.log(Level.FINE, "IOException occurred on connection=" + ctx.getConnection() + " during SpdyFrame processing", e);
            }
            SpdyHandlerFilter.sendGoAwayAndClose(ctx, spdySession, -1, 11, -1);
            return ctx.getSuspendAction();
        }
        return ctx.getStopAction();
    }

    protected boolean onHttpPacketParsed(HttpHeader httpHeader, FilterChainContext ctx) {
        return false;
    }

    protected boolean onHttpHeaderParsed(HttpHeader httpHeader, Buffer buffer, FilterChainContext ctx) {
        return false;
    }

    protected void onInitialLineParsed(HttpHeader httpHeader, FilterChainContext ctx) {
    }

    protected void onInitialLineEncoded(HttpHeader httpHeader, FilterChainContext ctx) {
    }

    protected void onHttpHeadersParsed(HttpHeader httpHeader, FilterChainContext ctx) {
    }

    protected void onHttpHeadersEncoded(HttpHeader httpHeader, FilterChainContext ctx) {
    }

    protected void onHttpContentParsed(HttpContent content, FilterChainContext ctx) {
    }

    protected void onHttpContentEncoded(HttpContent content, FilterChainContext ctx) {
    }

    protected void onHttpHeaderError(HttpHeader httpHeader, FilterChainContext ctx, Throwable t) throws IOException {
    }

    protected void onHttpContentError(HttpHeader httpHeader, FilterChainContext ctx, Throwable t) throws IOException {
    }

    private void processInFrame(SpdySession spdySession, FilterChainContext context, SpdyFrame frame) throws SpdyStreamException, SpdySessionException, IOException {
        if (frame.isService()) {
            this.processServiceFrame(spdySession, (ServiceFrame)frame);
        } else if (frame.getHeader().isControl()) {
            this.processControlFrame(spdySession, context, frame);
        } else {
            SpdyStream spdyStream = spdySession.getStream(frame.getHeader().getStreamId());
            if (spdyStream == null) {
                if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.log(Level.FINE, "Data frame received for non-existent stream: connection={0}, frame={1}, stream={2}", new Object[]{context.getConnection(), frame, frame.getHeader().getStreamId()});
                }
                frame.recycle();
                return;
            }
            if (spdyStream.isUnidirectional() && spdyStream.isLocallyInitiatedStream()) {
                throw new SpdyStreamException(spdyStream.getStreamId(), 1, "Data frame received on unidirectional stream");
            }
            SpdyHandlerFilter.processDataFrame(spdyStream, frame);
        }
    }

    private void processControlFrame(SpdySession spdySession, FilterChainContext context, SpdyFrame frame) throws SpdyStreamException, SpdySessionException, IOException {
        switch (frame.getHeader().getType()) {
            case 1: {
                this.processSynStream(spdySession, context, frame);
                break;
            }
            case 4: {
                this.processSettings(spdySession, frame);
                break;
            }
            case 2: {
                this.processSynReply(spdySession, context, frame);
                break;
            }
            case 6: {
                this.processPing(spdySession, frame);
                break;
            }
            case 3: {
                this.processRstStream(spdySession, frame);
                break;
            }
            case 7: {
                this.processGoAwayFrame(spdySession, frame);
                break;
            }
            case 9: {
                this.processWindowUpdateFrame(spdySession, frame);
                break;
            }
            default: {
                LOGGER.log(Level.WARNING, "Unknown or unhandled control-frame [version={0} type={1} flags={2} length={3}]", new Object[]{frame.getHeader().getVersion(), frame.getHeader().getType(), frame.getHeader().getFlags(), frame.getHeader().getLength()});
            }
        }
    }

    private void processWindowUpdateFrame(SpdySession spdySession, SpdyFrame frame) throws SpdyStreamException {
        WindowUpdateFrame updateFrame = (WindowUpdateFrame)frame;
        int streamId = updateFrame.getStreamId();
        int delta = updateFrame.getDelta();
        SpdyStream stream = spdySession.getStream(streamId);
        if (stream != null) {
            stream.onPeerWindowUpdate(delta);
        } else if (LOGGER.isLoggable(Level.FINE)) {
            StringBuilder sb = new StringBuilder(64);
            sb.append("\nStream id=").append(streamId).append(" was not found. Ignoring the message.");
            LOGGER.fine(sb.toString());
        }
    }

    private void processGoAwayFrame(SpdySession spdySession, SpdyFrame frame) {
        GoAwayFrame goAwayFrame = (GoAwayFrame)frame;
        spdySession.setGoAwayByPeer(goAwayFrame.getLastGoodStreamId());
    }

    private void processSettings(SpdySession spdySession, SpdyFrame frame) {
        SettingsFrame settingsFrame = (SettingsFrame)frame;
        int numberOfSettings = settingsFrame.getNumberOfSettings();
        if (numberOfSettings > 0) {
            byte setSettings = settingsFrame.getSetSettings();
            for (int i = 0; i < 8 && numberOfSettings != 0; ++i) {
                if ((setSettings & 1 << i) == 0) continue;
                switch (i) {
                    case 0: {
                        break;
                    }
                    case 1: {
                        break;
                    }
                    case 2: {
                        break;
                    }
                    case 3: {
                        spdySession.setPeerMaxConcurrentStreams(settingsFrame.getSetting(i));
                        break;
                    }
                    case 4: {
                        break;
                    }
                    case 5: {
                        break;
                    }
                    case 6: {
                        spdySession.setPeerInitialWindowSize(settingsFrame.getSetting(i));
                        break;
                    }
                }
                --numberOfSettings;
            }
        }
    }

    private void processPing(SpdySession spdySession, SpdyFrame frame) {
        PingFrame pingFrame = (PingFrame)frame;
        spdySession.writeDownStream(pingFrame);
    }

    private void processRstStream(SpdySession spdySession, SpdyFrame frame) {
        RstStreamFrame rstFrame = (RstStreamFrame)frame;
        int streamId = rstFrame.getStreamId();
        SpdyStream spdyStream = spdySession.getStream(streamId);
        if (spdyStream == null) {
            frame.recycle();
            return;
        }
        spdyStream.resetRemotely();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processSynStream(SpdySession spdySession, FilterChainContext context, SpdyFrame frame) throws IOException {
        SpdyStream spdyStream;
        SynStreamFrame synStreamFrame = (SynStreamFrame)frame;
        int streamId = synStreamFrame.getStreamId();
        int associatedToStreamId = synStreamFrame.getAssociatedToStreamId();
        int priority = synStreamFrame.getPriority();
        int slot = synStreamFrame.getSlot();
        boolean isUnidirectional = synStreamFrame.isFlagSet((byte)2);
        if (frame.getHeader().getVersion() != 3) {
            throw new SpdySessionException(streamId, 1, 4);
        }
        SpdyRequest spdyRequest = SpdyRequest.create();
        spdyRequest.setConnection(context.getConnection());
        boolean isFinSet = synStreamFrame.isFlagSet((byte)1);
        try {
            spdyStream = spdySession.acceptStream(spdyRequest, streamId, associatedToStreamId, priority, slot, isUnidirectional);
            if (spdyStream == null) {
                frame.getHeader().getUnderlying().tryDispose();
                spdyRequest.recycle();
                return;
            }
            this.decodeHeaders((HttpHeader)spdyRequest, spdyStream, synStreamFrame, context);
        }
        finally {
            frame.recycle();
        }
        this.prepareIncomingRequest(spdyStream, spdyRequest);
        spdyStream.onSynFrameRcv();
        if (!isUnidirectional) {
            boolean isExpectContent;
            if (isFinSet) {
                spdyRequest.setExpectContent(false);
            }
            if (!(isExpectContent = spdyRequest.isExpectContent())) {
                spdyStream.inputBuffer.terminate(Constants.IN_FIN_TERMINATION);
            }
            this.sendUpstream(spdySession, spdyStream, (HttpHeader)spdyRequest, isExpectContent);
        } else {
            spdyRequest.setExpectContent(false);
            spdyStream.outputSink.terminate(Constants.OUT_FIN_TERMINATION);
            HttpResponsePacket spdyResponse = spdyRequest.getResponse();
            if (isFinSet) {
                spdyResponse.setExpectContent(false);
            }
            this.sendUpstream(spdySession, spdyStream, (HttpHeader)spdyResponse, !isFinSet);
        }
    }

    private void decodeHeaders(HttpHeader httpHeader, SpdyStream spdyStream, HeadersProviderFrame headersProviderFrame, FilterChainContext ctx) throws IOException {
        SpdyInflaterOutputStream inflaterOutputStream = spdyStream.getSpdySession().getInflaterOutputStream();
        inflaterOutputStream.write(headersProviderFrame.getCompressedHeaders());
        Buffer decodedHeaders = inflaterOutputStream.checkpoint();
        if (httpHeader.isRequest()) {
            if (decodedHeaders.hasArray()) {
                if (!spdyStream.isUnidirectional()) {
                    SpdyDecoderUtils.processSynStreamHeadersArray((SpdyRequest)httpHeader, decodedHeaders);
                } else {
                    SpdyDecoderUtils.processUSynStreamHeadersArray((SpdyRequest)httpHeader, decodedHeaders);
                }
            } else if (!spdyStream.isUnidirectional()) {
                SpdyDecoderUtils.processSynStreamHeadersBuffer((SpdyRequest)httpHeader, decodedHeaders);
            } else {
                SpdyDecoderUtils.processUSynStreamHeadersBuffer((SpdyRequest)httpHeader, decodedHeaders);
            }
        } else {
            try {
                if (decodedHeaders.hasArray()) {
                    SpdyDecoderUtils.processSynReplyHeadersArray((SpdyResponse)httpHeader, decodedHeaders, ctx, this);
                } else {
                    SpdyDecoderUtils.processSynReplyHeadersBuffer((SpdyResponse)httpHeader, decodedHeaders, ctx, this);
                }
            }
            catch (Exception e) {
                this.onHttpHeaderError(httpHeader, ctx, e);
                throw (RuntimeException)e;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processSynReply(SpdySession spdySession, FilterChainContext context, SpdyFrame frame) throws SpdySessionException, IOException {
        SpdyResponse spdyResponse;
        SynReplyFrame synReplyFrame = (SynReplyFrame)frame;
        int streamId = synReplyFrame.getStreamId();
        if (frame.getHeader().getVersion() != 3) {
            throw new SpdySessionException(streamId, 1, 4);
        }
        SpdyStream spdyStream = spdySession.getStream(streamId);
        HttpContext.newInstance((FilterChainContext)context, (AttributeStorage)spdyStream, (OutputSink)spdyStream, (Closeable)spdyStream);
        if (spdyStream == null) {
            frame.getHeader().getUnderlying().dispose();
            frame.recycle();
            return;
        }
        if (spdyStream.isUnidirectional()) {
            throw new SpdyStreamException(streamId, 1, "SynReply received on unidirectional stream");
        }
        HttpRequestPacket spdyRequest = spdyStream.getSpdyRequest();
        HttpResponsePacket response = spdyRequest.getResponse();
        if (response == null) {
            spdyResponse = SpdyResponse.create();
        } else if (response instanceof SpdyResponse) {
            spdyResponse = (SpdyResponse)response;
        } else {
            frame.getHeader().getUnderlying().dispose();
            frame.recycle();
            throw new IllegalStateException("Unexpected response type: " + response.getClass());
        }
        boolean isFin = synReplyFrame.isFlagSet((byte)1);
        if (isFin) {
            spdyResponse.setExpectContent(false);
            spdyStream.inputBuffer.terminate(Constants.IN_FIN_TERMINATION);
        }
        try {
            this.decodeHeaders((HttpHeader)spdyResponse, spdyStream, synReplyFrame, context);
        }
        finally {
            frame.recycle();
        }
        spdyStream.onSynFrameRcv();
        this.bind(spdyRequest, spdyResponse);
        if (isFin) {
            this.onHttpPacketParsed((HttpHeader)spdyResponse, context);
        }
        this.sendUpstream(spdySession, spdyStream, (HttpHeader)spdyResponse, !isFin);
    }

    public NextAction handleWrite(FilterChainContext ctx) throws IOException {
        Object message = ctx.getMessage();
        SpdySession spdySession = this.checkSpdySession(ctx, false);
        if (HttpPacket.isHttp((Object)message)) {
            HttpPacket httpPacket = (HttpPacket)ctx.getMessage();
            HttpHeader httpHeader = httpPacket.getHttpHeader();
            if (httpHeader.isRequest()) {
                this.processOutgoingRequest(ctx, spdySession, (HttpRequestPacket)httpHeader, httpPacket);
            } else {
                this.processOutgoingResponse(ctx, spdySession, (HttpResponsePacket)httpHeader, httpPacket);
            }
        } else {
            FilterChainContext.TransportContext transportContext = ctx.getTransportContext();
            spdySession.writeDownStream(message, (CompletionHandler<WriteResult>)transportContext.getCompletionHandler(), transportContext.getMessageCloner());
        }
        return ctx.getStopAction();
    }

    private void processOutgoingRequest(FilterChainContext ctx, SpdySession spdySession, HttpRequestPacket request, HttpPacket entireHttpPacket) throws IOException {
        SpdyStream spdyStream;
        if (!request.isCommitted()) {
            this.prepareOutgoingRequest(request);
        }
        if ((spdyStream = SpdyStream.getSpdyStream((HttpHeader)request)) == null) {
            this.processOutgoingRequestForNewStream(ctx, spdySession, request, entireHttpPacket);
        } else {
            FilterChainContext.TransportContext transportContext = ctx.getTransportContext();
            spdyStream.writeDownStream(entireHttpPacket, ctx, (CompletionHandler<WriteResult>)transportContext.getCompletionHandler(), transportContext.getMessageCloner());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processOutgoingRequestForNewStream(FilterChainContext ctx, SpdySession spdySession, HttpRequestPacket request, HttpPacket entireHttpPacket) throws IOException {
        ReentrantLock newStreamLock = spdySession.getNewClientStreamLock();
        newStreamLock.lock();
        try {
            SpdyStream spdyStream = spdySession.openStream(request, spdySession.getNextLocalStreamId(), 0, 0, 0, false, !request.isExpectContent());
            if (spdyStream == null) {
                throw new IOException("SpdySession is closed");
            }
            FilterChainContext.TransportContext transportContext = ctx.getTransportContext();
            spdyStream.writeDownStream(entireHttpPacket, ctx, (CompletionHandler<WriteResult>)transportContext.getCompletionHandler(), transportContext.getMessageCloner());
        }
        finally {
            newStreamLock.unlock();
        }
    }

    private void processOutgoingResponse(FilterChainContext ctx, SpdySession spdySession, HttpResponsePacket response, HttpPacket entireHttpPacket) throws IOException {
        SpdyStream spdyStream = SpdyStream.getSpdyStream((HttpHeader)response);
        assert (spdyStream != null);
        if (!response.isCommitted()) {
            this.prepareOutgoingResponse(response);
            this.pushAssociatedResoureses(spdyStream);
        }
        FilterChainContext.TransportContext transportContext = ctx.getTransportContext();
        spdyStream.writeDownStream(entireHttpPacket, ctx, (CompletionHandler<WriteResult>)transportContext.getCompletionHandler(), transportContext.getMessageCloner());
    }

    private void processServiceFrame(SpdySession spdySession, ServiceFrame frame) throws SpdyStreamException, SpdySessionException {
        if (frame.getServiceCode() == -100) {
            SpdyHeader header = frame.getHeader();
            if (header.isControl()) {
                int spdyStreamId = header.getStreamId();
                Buffer message = header.getUnderlying();
                if (spdyStreamId == -1 && message.remaining() >= 4 && Constants.CTRL_FRAMES_WITH_STREAM_ID.contains(header.getType())) {
                    spdyStreamId = message.getInt(message.position()) & Integer.MAX_VALUE;
                }
                throw new SpdySessionException(spdyStreamId, 1, 11);
            }
            int streamId = header.getStreamId();
            SpdyStream spdyStream = spdySession.getStream(streamId);
            if (spdyStream != null) {
                spdyStream.inputBuffer.close(Constants.FRAME_TOO_LARGE_TERMINATION);
                throw new SpdyStreamException(streamId, 11);
            }
            throw new SpdyStreamException(streamId, 2);
        }
    }

    public NextAction handleConnect(FilterChainContext ctx) throws IOException {
        FilterChain filterChain;
        int idx;
        Connection connection = ctx.getConnection();
        this.createSpdySession(connection, false);
        if (this.spdyMode == SpdyMode.NPN && (idx = (filterChain = (FilterChain)connection.getProcessor()).indexOfType(SSLFilter.class)) != -1) {
            SSLFilter sslFilter = (SSLFilter)filterChain.get(idx);
            NextProtoNegSupport.getInstance().configure((SSLBaseFilter)sslFilter);
            NextProtoNegSupport.getInstance().setClientSideNegotiator(connection, this.getClientNpnNegotioator());
            sslFilter.handshake(connection, null);
        }
        return ctx.getInvokeAction();
    }

    public NextAction handleEvent(FilterChainContext ctx, FilterChainEvent event) throws IOException {
        Object type = event.type();
        if (type == HttpServerFilter.RESPONSE_COMPLETE_EVENT.type()) {
            HttpContext httpContext = HttpContext.get((FilterChainContext)ctx);
            SpdyStream spdyStream = (SpdyStream)httpContext.getContextStorage();
            spdyStream.onProcessingComplete();
            return ctx.getStopAction();
        }
        if (type == TransportFilter.FlushEvent.TYPE) {
            assert (event instanceof TransportFilter.FlushEvent);
            HttpContext httpContext = HttpContext.get((FilterChainContext)ctx);
            SpdyStream spdyStream = (SpdyStream)httpContext.getContextStorage();
            TransportFilter.FlushEvent flushEvent = (TransportFilter.FlushEvent)event;
            spdyStream.outputSink.flush((CompletionHandler<SpdyStream>)flushEvent.getCompletionHandler());
            return ctx.getStopAction();
        }
        return ctx.getInvokeAction();
    }

    protected ClientSideNegotiator getClientNpnNegotioator() {
        return DEFAULT_CLIENT_NPN_NEGOTIATOR;
    }

    protected SpdySession createSpdySession(Connection connection, boolean isServer) {
        SpdySession spdySession = new SpdySession(connection, isServer, this);
        spdySession.setLocalInitialWindowSize(this.initialWindowSize);
        spdySession.setLocalMaxConcurrentStreams(this.maxConcurrentStreams);
        SpdySession.bind(connection, spdySession);
        return spdySession;
    }

    private void sendUpstream(final SpdySession spdySession, final SpdyStream spdyStream, final HttpHeader httpHeader, final boolean isExpectContent) {
        if (this.threadPool == null) {
            spdySession.sendMessageUpstream(spdyStream, (HttpPacket)HttpContent.builder((HttpHeader)httpHeader).last(!isExpectContent).build());
        } else {
            this.threadPool.execute(new Runnable(){

                @Override
                public void run() {
                    spdySession.sendMessageUpstream(spdyStream, (HttpPacket)HttpContent.builder((HttpHeader)httpHeader).last(!isExpectContent).build());
                }
            });
        }
    }

    private void prepareIncomingRequest(SpdyStream spdyStream, SpdyRequest request) {
        ProcessingState state = request.getProcessingState();
        HttpResponsePacket response = request.getResponse();
        Method method = request.getMethod();
        if (!spdyStream.isUnidirectional() && (Method.GET.equals(method) || Method.HEAD.equals(method) || !Method.CONNECT.equals(method) && request.getContentLength() == 0L)) {
            request.setExpectContent(false);
        }
        try {
            request.getProtocol();
        }
        catch (IllegalStateException e) {
            state.setError(true);
            HttpStatus.HTTP_VERSION_NOT_SUPPORTED_505.setValues(response);
            request.setProtocol(Protocol.HTTP_1_1);
            return;
        }
        MimeHeaders headers = request.getHeaders();
        DataChunk hostDC = headers.getValue(Header.Host);
        if (hostDC == null || hostDC.getLength() == 0) {
            state.setError(true);
        }
    }

    private void prepareOutgoingRequest(HttpRequestPacket request) {
        String contentType = request.getContentType();
        if (contentType != null) {
            request.getHeaders().setValue(Header.ContentType).setString(contentType);
        }
        if (request.getContentLength() != -1L) {
            FIXED_LENGTH_ENCODING.prepareSerialize(null, (HttpHeader)request, null);
        }
    }

    private void prepareOutgoingResponse(HttpResponsePacket response) {
        response.setProtocol(Protocol.HTTP_1_1);
        String contentType = response.getContentType();
        if (contentType != null) {
            response.getHeaders().setValue(Header.ContentType).setString(contentType);
        }
        if (response.getContentLength() != -1L) {
            FIXED_LENGTH_ENCODING.prepareSerialize(null, (HttpHeader)response, null);
        }
    }

    private static void sendRstStream(FilterChainContext ctx, int streamId, int statusCode) {
        RstStreamFrame rstStreamFrame = RstStreamFrame.builder().statusCode(statusCode).streamId(streamId).build();
        ctx.write((Object)rstStreamFrame);
    }

    private static void sendGoAwayAndClose(FilterChainContext ctx, SpdySession spdySession, int streamId, int goAwayStatus, int rstStatus) {
        GoAwayFrame goAwayFrame = spdySession.setGoAwayLocally(goAwayStatus);
        if (goAwayFrame != null) {
            Object outputMessage;
            final Connection connection = ctx.getConnection();
            if (rstStatus >= 0) {
                RstStreamFrame rstStreamFrame = RstStreamFrame.builder().statusCode(rstStatus).streamId(streamId).build();
                ArrayList<SpdyFrame> frames = new ArrayList<SpdyFrame>(2);
                frames.add(rstStreamFrame);
                frames.add(goAwayFrame);
                outputMessage = frames;
            } else {
                outputMessage = goAwayFrame;
            }
            ctx.write(outputMessage, (CompletionHandler)new EmptyCompletionHandler(){

                public void failed(Throwable throwable) {
                    connection.closeSilently();
                }

                public void completed(Object result) {
                    connection.closeSilently();
                }
            });
        }
    }

    private SpdySession checkSpdySession(FilterChainContext context, boolean isUpStream) {
        Connection connection = context.getConnection();
        SpdySession spdySession = SpdySession.get(connection);
        if (spdySession == null) {
            spdySession = this.createSpdySession(connection, true);
        }
        if (spdySession.initCommunication(context, isUpStream)) {
            this.sendSettingsIfNeeded(spdySession, context);
        }
        return spdySession;
    }

    private void sendSettingsIfNeeded(SpdySession spdySession, FilterChainContext context) {
        boolean isInitialWindowUpdated;
        boolean isConcurrentStreamsUpdated = spdySession.getLocalMaxConcurrentStreams() >= 0;
        boolean bl = isInitialWindowUpdated = spdySession.getLocalInitialWindowSize() != 65536;
        if (isConcurrentStreamsUpdated || isInitialWindowUpdated) {
            SettingsFrame.SettingsFrameBuilder builder = SettingsFrame.builder();
            if (isConcurrentStreamsUpdated) {
                builder.setting(3, this.maxConcurrentStreams);
            }
            if (isInitialWindowUpdated) {
                builder.setting(6, this.initialWindowSize);
            }
            builder.setFlag((byte)1);
            context.write((Object)builder.build());
        }
    }

    private static void processDataFrame(SpdyStream spdyStream, SpdyFrame frame) throws SpdyStreamException {
        DataFrame dataFrame = (DataFrame)frame;
        spdyStream.offerInputData(dataFrame.getData(), dataFrame.isFlagSet((byte)1));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void pushAssociatedResoureses(SpdyStream spdyStream) throws IOException {
        Map<String, PushResource> pushResourceMap = spdyStream.getAssociatedResourcesToPush();
        if (pushResourceMap != null) {
            SpdySession spdySession = spdyStream.getSpdySession();
            ReentrantLock lock = spdySession.getNewClientStreamLock();
            lock.lock();
            try {
                for (Map.Entry<String, PushResource> entry : pushResourceMap.entrySet()) {
                    Map<String, String> extraHeaders;
                    PushResource pushResource = entry.getValue();
                    Source source = pushResource.getSource();
                    SpdyRequest spdyRequest = SpdyRequest.create();
                    HttpResponsePacket spdyResponse = spdyRequest.getResponse();
                    spdyRequest.setRequestURI(entry.getKey());
                    spdyResponse.setStatus(pushResource.getStatusCode());
                    spdyResponse.setProtocol(Protocol.HTTP_1_1);
                    spdyResponse.setContentType(pushResource.getContentType());
                    if (source != null) {
                        spdyResponse.setContentLengthLong(source.remaining());
                    }
                    if ((extraHeaders = pushResource.getHeaders()) != null) {
                        for (Map.Entry<String, String> headerEntry : extraHeaders.entrySet()) {
                            spdyResponse.addHeader(headerEntry.getKey(), headerEntry.getValue());
                        }
                    }
                    try {
                        SpdyStream pushStream = spdySession.openStream(spdyRequest, spdySession.getNextLocalStreamId(), spdyStream.getStreamId(), pushResource.getPriority(), 0, true, false);
                        pushStream.inputBuffer.terminate(Constants.IN_FIN_TERMINATION);
                        this.prepareOutgoingResponse(spdyResponse);
                        pushStream.writeDownStream(source);
                    }
                    catch (Exception e) {
                        LOGGER.log(Level.FINE, "Can not push: " + entry.getKey(), e);
                    }
                }
            }
            finally {
                lock.unlock();
            }
        }
    }

    private static class ClientNpnNegotiator
    implements ClientSideNegotiator {
        private static final String SPDY3_PROTOCOL = "spdy/3";

        private ClientNpnNegotiator() {
        }

        public boolean wantNegotiate(SSLEngine engine) {
            Connection connection = NextProtoNegSupport.getConnection(engine);
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.log(Level.FINE, "NPN wantNegotiate. Connection={0}", new Object[]{connection});
            }
            return true;
        }

        public String selectProtocol(SSLEngine engine, LinkedHashSet<String> protocols) {
            Connection connection = NextProtoNegSupport.getConnection(engine);
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.log(Level.FINE, "NPN selectProtocol. Connection={0}, protocols={1}", new Object[]{connection, protocols});
            }
            return protocols.contains(SPDY3_PROTOCOL) ? SPDY3_PROTOCOL : "";
        }

        public void onNoDeal(SSLEngine engine) {
            Connection connection = NextProtoNegSupport.getConnection(engine);
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.log(Level.FINE, "NPN onNoDeal. Connection={0}", new Object[]{connection});
            }
        }
    }
}

