/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.grizzly.spdy;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import org.glassfish.grizzly.Buffer;
import org.glassfish.grizzly.CompletionHandler;
import org.glassfish.grizzly.WriteResult;
import org.glassfish.grizzly.asyncqueue.AsyncQueueRecord;
import org.glassfish.grizzly.asyncqueue.MessageCloner;
import org.glassfish.grizzly.asyncqueue.TaskQueue;
import org.glassfish.grizzly.asyncqueue.WritableMessage;
import org.glassfish.grizzly.filterchain.FilterChainContext;
import org.glassfish.grizzly.http.HttpContent;
import org.glassfish.grizzly.http.HttpHeader;
import org.glassfish.grizzly.http.HttpPacket;
import org.glassfish.grizzly.http.HttpRequestPacket;
import org.glassfish.grizzly.http.HttpResponsePacket;
import org.glassfish.grizzly.memory.Buffers;
import org.glassfish.grizzly.spdy.BundleQueue;
import org.glassfish.grizzly.spdy.Constants;
import org.glassfish.grizzly.spdy.Source;
import org.glassfish.grizzly.spdy.SpdyEncoderUtils;
import org.glassfish.grizzly.spdy.SpdyResponse;
import org.glassfish.grizzly.spdy.SpdySession;
import org.glassfish.grizzly.spdy.SpdyStream;
import org.glassfish.grizzly.spdy.SpdyStreamException;
import org.glassfish.grizzly.spdy.frames.DataFrame;
import org.glassfish.grizzly.spdy.frames.HeadersProviderFrame;
import org.glassfish.grizzly.spdy.frames.SpdyFrame;
import org.glassfish.grizzly.spdy.frames.SynReplyFrame;
import org.glassfish.grizzly.spdy.frames.SynStreamFrame;
import org.glassfish.grizzly.spdy.frames.WindowUpdateFrame;

final class SpdyOutputSink {
    private static final int ATOMIC_QUEUE_RECORD_SIZE = 1;
    private static final OutputQueueRecord TERMINATING_QUEUE_RECORD = new OutputQueueRecord(null, null, true, true);
    final TaskQueue<OutputQueueRecord> outputQueue = TaskQueue.createTaskQueue((TaskQueue.MutableMaxQueueSize)new TaskQueue.MutableMaxQueueSize(){

        public int getMaxQueueSize() {
            return SpdyOutputSink.this.spdyStream.getPeerWindowSize();
        }
    });
    private final AtomicInteger unconfirmedBytes = new AtomicInteger();
    private volatile boolean isLastFrameQueued;
    private SpdyStream.Termination terminationFlag;
    private final SpdySession spdySession;
    private final SpdyStream spdyStream;
    private final AtomicInteger unflushedWritesCounter = new AtomicInteger();
    private final Object flushHandlersSync = new Object();
    private BundleQueue<CompletionHandler<SpdyStream>> flushHandlersQueue;
    private List<SpdyFrame> tmpOutputList;

    SpdyOutputSink(SpdyStream spdyStream) {
        this.spdyStream = spdyStream;
        this.spdySession = spdyStream.getSpdySession();
    }

    public void onPeerWindowUpdate(int delta) throws SpdyStreamException {
        int unconfirmedBytesNow = this.unconfirmedBytes.addAndGet(-delta);
        int windowSizeLimit = this.spdyStream.getPeerWindowSize();
        while (this.isWantToWrite(unconfirmedBytesNow, windowSizeLimit) && !this.outputQueue.isEmpty()) {
            OutputQueueRecord outputQueueRecord = (OutputQueueRecord)this.outputQueue.poll();
            if (outputQueueRecord == null) {
                return;
            }
            if (outputQueueRecord == TERMINATING_QUEUE_RECORD) {
                this.releaseWriteQueueSpace(0, true, true);
                this.writeEmptyFin();
                return;
            }
            FlushCompletionHandler completionHandler = outputQueueRecord.aggrCompletionHandler;
            boolean isLast = outputQueueRecord.isLast;
            boolean isAtomic = outputQueueRecord.isAtomic;
            Source resource = outputQueueRecord.resource;
            int bytesToSend = this.checkOutputWindow(resource.remaining());
            Buffer dataChunkToSend = resource.read(bytesToSend);
            boolean hasRemaining = resource.hasRemaining();
            if (hasRemaining) {
                outputQueueRecord.reset(resource, completionHandler, isLast);
                outputQueueRecord.incCompletionCounter();
                isLast = false;
            } else {
                outputQueueRecord.release();
                outputQueueRecord = null;
            }
            if (dataChunkToSend != null && (dataChunkToSend.hasRemaining() || isLast)) {
                int dataChunkToSendSize = dataChunkToSend.remaining();
                DataFrame dataFrame = DataFrame.builder().data(dataChunkToSend).last(isLast).streamId(this.spdyStream.getStreamId()).build();
                this.writeDownStream(dataFrame, completionHandler, isLast);
                this.unconfirmedBytes.addAndGet(dataChunkToSendSize);
                this.releaseWriteQueueSpace(dataChunkToSendSize, isAtomic, outputQueueRecord == null);
                this.outputQueue.doNotify();
            } else if (isAtomic && outputQueueRecord == null) {
                this.releaseWriteQueueSpace(0, true, true);
                this.outputQueue.doNotify();
            }
            if (outputQueueRecord == null) continue;
            this.outputQueue.setCurrentElement((AsyncQueueRecord)outputQueueRecord);
            break;
        }
    }

    public synchronized void writeDownStream(HttpPacket httpPacket, FilterChainContext ctx) throws IOException {
        this.writeDownStream(httpPacket, ctx, null);
    }

    public synchronized void writeDownStream(HttpPacket httpPacket, FilterChainContext ctx, CompletionHandler<WriteResult> completionHandler) throws IOException {
        this.writeDownStream(httpPacket, ctx, completionHandler, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    synchronized <E> void writeDownStream(HttpPacket httpPacket, FilterChainContext ctx, CompletionHandler<WriteResult> completionHandler, MessageCloner<WritableMessage> messageCloner) throws IOException {
        if (this.isTerminated()) {
            throw new IOException(this.terminationFlag.getDescription());
        }
        if (this.isLastFrameQueued) {
            throw new IOException("Write beyond end of stream");
        }
        httpHeader = this.spdyStream.getOutputHttpHeader();
        httpContent = HttpContent.isContent((HttpPacket)httpPacket) != false ? (HttpContent)httpPacket : null;
        framesAvailFlag = 0;
        headerFrame /* !! */  = null;
        outputQueueRecord = null;
        isDeflaterLocked = false;
        try {
            if (!httpHeader.isCommitted()) {
                v0 = isNoContent = httpHeader.isExpectContent() == false || httpContent != null && httpContent.isLast() != false && httpContent.getContent().hasRemaining() == false;
                if (!httpHeader.isRequest()) {
                    if (!this.spdyStream.isUnidirectional()) {
                        compressedHeaders = SpdyEncoderUtils.encodeSynReplyHeadersAndLock(this.spdySession, (HttpResponsePacket)httpHeader);
                        headerFrame /* !! */  = ((SynReplyFrame.SynReplyFrameBuilder)SynReplyFrame.builder().streamId(this.spdyStream.getStreamId()).last(isNoContent).compressedHeaders(compressedHeaders)).build();
                    } else {
                        compressedSynStreamHeaders = SpdyEncoderUtils.encodeUnidirectionalSynStreamHeadersAndLock(this.spdyStream, (SpdyResponse)httpHeader);
                        headerFrame /* !! */  = ((SynStreamFrame.SynStreamFrameBuilder)SynStreamFrame.builder().streamId(this.spdyStream.getStreamId()).associatedStreamId(this.spdyStream.getAssociatedToStreamId()).unidirectional(true).last(isNoContent).compressedHeaders(compressedSynStreamHeaders)).build();
                    }
                } else {
                    compressedHeaders = SpdyEncoderUtils.encodeSynStreamHeadersAndLock(this.spdyStream, (HttpRequestPacket)httpHeader);
                    headerFrame /* !! */  = ((SynStreamFrame.SynStreamFrameBuilder)SynStreamFrame.builder().streamId(this.spdyStream.getStreamId()).associatedStreamId(this.spdyStream.getAssociatedToStreamId()).unidirectional(this.spdyStream.isUnidirectional()).last(isNoContent).compressedHeaders(compressedHeaders)).build();
                    if (ctx != null) {
                        this.spdySession.handlerFilter.onHttpHeadersEncoded(httpHeader, ctx);
                    }
                }
                isDeflaterLocked = true;
                httpHeader.setCommitted(true);
                framesAvailFlag = 1;
                if (isNoContent || httpContent == null) {
                    this.unflushedWritesCounter.incrementAndGet();
                    this.writeDownStream(headerFrame /* !! */ , (CompletionHandler<WriteResult>)new FlushCompletionHandler(completionHandler), messageCloner, isNoContent);
                    return;
                }
            }
            if (httpContent == null) {
                return;
            }
            dataFrame = null;
            isLast = httpContent.isLast();
            data = httpContent.getContent();
            dataSize = data.remaining();
            if (ctx != null) {
                this.spdySession.handlerFilter.onHttpContentEncoded(httpContent, ctx);
            }
            if (isLast && dataSize == 0) {
                this.close();
                return;
            }
            this.unflushedWritesCounter.incrementAndGet();
            flushCompletionHandler = new FlushCompletionHandler(completionHandler);
            isDataCloned = false;
            isAtomic = dataSize == 0;
            v1 = spaceToReserve = isAtomic != false ? 1 : dataSize;
            if (this.reserveWriteQueueSpace(spaceToReserve) > spaceToReserve) {
                if (!SpdyOutputSink.$assertionsDisabled && headerFrame /* !! */  != null) {
                    throw new AssertionError();
                }
                if (messageCloner != null) {
                    data = (Buffer)messageCloner.clone(this.spdySession.getConnection(), (Object)data);
                    isDataCloned = true;
                }
                outputQueueRecord = new OutputQueueRecord(Source.factory(this.spdyStream).createBufferSource(data), flushCompletionHandler, isLast, isAtomic);
                OutputQueueRecord.access$600(outputQueueRecord);
                this.outputQueue.offer((AsyncQueueRecord)outputQueueRecord);
                if (this.outputQueue.size() != spaceToReserve || !this.outputQueue.remove((AsyncQueueRecord)outputQueueRecord)) {
                    return;
                }
                OutputQueueRecord.access$700(outputQueueRecord);
                outputQueueRecord = null;
            }
            if ((fitWindowLen = this.checkOutputWindow(remaining = data.remaining())) < remaining) {
                if (!isDataCloned && messageCloner != null) {
                    data = (Buffer)messageCloner.clone(this.spdySession.getConnection(), (Object)data);
                    isDataCloned = true;
                }
                dataChunkToStore = this.splitOutputBufferIfNeeded(data, fitWindowLen);
                outputQueueRecord = new OutputQueueRecord(Source.factory(this.spdyStream).createBufferSource(dataChunkToStore), flushCompletionHandler, isLast, isAtomic);
                OutputQueueRecord.access$600(outputQueueRecord);
                isLast = false;
            }
            if (data != null && (data.hasRemaining() || isLast)) {
                this.spdyStream.onDataFrameSend();
                dataChunkToSendSize = data.remaining();
                this.unconfirmedBytes.addAndGet(dataChunkToSendSize);
                this.releaseWriteQueueSpace(dataChunkToSendSize, isAtomic, outputQueueRecord == null);
                dataFrame = DataFrame.builder().streamId(this.spdyStream.getStreamId()).data(data).last(isLast).build();
                framesAvailFlag |= 2;
            }
            messageCloner = isDataCloned != false ? null : messageCloner;
            switch (framesAvailFlag) {
                case 0: {
                    ** break;
lbl84:
                    // 1 sources

                    break;
                }
                case 2: {
                    this.writeDownStream(dataFrame, (CompletionHandler<WriteResult>)flushCompletionHandler, messageCloner, isLast);
                    ** break;
lbl88:
                    // 1 sources

                    break;
                }
                case 3: {
                    this.writeDownStream(this.asList(headerFrame /* !! */ , dataFrame), (CompletionHandler<WriteResult>)flushCompletionHandler, messageCloner, isLast);
                    ** break;
lbl92:
                    // 1 sources

                    break;
                }
                default: {
                    throw new IllegalStateException("Unexpected write mode");
                }
            }
        }
        finally {
            if (isDeflaterLocked) {
                this.spdySession.getDeflaterLock().unlock();
            }
        }
        if (outputQueueRecord == null) {
            return;
        }
        this.addOutputQueueRecord(outputQueueRecord);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized void writeDownStream(Source source) throws IOException {
        if (this.isTerminated()) {
            throw new IOException(this.terminationFlag.getDescription());
        }
        if (this.isLastFrameQueued) {
            throw new IOException("Write beyond end of stream");
        }
        this.isLastFrameQueued = true;
        HttpHeader httpHeader = this.spdyStream.getOutputHttpHeader();
        if (httpHeader.isCommitted()) {
            throw new IllegalStateException("Headers have been already commited");
        }
        OutputQueueRecord outputQueueRecord = null;
        boolean isDeflaterLocked = false;
        try {
            Buffer compressedSynStreamHeaders;
            HeadersProviderFrame headerFrame;
            boolean isNoContent;
            boolean bl = isNoContent = !httpHeader.isExpectContent() || source == null || !source.hasRemaining();
            if (!httpHeader.isRequest()) {
                if (!this.spdyStream.isUnidirectional()) {
                    Buffer compressedHeaders = SpdyEncoderUtils.encodeSynReplyHeadersAndLock(this.spdySession, (HttpResponsePacket)httpHeader);
                    headerFrame = ((SynReplyFrame.SynReplyFrameBuilder)SynReplyFrame.builder().streamId(this.spdyStream.getStreamId()).last(isNoContent).compressedHeaders(compressedHeaders)).build();
                } else {
                    compressedSynStreamHeaders = SpdyEncoderUtils.encodeUnidirectionalSynStreamHeadersAndLock(this.spdyStream, (SpdyResponse)httpHeader);
                    headerFrame = ((SynStreamFrame.SynStreamFrameBuilder)SynStreamFrame.builder().streamId(this.spdyStream.getStreamId()).associatedStreamId(this.spdyStream.getAssociatedToStreamId()).unidirectional(true).last(isNoContent).compressedHeaders(compressedSynStreamHeaders)).build();
                }
            } else {
                compressedSynStreamHeaders = SpdyEncoderUtils.encodeSynStreamHeadersAndLock(this.spdyStream, (HttpRequestPacket)httpHeader);
                headerFrame = ((SynStreamFrame.SynStreamFrameBuilder)SynStreamFrame.builder().streamId(this.spdyStream.getStreamId()).associatedStreamId(this.spdyStream.getAssociatedToStreamId()).last(isNoContent).compressedHeaders(compressedSynStreamHeaders)).build();
            }
            isDeflaterLocked = true;
            httpHeader.setCommitted(true);
            if (isNoContent) {
                this.unflushedWritesCounter.incrementAndGet();
                this.writeDownStream(headerFrame, (CompletionHandler<WriteResult>)new FlushCompletionHandler(null), null, isNoContent);
                return;
            }
            long dataSize = source.remaining();
            if (dataSize == 0L) {
                this.close();
                return;
            }
            this.reserveWriteQueueSpace(1);
            boolean isLast = true;
            int fitWindowLen = this.checkOutputWindow(dataSize);
            if ((long)fitWindowLen < dataSize) {
                outputQueueRecord = new OutputQueueRecord(source, null, true, true);
                isLast = false;
            }
            Buffer bufferToSend = source.read(fitWindowLen);
            this.spdyStream.onDataFrameSend();
            int dataChunkToSendSize = bufferToSend.remaining();
            this.unconfirmedBytes.addAndGet(dataChunkToSendSize);
            this.releaseWriteQueueSpace(dataChunkToSendSize, true, outputQueueRecord == null);
            DataFrame dataFrame = DataFrame.builder().streamId(this.spdyStream.getStreamId()).data(bufferToSend).last(isLast).build();
            this.unflushedWritesCounter.incrementAndGet();
            this.writeDownStream(this.asList(headerFrame, dataFrame), (CompletionHandler<WriteResult>)new FlushCompletionHandler(null), null, isLast);
        }
        finally {
            if (isDeflaterLocked) {
                this.spdySession.getDeflaterLock().unlock();
            }
        }
        if (outputQueueRecord == null) {
            return;
        }
        this.addOutputQueueRecord(outputQueueRecord);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flush(CompletionHandler<SpdyStream> completionHandler) {
        if (this.unflushedWritesCounter.get() > 0) {
            Object object = this.flushHandlersSync;
            synchronized (object) {
                int counterNow = this.unflushedWritesCounter.get();
                if (counterNow > 0) {
                    if (this.flushHandlersQueue == null) {
                        this.flushHandlersQueue = new BundleQueue();
                    }
                    this.flushHandlersQueue.add(counterNow, completionHandler);
                    return;
                }
            }
        }
        completionHandler.completed((Object)this.spdyStream);
    }

    private int checkOutputWindow(long size) {
        int windowSizeLimit;
        int unconfirmedBytesNow = this.unconfirmedBytes.get();
        if ((long)unconfirmedBytesNow + size > (long)(windowSizeLimit = this.spdyStream.getPeerWindowSize())) {
            int dataSizeAllowedToSend = windowSizeLimit - unconfirmedBytesNow;
            return dataSizeAllowedToSend;
        }
        return (int)size;
    }

    private Buffer splitOutputBufferIfNeeded(Buffer buffer, int length) {
        if (length == buffer.remaining()) {
            return null;
        }
        return buffer.split(buffer.position() + length);
    }

    void writeWindowUpdate(int currentUnackedBytes) {
        WindowUpdateFrame frame = WindowUpdateFrame.builder().streamId(this.spdyStream.getStreamId()).delta(currentUnackedBytes).build();
        this.writeDownStream0(frame, null);
    }

    private void writeDownStream(SpdyFrame frame, CompletionHandler<WriteResult> completionHandler, boolean isLast) {
        this.writeDownStream(frame, completionHandler, null, isLast);
    }

    private void writeDownStream(SpdyFrame frame, CompletionHandler<WriteResult> completionHandler, MessageCloner messageCloner, boolean isLast) {
        this.writeDownStream0(frame, completionHandler, messageCloner);
        if (isLast) {
            this.terminate(Constants.OUT_FIN_TERMINATION);
        }
    }

    private void writeDownStream0(SpdyFrame frame, CompletionHandler<WriteResult> completionHandler, MessageCloner messageCloner) {
        this.spdySession.getDownstreamChain().write(this.spdySession.getConnection(), null, (Object)frame, completionHandler, messageCloner);
    }

    private void writeDownStream0(SpdyFrame frame, CompletionHandler<WriteResult> completionHandler) {
        this.spdySession.getDownstreamChain().write(this.spdySession.getConnection(), null, (Object)frame, completionHandler, (MessageCloner)null);
    }

    private void writeDownStream(List<SpdyFrame> frames, CompletionHandler<WriteResult> completionHandler, MessageCloner messageCloner, boolean isLast) {
        this.writeDownStream0(frames, completionHandler, messageCloner);
        if (isLast) {
            this.terminate(Constants.OUT_FIN_TERMINATION);
        }
    }

    private void writeDownStream0(List<SpdyFrame> frames, CompletionHandler<WriteResult> completionHandler, MessageCloner messageCloner) {
        this.spdySession.getDownstreamChain().write(this.spdySession.getConnection(), null, frames, completionHandler, messageCloner);
    }

    private List<SpdyFrame> asList(SpdyFrame frame1, SpdyFrame frame2) {
        if (this.tmpOutputList == null) {
            this.tmpOutputList = new ArrayList<SpdyFrame>(4);
        }
        this.tmpOutputList.add(frame1);
        this.tmpOutputList.add(frame2);
        return this.tmpOutputList;
    }

    synchronized void close() {
        if (!this.isClosed()) {
            this.isLastFrameQueued = true;
            if (this.outputQueue.isEmpty()) {
                this.writeEmptyFin();
                return;
            }
            this.outputQueue.reserveSpace(1);
            this.outputQueue.offer((AsyncQueueRecord)TERMINATING_QUEUE_RECORD);
            if (this.outputQueue.size() == 1 && this.outputQueue.remove((AsyncQueueRecord)TERMINATING_QUEUE_RECORD)) {
                this.writeEmptyFin();
            }
        }
    }

    synchronized void terminate(SpdyStream.Termination terminationFlag) {
        if (!this.isTerminated()) {
            this.terminationFlag = terminationFlag;
            this.outputQueue.onClose();
            this.spdyStream.onOutputClosed();
        }
    }

    boolean isClosed() {
        return this.isLastFrameQueued || this.isTerminated();
    }

    private boolean isTerminated() {
        return this.terminationFlag != null;
    }

    private void writeEmptyFin() {
        if (!this.isTerminated()) {
            DataFrame dataFrame = DataFrame.builder().streamId(this.spdyStream.getStreamId()).data(Buffers.EMPTY_BUFFER).last(true).build();
            this.unflushedWritesCounter.incrementAndGet();
            this.writeDownStream0(dataFrame, new FlushCompletionHandler(null));
            this.terminate(Constants.OUT_FIN_TERMINATION);
        }
    }

    private boolean isWantToWrite(int unconfirmedBytesNow, int windowSizeLimit) {
        return unconfirmedBytesNow < windowSizeLimit * 3 / 4;
    }

    private void addOutputQueueRecord(OutputQueueRecord outputQueueRecord) throws SpdyStreamException {
        do {
            this.outputQueue.setCurrentElement((AsyncQueueRecord)outputQueueRecord);
            int unconfirmedBytesNow = this.unconfirmedBytes.get();
            int windowSizeLimit = this.spdyStream.getPeerWindowSize();
            if (!this.isWantToWrite(unconfirmedBytesNow, windowSizeLimit) || !this.outputQueue.compareAndSetCurrentElement((AsyncQueueRecord)outputQueueRecord, null)) break;
            FlushCompletionHandler aggrCompletionHandler = outputQueueRecord.aggrCompletionHandler;
            boolean isLast = outputQueueRecord.isLast;
            boolean isAtomic = outputQueueRecord.isAtomic;
            Source currentResource = outputQueueRecord.resource;
            int fitWindowLen = this.checkOutputWindow(currentResource.remaining());
            Buffer dataChunkToSend = currentResource.read(fitWindowLen);
            if (currentResource.hasRemaining()) {
                outputQueueRecord.reset(currentResource, aggrCompletionHandler, isLast);
                outputQueueRecord.incCompletionCounter();
                isLast = false;
            } else {
                outputQueueRecord.release();
                outputQueueRecord = null;
            }
            if (dataChunkToSend != null && (dataChunkToSend.hasRemaining() || isLast)) {
                int dataChunkToSendSize = dataChunkToSend.remaining();
                DataFrame frame = DataFrame.builder().streamId(this.spdyStream.getStreamId()).data(dataChunkToSend).last(isLast).build();
                this.writeDownStream(frame, aggrCompletionHandler, isLast);
                this.unconfirmedBytes.addAndGet(dataChunkToSendSize);
                this.releaseWriteQueueSpace(dataChunkToSendSize, isAtomic, outputQueueRecord == null);
                continue;
            }
            if (!isAtomic || outputQueueRecord != null) continue;
            this.releaseWriteQueueSpace(0, true, true);
        } while (outputQueueRecord != null);
    }

    private int reserveWriteQueueSpace(int spaceToReserve) {
        return this.outputQueue.reserveSpace(spaceToReserve);
    }

    private void releaseWriteQueueSpace(int justSentBytes, boolean isAtomic, boolean isEndOfChunk) {
        if (isEndOfChunk) {
            this.outputQueue.releaseSpace(isAtomic ? 1 : justSentBytes);
        } else if (!isAtomic) {
            this.outputQueue.releaseSpace(justSentBytes);
        }
    }

    private class FlushCompletionHandler
    implements CompletionHandler<WriteResult> {
        private final CompletionHandler<WriteResult> parentCompletionHandler;
        private boolean isDone;
        private int counter = 1;
        private long writtenSize;

        public FlushCompletionHandler(CompletionHandler<WriteResult> parentCompletionHandler) {
            this.parentCompletionHandler = parentCompletionHandler;
        }

        public void cancelled() {
            if (this.done() && this.parentCompletionHandler != null) {
                this.parentCompletionHandler.cancelled();
            }
        }

        public void failed(Throwable throwable) {
            if (this.done() && this.parentCompletionHandler != null) {
                this.parentCompletionHandler.failed(throwable);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void completed(WriteResult result) {
            if (this.isDone) {
                return;
            }
            if (--this.counter == 0) {
                this.done();
                long initialWrittenSize = result.getWrittenSize();
                this.writtenSize += initialWrittenSize;
                if (this.parentCompletionHandler != null) {
                    try {
                        result.setWrittenSize(this.writtenSize);
                        this.parentCompletionHandler.completed((Object)result);
                    }
                    finally {
                        result.setWrittenSize(initialWrittenSize);
                    }
                }
            } else {
                this.updated(result);
                this.writtenSize += result.getWrittenSize();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void updated(WriteResult result) {
            if (this.parentCompletionHandler != null) {
                long initialWrittenSize = result.getWrittenSize();
                try {
                    result.setWrittenSize(this.writtenSize + initialWrittenSize);
                    this.parentCompletionHandler.updated((Object)result);
                }
                finally {
                    result.setWrittenSize(initialWrittenSize);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean done() {
            boolean hasNext;
            if (this.isDone) {
                return false;
            }
            this.isDone = true;
            Object object = SpdyOutputSink.this.flushHandlersSync;
            synchronized (object) {
                SpdyOutputSink.this.unflushedWritesCounter.decrementAndGet();
                if (SpdyOutputSink.this.flushHandlersQueue == null || !SpdyOutputSink.this.flushHandlersQueue.nextBundle()) {
                    return true;
                }
            }
            do {
                CompletionHandler handler;
                Object object2 = SpdyOutputSink.this.flushHandlersSync;
                synchronized (object2) {
                    handler = (CompletionHandler)SpdyOutputSink.this.flushHandlersQueue.next();
                    hasNext = SpdyOutputSink.this.flushHandlersQueue.hasNext();
                }
                try {
                    handler.completed((Object)SpdyOutputSink.this.spdyStream);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            } while (hasNext);
            return true;
        }
    }

    private static class OutputQueueRecord
    extends AsyncQueueRecord<WriteResult> {
        private Source resource;
        private FlushCompletionHandler aggrCompletionHandler;
        private boolean isLast;
        private final boolean isAtomic;

        public OutputQueueRecord(Source resource, FlushCompletionHandler completionHandler, boolean isLast, boolean isAtomic) {
            super(null, null, null, null);
            this.resource = resource;
            this.aggrCompletionHandler = completionHandler;
            this.isLast = isLast;
            this.isAtomic = isAtomic;
        }

        private void incCompletionCounter() {
            if (this.aggrCompletionHandler != null) {
                this.aggrCompletionHandler.counter++;
            }
        }

        private void decCompletionCounter() {
            if (this.aggrCompletionHandler != null) {
                this.aggrCompletionHandler.counter--;
            }
        }

        private void reset(Source resource, FlushCompletionHandler completionHandler, boolean last) {
            this.resource = resource;
            this.completionHandler = completionHandler;
            this.isLast = last;
        }

        public void release() {
            if (this.resource != null) {
                this.resource.release();
                this.resource = null;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void notifyFailure(Throwable e) {
            FlushCompletionHandler chLocal = this.aggrCompletionHandler;
            this.aggrCompletionHandler = null;
            try {
                if (chLocal != null) {
                    chLocal.failed(e);
                }
            }
            finally {
                this.release();
            }
        }

        public void recycle() {
        }

        static /* synthetic */ void access$700(OutputQueueRecord x0) {
            x0.decCompletionCounter();
        }
    }
}

