/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.grizzly.spdy;

import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import org.glassfish.grizzly.Buffer;
import org.glassfish.grizzly.CloseListener;
import org.glassfish.grizzly.CloseType;
import org.glassfish.grizzly.Closeable;
import org.glassfish.grizzly.CompletionHandler;
import org.glassfish.grizzly.GrizzlyFuture;
import org.glassfish.grizzly.ICloseType;
import org.glassfish.grizzly.OutputSink;
import org.glassfish.grizzly.WriteHandler;
import org.glassfish.grizzly.WriteResult;
import org.glassfish.grizzly.asyncqueue.MessageCloner;
import org.glassfish.grizzly.asyncqueue.TaskQueue;
import org.glassfish.grizzly.asyncqueue.WritableMessage;
import org.glassfish.grizzly.attributes.Attribute;
import org.glassfish.grizzly.attributes.AttributeBuilder;
import org.glassfish.grizzly.attributes.AttributeHolder;
import org.glassfish.grizzly.attributes.AttributeStorage;
import org.glassfish.grizzly.attributes.IndexedAttributeHolder;
import org.glassfish.grizzly.filterchain.FilterChainContext;
import org.glassfish.grizzly.http.HttpContent;
import org.glassfish.grizzly.http.HttpHeader;
import org.glassfish.grizzly.http.HttpPacket;
import org.glassfish.grizzly.http.HttpRequestPacket;
import org.glassfish.grizzly.http.HttpResponsePacket;
import org.glassfish.grizzly.impl.FutureImpl;
import org.glassfish.grizzly.memory.Buffers;
import org.glassfish.grizzly.memory.CompositeBuffer;
import org.glassfish.grizzly.memory.MemoryManager;
import org.glassfish.grizzly.spdy.Constants;
import org.glassfish.grizzly.spdy.PushResource;
import org.glassfish.grizzly.spdy.Source;
import org.glassfish.grizzly.spdy.SpdyInputBuffer;
import org.glassfish.grizzly.spdy.SpdyOutputSink;
import org.glassfish.grizzly.spdy.SpdySession;
import org.glassfish.grizzly.spdy.SpdyStreamException;
import org.glassfish.grizzly.utils.DataStructures;
import org.glassfish.grizzly.utils.Futures;

public class SpdyStream
implements AttributeStorage,
OutputSink,
Closeable {
    public static final String SPDY_STREAM_ATTRIBUTE = SpdyStream.class.getName();
    private static final Attribute<SpdyStream> HTTP_RQST_SPDY_STREAM_ATTR = AttributeBuilder.DEFAULT_ATTRIBUTE_BUILDER.createAttribute("http.request.spdy.stream");
    private final HttpRequestPacket spdyRequest;
    private final int streamId;
    private final int associatedToStreamId;
    private final int priority;
    private final int slot;
    private final boolean isUnidirectional;
    private final SpdySession spdySession;
    private volatile int peerWindowSize = -1;
    private volatile int localWindowSize = -1;
    private final AttributeHolder attributes = new IndexedAttributeHolder(AttributeBuilder.DEFAULT_ATTRIBUTE_BUILDER);
    final SpdyInputBuffer inputBuffer;
    final SpdyOutputSink outputSink;
    final AtomicReference<CloseType> closeTypeFlag = new AtomicReference();
    private final Queue<CloseListener> closeListeners = new ConcurrentLinkedQueue<CloseListener>();
    private final AtomicInteger completeFinalizationCounter = new AtomicInteger();
    volatile boolean isProcessingComplete;
    private boolean isSynFrameRcv;
    private Map<String, PushResource> associatedResourcesToPush;
    private Set<SpdyStream> associatedSpdyStreams;
    private Buffer cachedInputBuffer;
    private boolean cachedIsLast;

    public static SpdyStream getSpdyStream(HttpHeader httpHeader) {
        HttpRequestPacket request;
        if (httpHeader.isRequest()) {
            assert (httpHeader instanceof HttpRequestPacket);
            request = (HttpRequestPacket)httpHeader;
        } else {
            assert (httpHeader instanceof HttpResponsePacket);
            request = ((HttpResponsePacket)httpHeader).getRequest();
        }
        if (request != null) {
            return (SpdyStream)HTTP_RQST_SPDY_STREAM_ATTR.get((AttributeStorage)request);
        }
        return null;
    }

    static SpdyStream create(SpdySession spdySession, HttpRequestPacket spdyRequest, int streamId, int associatedToStreamId, int priority, int slot, boolean isUnidirectional) {
        SpdyStream spdyStream = new SpdyStream(spdySession, spdyRequest, streamId, associatedToStreamId, priority, slot, isUnidirectional);
        HTTP_RQST_SPDY_STREAM_ATTR.set((AttributeStorage)spdyRequest, (Object)spdyStream);
        return spdyStream;
    }

    private SpdyStream(SpdySession spdySession, HttpRequestPacket spdyRequest, int streamId, int associatedToStreamId, int priority, int slot, boolean isUnidirectional) {
        this.spdySession = spdySession;
        this.spdyRequest = spdyRequest;
        this.streamId = streamId;
        this.associatedToStreamId = associatedToStreamId;
        this.priority = priority;
        this.slot = slot;
        this.isUnidirectional = isUnidirectional;
        this.inputBuffer = new SpdyInputBuffer(this);
        this.outputSink = new SpdyOutputSink(this);
    }

    SpdySession getSpdySession() {
        return this.spdySession;
    }

    public int getPeerWindowSize() {
        return this.peerWindowSize != -1 ? this.peerWindowSize : this.spdySession.getPeerInitialWindowSize();
    }

    public int getLocalWindowSize() {
        return this.localWindowSize != -1 ? this.localWindowSize : this.spdySession.getLocalInitialWindowSize();
    }

    public HttpRequestPacket getSpdyRequest() {
        return this.spdyRequest;
    }

    public HttpResponsePacket getSpdyResponse() {
        return this.spdyRequest.getResponse();
    }

    public PushResource addPushResource(String url, PushResource pushResource) {
        if (this.associatedResourcesToPush == null) {
            this.associatedResourcesToPush = new HashMap<String, PushResource>();
        }
        return this.associatedResourcesToPush.put(url, pushResource);
    }

    public PushResource removePushResource(String url) {
        if (this.associatedResourcesToPush == null) {
            return null;
        }
        return this.associatedResourcesToPush.remove(url);
    }

    public int getStreamId() {
        return this.streamId;
    }

    public int getAssociatedToStreamId() {
        return this.associatedToStreamId;
    }

    public int getPriority() {
        return this.priority;
    }

    public int getSlot() {
        return this.slot;
    }

    public boolean isUnidirectional() {
        return this.isUnidirectional;
    }

    public boolean isLocallyInitiatedStream() {
        assert (this.streamId > 0);
        return this.spdySession.isServer() ^ this.streamId % 2 != 0;
    }

    public boolean isClosed() {
        return this.completeFinalizationCounter.get() >= 2;
    }

    public AttributeHolder getAttributes() {
        return this.attributes;
    }

    public void notifyCanWrite(WriteHandler handler, int length) {
    }

    public boolean canWrite(int length) {
        return this.canWrite();
    }

    public boolean canWrite() {
        int peerWindowSizeNow = this.getPeerWindowSize();
        if (peerWindowSizeNow < 0) {
            return true;
        }
        TaskQueue<SpdyOutputSink.OutputQueueRecord> taskQueue = this.outputSink.outputQueue;
        int size = taskQueue.size();
        return size == 0 || size < peerWindowSizeNow;
    }

    public void notifyCanWrite(WriteHandler writeHandler) {
        this.outputSink.outputQueue.notifyWritePossible(writeHandler, this.getPeerWindowSize());
    }

    void onPeerWindowUpdate(int delta) throws SpdyStreamException {
        this.outputSink.onPeerWindowUpdate(delta);
    }

    void writeDownStream(HttpPacket httpPacket) throws IOException {
        this.outputSink.writeDownStream(httpPacket, null);
    }

    void writeDownStream(Source resource) throws IOException {
        this.outputSink.writeDownStream(resource);
    }

    void writeDownStream(HttpPacket httpPacket, FilterChainContext ctx, CompletionHandler<WriteResult> completionHandler) throws IOException {
        this.outputSink.writeDownStream(httpPacket, ctx, completionHandler);
    }

    void writeDownStream(HttpPacket httpPacket, FilterChainContext ctx, CompletionHandler<WriteResult> completionHandler, MessageCloner messageCloner) throws IOException {
        this.outputSink.writeDownStream(httpPacket, ctx, completionHandler, (MessageCloner<WritableMessage>)messageCloner);
    }

    public GrizzlyFuture<Closeable> close() {
        FutureImpl future = Futures.createSafeFuture();
        this.close((CompletionHandler<Closeable>)Futures.toCompletionHandler((FutureImpl)future));
        return future;
    }

    public void close(CompletionHandler<Closeable> completionHandler) {
        this.close(completionHandler, true);
    }

    void close(CompletionHandler<Closeable> completionHandler, boolean isClosedLocally) {
        if (this.closeTypeFlag.compareAndSet(null, isClosedLocally ? CloseType.LOCALLY : CloseType.REMOTELY)) {
            Termination termination = isClosedLocally ? Constants.LOCAL_CLOSE_TERMINATION : Constants.PEER_CLOSE_TERMINATION;
            this.inputBuffer.terminate(termination);
            this.outputSink.terminate(termination);
            this.notifyCloseListeners();
            if (completionHandler != null) {
                completionHandler.completed((Object)this);
            }
        }
    }

    void closedRemotely() {
        if (this.closeTypeFlag.compareAndSet(null, CloseType.REMOTELY)) {
            this.inputBuffer.close(new Termination(TerminationType.PEER_CLOSE, "Closed by peer"){

                @Override
                public void doTask() {
                    SpdyStream.this.close(null, false);
                }
            });
        }
    }

    void resetRemotely() {
        if (this.closeTypeFlag.compareAndSet(null, CloseType.REMOTELY)) {
            this.inputBuffer.close(Constants.RESET_TERMINATION);
            this.outputSink.terminate(Constants.RESET_TERMINATION);
        }
        this.rstAssociatedStreams();
    }

    void onProcessingComplete() {
        this.isProcessingComplete = true;
        if (this.closeTypeFlag.compareAndSet(null, CloseType.LOCALLY)) {
            Termination termination = Constants.LOCAL_CLOSE_TERMINATION;
            this.inputBuffer.terminate(termination);
            this.outputSink.close();
            this.notifyCloseListeners();
        }
    }

    public void addCloseListener(CloseListener closeListener) {
        CloseType closeType = this.closeTypeFlag.get();
        if (closeType == null) {
            this.closeListeners.add(closeListener);
            closeType = this.closeTypeFlag.get();
            if (closeType != null && this.closeListeners.remove(closeListener)) {
                try {
                    closeListener.onClosed((Closeable)this, (ICloseType)closeType);
                }
                catch (IOException ignored) {}
            }
        } else {
            try {
                closeListener.onClosed((Closeable)this, (ICloseType)closeType);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public boolean removeCloseListener(CloseListener closeListener) {
        return this.closeListeners.remove(closeListener);
    }

    void onInputClosed() {
        if (this.completeFinalizationCounter.incrementAndGet() == 2) {
            this.closeStream();
        }
    }

    void onOutputClosed() {
        if (this.completeFinalizationCounter.incrementAndGet() == 2) {
            this.closeStream();
        }
    }

    void onDataFrameReceive() {
        if (this.peerWindowSize == -1) {
            this.peerWindowSize = this.spdySession.getPeerInitialWindowSize();
        }
    }

    void onDataFrameSend() {
        if (this.localWindowSize == -1) {
            this.localWindowSize = this.spdySession.getLocalInitialWindowSize();
        }
    }

    void onSynFrameRcv() throws SpdyStreamException {
        if (this.isSynFrameRcv) {
            this.inputBuffer.close(Constants.UNEXPECTED_FRAME_TERMINATION);
            throw new SpdyStreamException(this.getStreamId(), 1, "Only one syn frame is allowed");
        }
        this.isSynFrameRcv = true;
    }

    void offerInputData(Buffer data, boolean isLast) throws SpdyStreamException {
        if (!this.isSynFrameRcv) {
            this.close(null, true);
            throw new SpdyStreamException(this.getStreamId(), 1, "DataFrame came before SynReply");
        }
        this.onDataFrameReceive();
        boolean isFirstBufferCached = this.cachedInputBuffer == null;
        this.cachedIsLast |= isLast;
        this.cachedInputBuffer = Buffers.appendBuffers((MemoryManager)this.spdySession.getMemoryManager(), (Buffer)this.cachedInputBuffer, (Buffer)data);
        if (isFirstBufferCached) {
            this.spdySession.streamsToFlushInput.add(this);
        }
    }

    void flushInputData() {
        Buffer cachedInputBufferLocal = this.cachedInputBuffer;
        boolean cachedIsLastLocal = this.cachedIsLast;
        this.cachedInputBuffer = null;
        this.cachedIsLast = false;
        if (cachedInputBufferLocal != null) {
            if (cachedInputBufferLocal.isComposite()) {
                ((CompositeBuffer)cachedInputBufferLocal).allowInternalBuffersDispose(true);
                ((CompositeBuffer)cachedInputBufferLocal).allowBufferDispose(true);
                ((CompositeBuffer)cachedInputBufferLocal).disposeOrder(CompositeBuffer.DisposeOrder.LAST_TO_FIRST);
            }
            this.inputBuffer.offer(cachedInputBufferLocal, cachedIsLastLocal);
        }
    }

    HttpContent pollInputData() throws IOException {
        return this.inputBuffer.poll();
    }

    private void closeStream() {
        this.spdySession.deregisterStream(this);
    }

    HttpHeader getInputHttpHeader() {
        return this.isLocallyInitiatedStream() ^ this.isUnidirectional() ? this.spdyRequest.getResponse() : this.spdyRequest;
    }

    HttpHeader getOutputHttpHeader() {
        return !this.isLocallyInitiatedStream() ^ this.isUnidirectional() ? this.spdyRequest.getResponse() : this.spdyRequest;
    }

    final Map<String, PushResource> getAssociatedResourcesToPush() {
        return this.associatedResourcesToPush;
    }

    final void addAssociatedStream(SpdyStream spdyStream) throws SpdyStreamException {
        if (this.associatedSpdyStreams == null) {
            this.associatedSpdyStreams = Collections.newSetFromMap(DataStructures.getConcurrentMap((int)8));
        }
        this.associatedSpdyStreams.add(spdyStream);
        if (this.isClosed() && this.associatedSpdyStreams.remove(spdyStream)) {
            throw new SpdyStreamException(spdyStream.getStreamId(), 3, "The parent stream is closed");
        }
    }

    final void rstAssociatedStreams() {
        if (this.associatedSpdyStreams != null) {
            Iterator<SpdyStream> it = this.associatedSpdyStreams.iterator();
            while (it.hasNext()) {
                SpdyStream associatedStream = it.next();
                it.remove();
                try {
                    associatedStream.resetRemotely();
                }
                catch (Exception exception) {}
            }
        }
    }

    private void notifyCloseListeners() {
        CloseListener closeListener;
        CloseType closeType = this.closeTypeFlag.get();
        while ((closeListener = this.closeListeners.poll()) != null) {
            try {
                closeListener.onClosed((Closeable)this, (ICloseType)closeType);
            }
            catch (IOException iOException) {}
        }
    }

    protected static class Termination {
        private final TerminationType type;
        private final String description;

        public Termination(TerminationType type, String description) {
            this.type = type;
            this.description = description;
        }

        public TerminationType getType() {
            return this.type;
        }

        public String getDescription() {
            return this.description;
        }

        public void doTask() {
        }
    }

    protected static enum TerminationType {
        FIN,
        RST,
        LOCAL_CLOSE,
        PEER_CLOSE,
        FORCED;

    }

    private static enum CompletionUnit {
        Input,
        Output,
        Complete;

    }
}

