/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.grizzly.spdy.frames;

import org.glassfish.grizzly.Buffer;
import org.glassfish.grizzly.ThreadCache;
import org.glassfish.grizzly.memory.MemoryManager;
import org.glassfish.grizzly.spdy.frames.SpdyFrame;
import org.glassfish.grizzly.spdy.frames.SpdyHeader;

public class GoAwayFrame
extends SpdyFrame {
    public static final int OK_STATUS = 0;
    public static final int PROTOCOL_ERROR_STATUS = 1;
    public static final int INTERNAL_ERROR_STATUS = 11;
    private static final ThreadCache.CachedTypeIndex<GoAwayFrame> CACHE_IDX = ThreadCache.obtainIndex(GoAwayFrame.class, (int)8);
    public static final int TYPE = 7;
    private int lastGoodStreamId;
    private int statusCode;

    private GoAwayFrame() {
    }

    static GoAwayFrame create() {
        GoAwayFrame frame = (GoAwayFrame)ThreadCache.takeFromCache(CACHE_IDX);
        if (frame == null) {
            frame = new GoAwayFrame();
        }
        return frame;
    }

    static GoAwayFrame create(SpdyHeader header) {
        GoAwayFrame frame = GoAwayFrame.create();
        frame.initialize(header);
        return frame;
    }

    public static GoAwayFrameBuilder builder() {
        return new GoAwayFrameBuilder();
    }

    public int getLastGoodStreamId() {
        return this.lastGoodStreamId;
    }

    public int getStatusCode() {
        return this.statusCode;
    }

    @Override
    public boolean isFlagSet(byte flag) {
        return false;
    }

    @Override
    public void setFlag(byte flag) {
    }

    @Override
    public void clearFlag(byte flag) {
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("GoAwayFrame");
        sb.append("{lastGoodStreamId=").append(this.lastGoodStreamId);
        sb.append(", statusCode=").append(this.statusCode);
        sb.append('}');
        return sb.toString();
    }

    @Override
    public Buffer toBuffer(MemoryManager memoryManager) {
        Buffer buffer = memoryManager.allocate(16);
        buffer.putInt(-2147287033);
        buffer.putInt(8);
        buffer.putInt(this.lastGoodStreamId & Integer.MAX_VALUE);
        buffer.putInt(this.statusCode);
        buffer.trim();
        return buffer;
    }

    @Override
    public void recycle() {
        this.statusCode = 0;
        this.lastGoodStreamId = 0;
        super.recycle();
        ThreadCache.putToCache(CACHE_IDX, (Object)this);
    }

    @Override
    protected void initialize(SpdyHeader header) {
        super.initialize(header);
        this.lastGoodStreamId = header.buffer.getInt() & Integer.MAX_VALUE;
        if (header.buffer.hasRemaining()) {
            this.statusCode = header.buffer.getInt();
        }
        header.buffer.dispose();
    }

    public static class GoAwayFrameBuilder
    extends SpdyFrame.SpdyFrameBuilder<GoAwayFrameBuilder> {
        private GoAwayFrame goAwayFrame;

        protected GoAwayFrameBuilder() {
            super(GoAwayFrame.create());
            this.goAwayFrame = (GoAwayFrame)this.frame;
        }

        public GoAwayFrameBuilder statusCode(int statusCode) {
            this.goAwayFrame.statusCode = statusCode;
            return this;
        }

        public GoAwayFrameBuilder lastGoodStreamId(int lastGoodStreamId) {
            this.goAwayFrame.lastGoodStreamId = lastGoodStreamId;
            return this;
        }

        public GoAwayFrame build() {
            return this.goAwayFrame;
        }

        @Override
        protected GoAwayFrameBuilder getThis() {
            return this;
        }
    }
}

