/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.grizzly.spdy.frames;

import org.glassfish.grizzly.Buffer;
import org.glassfish.grizzly.ThreadCache;
import org.glassfish.grizzly.memory.MemoryManager;
import org.glassfish.grizzly.spdy.frames.SpdyFrame;
import org.glassfish.grizzly.spdy.frames.SpdyHeader;

public class PingFrame
extends SpdyFrame {
    private static final ThreadCache.CachedTypeIndex<PingFrame> CACHE_IDX = ThreadCache.obtainIndex(PingFrame.class, (int)8);
    public static final int TYPE = 6;
    private int pingId;

    private PingFrame() {
    }

    static PingFrame create() {
        PingFrame frame = (PingFrame)ThreadCache.takeFromCache(CACHE_IDX);
        if (frame == null) {
            frame = new PingFrame();
        }
        return frame;
    }

    static PingFrame create(SpdyHeader header) {
        PingFrame frame = PingFrame.create();
        frame.initialize(header);
        return frame;
    }

    public static PingFrameBuilder builder() {
        return new PingFrameBuilder();
    }

    public int getPingId() {
        return this.pingId;
    }

    @Override
    public boolean isFlagSet(byte flag) {
        return false;
    }

    @Override
    public void setFlag(byte flag) {
    }

    @Override
    public void clearFlag(byte flag) {
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("PingFrame");
        sb.append("{pingId=").append(this.pingId);
        sb.append('}');
        return sb.toString();
    }

    @Override
    public void recycle() {
        this.pingId = 0;
        super.recycle();
        ThreadCache.putToCache(CACHE_IDX, (Object)this);
    }

    @Override
    public Buffer toBuffer(MemoryManager memoryManager) {
        Buffer frameBuffer = memoryManager.allocate(12);
        frameBuffer.putInt(-2147287034);
        frameBuffer.putInt(4);
        frameBuffer.putInt(this.pingId);
        frameBuffer.trim();
        return frameBuffer;
    }

    @Override
    protected void initialize(SpdyHeader header) {
        super.initialize(header);
        this.pingId = header.buffer.getInt();
    }

    public static class PingFrameBuilder
    extends SpdyFrame.SpdyFrameBuilder<PingFrameBuilder> {
        private PingFrame pingFrame;

        protected PingFrameBuilder() {
            super(PingFrame.create());
            this.pingFrame = (PingFrame)this.frame;
        }

        public PingFrameBuilder pingId(int pingId) {
            this.pingFrame.pingId = pingId;
            return this;
        }

        public PingFrame build() {
            return this.pingFrame;
        }

        @Override
        protected PingFrameBuilder getThis() {
            return this;
        }
    }
}

