/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools;

import com.sun.enterprise.tools.Messager;
import com.sun.hk2.component.InhabitantParser;
import com.sun.hk2.component.InhabitantsScanner;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import org.jvnet.hk2.component.MultiMap;

public class InhabitantsDescriptor
extends HashMap<String, String> {
    private boolean dirty = false;
    private boolean dateEnabled = true;
    private boolean commentEnabled = true;
    private String comment;

    public InhabitantsDescriptor() {
    }

    public InhabitantsDescriptor(File f) throws IOException {
        this.load(f);
    }

    public void enableDateOutput(boolean enabled) {
        this.dateEnabled = enabled;
    }

    public void enableCommentOutput(boolean enabled) {
        this.commentEnabled = enabled;
    }

    public void setComment(String comment) {
        this.comment = null == comment ? comment : "# " + comment;
    }

    public void appendComment(String comment) {
        if (null == this.comment) {
            this.setComment(comment);
        } else {
            this.comment = this.comment + "\n# " + comment;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void load(File f) throws IOException {
        FileInputStream in = new FileInputStream(f);
        try {
            InhabitantsScanner scanner = new InhabitantsScanner((InputStream)in, f.getPath());
            for (InhabitantParser kvpp : scanner) {
                this.put(kvpp.getImplName(), kvpp.getLine());
            }
        }
        finally {
            if (null != in) {
                in.close();
            }
        }
    }

    @Override
    public String put(String key, String value) {
        this.dirty = true;
        return super.put(key, value);
    }

    public String putAll(String service, Collection<String> contracts, Collection<String> annotations, String name, Object metaObj) {
        StringBuilder buf;
        block8: {
            Map meta;
            block7: {
                buf = new StringBuilder();
                buf.append("class").append('=').append(service);
                if (null != contracts) {
                    for (String contract : contracts) {
                        buf.append(",").append("index").append("=").append(contract);
                        if (null == name) continue;
                        buf.append(":").append(name);
                    }
                }
                if (null != annotations) {
                    for (String contract : annotations) {
                        buf.append(",").append("index").append("=").append(contract);
                    }
                }
                if (!(metaObj instanceof Map)) break block7;
                meta = (Map)metaObj;
                for (Map.Entry entry : meta.entrySet()) {
                    buf.append(",").append((String)entry.getKey()).append("=").append((String)entry.getValue());
                }
                break block8;
            }
            if (!(metaObj instanceof MultiMap)) break block8;
            meta = (MultiMap)metaObj;
            for (Map.Entry entry : meta.entrySet()) {
                String key = (String)entry.getKey();
                List vals = (List)entry.getValue();
                for (String val : vals) {
                    buf.append(",").append(key).append("=").append(val);
                }
            }
        }
        return this.put(service, buf.toString());
    }

    @Override
    public String remove(Object key) {
        this.dirty = true;
        return (String)super.remove(key);
    }

    public void write(File outputDir, Messager messager, String habitatName) {
        File out = new File(new File(outputDir, "META-INF/inhabitants"), habitatName);
        if (!this.dirty) {
            if (out.exists()) {
                out.delete();
            }
            return;
        }
        try {
            this.write(out);
        }
        catch (IOException e) {
            if (null == messager) {
                Logger.getAnonymousLogger().warning("Failed to write inhabitants file " + habitatName);
            }
            messager.printError("Failed to write inhabitants file " + habitatName, e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(File out) throws IOException {
        File parent = out.getParentFile();
        if (null != parent) {
            parent.mkdirs();
        }
        PrintWriter w = new PrintWriter(out, "UTF-8");
        try {
            this.write(w);
        }
        finally {
            w.close();
        }
    }

    public void write(PrintWriter w) {
        if (this.dateEnabled) {
            w.println("# generated on " + new Date().toGMTString());
        }
        if (this.commentEnabled && null != this.comment) {
            w.println(this.comment);
        }
        for (String line : this.values()) {
            w.println(line);
        }
    }

    @Override
    public String toString() {
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        PrintWriter w = new PrintWriter(os);
        this.write(w);
        w.close();
        return os.toString();
    }
}

