/*
 * Decompiled with CFR 0.152.
 */
package org.hamcrest.junit;

import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.StringDescription;
import org.hamcrest.junit.ExpectedExceptionMatcherBuilder;
import org.hamcrest.junit.MatcherAssert;
import org.hamcrest.junit.internal.ThrowableCauseMatcher;
import org.hamcrest.junit.internal.ThrowableMessageMatcher;
import org.junit.Assert;
import org.junit.internal.AssumptionViolatedException;
import org.junit.rules.TestRule;
import org.junit.runner.Description;
import org.junit.runners.model.Statement;

public class ExpectedException
implements TestRule {
    private final ExpectedExceptionMatcherBuilder fMatcherBuilder = new ExpectedExceptionMatcherBuilder();
    private boolean handleAssumptionViolatedExceptions = false;
    private boolean handleAssertionErrors = false;

    public static ExpectedException none() {
        return new ExpectedException();
    }

    private ExpectedException() {
    }

    public ExpectedException handleAssertionErrors() {
        this.handleAssertionErrors = true;
        return this;
    }

    public ExpectedException handleAssumptionViolatedExceptions() {
        this.handleAssumptionViolatedExceptions = true;
        return this;
    }

    public Statement apply(Statement base, Description description) {
        return new ExpectedExceptionStatement(base);
    }

    public void expect(Matcher<?> matcher) {
        this.fMatcherBuilder.add(matcher);
    }

    public void expect(Class<? extends Throwable> type) {
        this.expect(CoreMatchers.instanceOf(type));
    }

    public void expectMessage(String substring) {
        this.expectMessage((Matcher<String>)CoreMatchers.containsString((String)substring));
    }

    public void expectMessage(Matcher<String> matcher) {
        this.expect(ThrowableMessageMatcher.hasMessage(matcher));
    }

    public void expectCause(Matcher<? super Throwable> expectedCause) {
        this.expect(ThrowableCauseMatcher.hasCause(expectedCause));
    }

    private void failDueToMissingException() throws AssertionError {
        String expectation = StringDescription.toString(this.fMatcherBuilder.build());
        Assert.fail((String)("Expected test to throw " + expectation));
    }

    private void optionallyHandleException(Throwable e, boolean handleException) throws Throwable {
        if (!handleException) {
            throw e;
        }
        this.handleException(e);
    }

    private void handleException(Throwable e) throws Throwable {
        if (!this.fMatcherBuilder.expectsThrowable()) {
            throw e;
        }
        MatcherAssert.assertThat(e, this.fMatcherBuilder.build());
    }

    private class ExpectedExceptionStatement
    extends Statement {
        private final Statement fNext;

        public ExpectedExceptionStatement(Statement base) {
            this.fNext = base;
        }

        public void evaluate() throws Throwable {
            try {
                this.fNext.evaluate();
                if (ExpectedException.this.fMatcherBuilder.expectsThrowable()) {
                    ExpectedException.this.failDueToMissingException();
                }
            }
            catch (AssumptionViolatedException e) {
                ExpectedException.this.optionallyHandleException(e, ExpectedException.this.handleAssumptionViolatedExceptions);
            }
            catch (AssertionError e) {
                ExpectedException.this.optionallyHandleException((Throwable)((Object)e), ExpectedException.this.handleAssertionErrors);
            }
            catch (Throwable e) {
                ExpectedException.this.handleException(e);
            }
        }
    }
}

