/*
 * Decompiled with CFR 0.152.
 */
package hprose.client;

import hprose.client.HproseTcpClient;
import hprose.client.Request;
import hprose.client.Response;
import hprose.client.SocketTransporter;
import hprose.net.Connection;
import hprose.net.TimeoutType;
import hprose.util.concurrent.Timer;
import java.nio.ByteBuffer;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicInteger;

final class FullDuplexSocketTransporter
extends SocketTransporter {
    private static final AtomicInteger nextId = new AtomicInteger(0);
    private final Map<Connection, Map<Integer, Response>> responses = new ConcurrentHashMap<Connection, Map<Integer, Response>>();
    private final Timer timer = new Timer(new Runnable(){

        @Override
        public void run() {
            long currentTime = System.currentTimeMillis();
            for (Map.Entry entry : FullDuplexSocketTransporter.this.responses.entrySet()) {
                Connection conn = (Connection)entry.getKey();
                Map res = (Map)entry.getValue();
                Iterator it = res.entrySet().iterator();
                while (it.hasNext()) {
                    Map.Entry e = it.next();
                    Response response = (Response)e.getValue();
                    if (currentTime - response.createTime < (long)response.timeout) continue;
                    it.remove();
                    response.result.reject(new TimeoutException("timeout"));
                }
                if (!res.isEmpty() || !conn.isConnected()) continue;
                FullDuplexSocketTransporter.this.recycle(conn);
            }
        }
    });

    public FullDuplexSocketTransporter(HproseTcpClient client) {
        super(client);
        this.init();
    }

    private void init() {
        int timeout = Math.min(this.client.getTimeout(), this.client.getConnectTimeout());
        timeout = Math.min(timeout, this.client.getReadTimeout());
        timeout = Math.min(timeout, this.client.getWriteTimeout());
        timeout = Math.max(timeout, 1000);
        this.timer.setInterval(timeout + 1 >> 1);
        this.start();
    }

    private void recycle(Connection conn) {
        conn.setTimeout(this.client.getIdleTimeout(), TimeoutType.IDLE_TIMEOUT);
    }

    @Override
    protected final void send(Connection conn, Request request) {
        Map<Integer, Response> res = this.responses.get(conn);
        if (res != null) {
            if (res.size() < 10) {
                int id = nextId.incrementAndGet() & Integer.MAX_VALUE;
                res.put(id, new Response(request.result, request.timeout));
                conn.send(request.buffer, id);
            } else {
                this.idleConnections.offer(conn);
                this.requests.offer(request);
            }
        }
    }

    @Override
    protected final int geRealPoolSize() {
        return this.responses.size();
    }

    @Override
    public final void close() {
        this.timer.clear();
        this.close(this.responses);
    }

    @Override
    public void onConnect(Connection conn) {
        this.responses.put(conn, new ConcurrentHashMap());
    }

    @Override
    public void onConnected(Connection conn) {
        this.idleConnections.offer(conn);
        this.recycle(conn);
    }

    @Override
    public final void onTimeout(Connection conn, TimeoutType type) {
        block3: {
            Map<Integer, Response> res;
            block2: {
                Request request;
                if (TimeoutType.CONNECT_TIMEOUT != type) break block2;
                this.responses.remove(conn);
                while ((request = (Request)this.requests.poll()) != null) {
                    request.result.reject(new TimeoutException("connect timeout"));
                }
                break block3;
            }
            if (TimeoutType.IDLE_TIMEOUT == type || (res = this.responses.get(conn)) == null) break block3;
            Iterator<Map.Entry<Integer, Response>> it = res.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry<Integer, Response> entry = it.next();
                it.remove();
                Response response = entry.getValue();
                response.result.reject(new TimeoutException(type.toString()));
            }
        }
    }

    @Override
    public final void onReceived(Connection conn, ByteBuffer data, Integer id) {
        Map<Integer, Response> res = this.responses.get(conn);
        if (res != null) {
            Response response = res.remove(id);
            if (response != null) {
                if (data.position() != 0) {
                    data.flip();
                }
                response.result.resolve((Object)data);
            }
            if (res.isEmpty()) {
                this.recycle(conn);
            }
        }
    }

    @Override
    public final void onSended(Connection conn, Integer id) {
        this.idleConnections.offer(conn);
    }

    @Override
    public final void onError(Connection conn, Exception e) {
        Map<Integer, Response> res = this.responses.remove(conn);
        if (res != null) {
            Iterator<Map.Entry<Integer, Response>> it = res.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry<Integer, Response> entry = it.next();
                it.remove();
                Response response = entry.getValue();
                response.result.reject(e);
            }
        }
    }
}

