/*
 * Decompiled with CFR 0.152.
 */
package hprose.io.unserialize;

import hprose.io.unserialize.BaseUnserializer;
import hprose.io.unserialize.Reader;
import hprose.io.unserialize.ReferenceReader;
import hprose.io.unserialize.ValueReader;
import java.io.IOException;
import java.lang.reflect.Type;

public final class ByteArrayUnserializer
extends BaseUnserializer<byte[]> {
    public static final ByteArrayUnserializer instance = new ByteArrayUnserializer();

    @Override
    public byte[] unserialize(Reader reader, int tag, Type type) throws IOException {
        switch (tag) {
            case 101: {
                return new byte[0];
            }
            case 98: {
                return ReferenceReader.readBytes(reader);
            }
            case 97: {
                return ReferenceReader.readByteArray(reader);
            }
            case 117: {
                return ValueReader.readUTF8Char(reader).getBytes("UTF-8");
            }
            case 115: {
                return ReferenceReader.readString(reader).getBytes("UTF-8");
            }
        }
        return (byte[])super.unserialize(reader, tag, type);
    }

    public byte[] read(Reader reader) throws IOException {
        return (byte[])this.read(reader, (Type)((Object)byte[].class));
    }
}

