/*
 * Decompiled with CFR 0.152.
 */
package hprose.client;

import hprose.client.HproseTcpClient;
import hprose.client.Request;
import hprose.client.Response;
import hprose.client.SocketTransporter;
import hprose.net.Connection;
import hprose.net.TimeoutType;
import hprose.util.concurrent.Timer;
import java.nio.ByteBuffer;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeoutException;

final class HalfDuplexSocketTransporter
extends SocketTransporter {
    private static final Response nullResponse = new Response(null, 0);
    private final Map<Connection, Response> responses = new ConcurrentHashMap<Connection, Response>();
    private final Timer timer = new Timer(new Runnable(){

        @Override
        public void run() {
            long currentTime = System.currentTimeMillis();
            Iterator it = HalfDuplexSocketTransporter.this.responses.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry entry = it.next();
                Connection conn = (Connection)entry.getKey();
                Response response = (Response)entry.getValue();
                if (currentTime - response.createTime < (long)response.timeout) continue;
                it.remove();
                response.result.reject(new TimeoutException("timeout"));
                conn.close();
            }
        }
    });

    public HalfDuplexSocketTransporter(HproseTcpClient client) {
        super(client);
        this.init();
    }

    private void init() {
        int timeout = Math.min(this.client.getTimeout(), this.client.getConnectTimeout());
        timeout = Math.min(timeout, this.client.getReadTimeout());
        timeout = Math.min(timeout, this.client.getWriteTimeout());
        timeout = Math.max(timeout, 1000);
        this.timer.setInterval(timeout + 1 >> 1);
        this.start();
    }

    private void recycle(Connection conn) {
        this.idleConnections.offer(conn);
        conn.setTimeout(this.client.getIdleTimeout(), TimeoutType.IDLE_TIMEOUT);
    }

    @Override
    protected final void send(Connection conn, Request request) {
        this.responses.put(conn, new Response(request.result, request.timeout));
        conn.send(request.buffer, null);
    }

    @Override
    protected final int geRealPoolSize() {
        return this.responses.size();
    }

    @Override
    public final void close() {
        this.timer.clear();
        this.close(this.responses);
    }

    @Override
    public void onConnect(Connection conn) {
        this.responses.put(conn, nullResponse);
    }

    @Override
    public void onConnected(Connection conn) {
        this.recycle(conn);
    }

    @Override
    public final void onTimeout(Connection conn, TimeoutType type) {
        Response response;
        if (TimeoutType.CONNECT_TIMEOUT == type) {
            Request request;
            this.responses.remove(conn);
            while ((request = (Request)this.requests.poll()) != null) {
                request.result.reject(new TimeoutException("connect timeout"));
            }
        } else if (TimeoutType.IDLE_TIMEOUT != type && (response = this.responses.put(conn, nullResponse)) != null && response != nullResponse) {
            response.result.reject(new TimeoutException(type.toString()));
        }
        conn.close();
    }

    @Override
    public final void onReceived(Connection conn, ByteBuffer data, Integer id) {
        Response response = this.responses.put(conn, nullResponse);
        this.recycle(conn);
        if (response != null && response != nullResponse) {
            if (data.position() != 0) {
                data.flip();
            }
            response.result.resolve((Object)data);
        }
    }

    @Override
    public final void onSended(Connection conn, Integer id) {
    }

    @Override
    public final void onError(Connection conn, Exception e) {
        Response response = this.responses.remove(conn);
        if (response != null && response != nullResponse) {
            response.result.reject(e);
        }
    }
}

