/*
 * Decompiled with CFR 0.152.
 */
package hprose.client;

import hprose.client.HproseTcpClient;
import hprose.client.Request;
import hprose.net.Connection;
import hprose.net.ConnectionHandler;
import hprose.net.Connector;
import hprose.util.concurrent.Promise;
import hprose.util.concurrent.Threads;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.ClosedChannelException;
import java.util.Map;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;

abstract class SocketTransporter
extends Thread
implements ConnectionHandler {
    protected final HproseTcpClient client;
    protected final BlockingQueue<Connection> idleConnections = new LinkedBlockingQueue<Connection>();
    protected final BlockingQueue<Request> requests = new LinkedBlockingQueue<Request>();
    protected final AtomicInteger size = new AtomicInteger(0);

    public SocketTransporter(HproseTcpClient client) {
        this.client = client;
    }

    @Override
    public final int getReadTimeout() {
        return this.client.getReadTimeout();
    }

    @Override
    public final int getWriteTimeout() {
        return this.client.getWriteTimeout();
    }

    @Override
    public final int getConnectTimeout() {
        return this.client.getConnectTimeout();
    }

    @Override
    public void run() {
        try {
            while (!this.isInterrupted()) {
                Connection conn;
                Request request;
                if (this.requests.isEmpty()) {
                    request = this.requests.take();
                    this.requests.offer(request);
                }
                if (this.idleConnections.isEmpty() && this.geRealPoolSize() < this.client.getMaxPoolSize()) {
                    try {
                        ConnectorHolder.connector.create(this.client.uri, this, this.client.isKeepAlive(), this.client.isNoDelay());
                    }
                    catch (IOException ex) {
                        while ((request = (Request)this.requests.poll()) != null) {
                            request.result.reject(ex);
                        }
                    }
                }
                if ((conn = this.idleConnections.poll(this.client.getConnectTimeout(), TimeUnit.MILLISECONDS)) == null) continue;
                request = (Request)this.requests.poll();
                if (request == null) {
                    request = this.requests.take();
                }
                this.send(conn, request);
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    protected abstract int geRealPoolSize();

    protected abstract void send(Connection var1, Request var2);

    public final synchronized Promise<ByteBuffer> send(ByteBuffer buffer, int timeout) {
        Request request = new Request(buffer, timeout);
        this.requests.offer(request);
        return request.result;
    }

    protected void close(Map<Connection, Object> responses) {
        this.interrupt();
        while (!responses.isEmpty()) {
            for (Connection conn : responses.keySet()) {
                conn.close();
            }
        }
        while (!this.requests.isEmpty()) {
            ((Request)this.requests.poll()).result.reject(new ClosedChannelException());
        }
    }

    @Override
    public final void onClose(Connection conn) {
        this.idleConnections.remove(conn);
        this.onError(conn, new ClosedChannelException());
    }

    public abstract void close();

    protected static final class ConnectorHolder {
        static final Connector connector;

        protected ConnectorHolder() {
        }

        static {
            Connector temp = null;
            try {
                temp = new Connector(HproseTcpClient.getReactorThreads());
            }
            catch (IOException iOException) {
            }
            finally {
                connector = temp;
                connector.start();
            }
            Threads.registerShutdownHandler(new Runnable(){

                @Override
                public void run() {
                    if (connector != null) {
                        connector.close();
                    }
                }
            });
        }
    }
}

